/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.formula.ExpressionParameter;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.ext.tmc.utils.commitToBe.helper.EmptyUtil;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.botp.convert.ConvertContext;
import kd.bos.service.botp.convert.SingleRuleContext;
import kd.bos.service.botp.convert.compiler.CRConditionCompiler;
import kd.bos.service.botp.convert.compiler.ConvertRuleCompiler;
import kd.bos.service.botp.convert.getvaluemode.GetConstValue;
import kd.bos.service.botp.convert.getvaluemode.IGetValueMode;
import kd.bos.service.botp.convert.var.IVariableMode;
import kd.bos.service.botp.convert.var.SourceFieldVariable;
import kd.bos.servicehelper.QueryServiceHelper;

public class ConditionFactory {
    private static final Log logger = LogFactory.getLog(ConditionFactory.class);
    protected ConvertContext context;
    protected SingleRuleContext ruleContext;
    private static final String DOT = ".";

    public void init(CRCondition conditionObj, String entityName) {
        ConvertContext context = new ConvertContext();
        BillEntityType srcMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
        context.setSourceMainType(srcMainType);
        ConvertRuleElement rule = new ConvertRuleElement();
        rule.setRunCondition(conditionObj);
        SingleRuleContext ruleContext = new SingleRuleContext();
        ruleContext.setContext(context);
        ruleContext.setRule(rule);
        ConvertRuleCompiler ruleCompiler = new ConvertRuleCompiler(ruleContext);
        ruleContext.setRuleCompiler(ruleCompiler);
        this.context = context;
        this.ruleContext = ruleContext;
    }

    public void init(ConvertContext context, SingleRuleContext ruleContext) {
        this.context = context;
        this.ruleContext = ruleContext;
    }

    private Set<Long> getIdsOnlyGridFilter(CRConditionCompiler runCondCompiler, Set<Long> srcBillIds) {
        BillEntityType srcMainType = this.context.getSourceMainType();
        String entityNumber = srcMainType.getName();
        QFilter idFilter = new QFilter("id", "in", (Object)srcBillIds.toArray());
        runCondCompiler.getGridQFilters().add(idFilter);
        Object[] filters = runCondCompiler.getGridQFilters().toArray(new QFilter[0]);
        logger.info("getIdsOnlyGridFilter:" + Arrays.toString(filters));
        DynamicObjectCollection col = QueryServiceHelper.query((String)entityNumber, (String)"id", (QFilter[])filters);
        for (DynamicObject co : col) {
            logger.info("\u5904\u7406\u540e\u7684ID:" + co.getLong("id"));
        }
        Set<Long> ids = col.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
        logger.info("ids:" + ids.size());
        return ids;
    }

    public Set<Long> runCondition(Set<Long> srcBillIds) {
        ConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
        CRConditionCompiler runCondCompiler = ruleCompiler.compileRunCondition();
        if (runCondCompiler.getGridQFilters().isEmpty() && runCondCompiler.getExpressionExecuter() instanceof GetConstValue && ((Boolean)((GetConstValue)runCondCompiler.getExpressionExecuter()).getConstValue()).booleanValue()) {
            return srcBillIds;
        }
        if (!runCondCompiler.getGridQFilters().isEmpty() && runCondCompiler.getExpressionExecuter() instanceof GetConstValue && ((Boolean)((GetConstValue)runCondCompiler.getExpressionExecuter()).getConstValue()).booleanValue()) {
            return this.getIdsOnlyGridFilter(runCondCompiler, srcBillIds);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        BillEntityType srcMainType = this.context.getSourceMainType();
        String entityNumber = srcMainType.getName();
        String pkFieldName = srcMainType.getPrimaryKey().getName();
        HashMap<String, String> fieldAlias = new HashMap<String, String>();
        ArrayList<String> selectFields = new ArrayList<String>();
        fieldAlias.put(pkFieldName, pkFieldName);
        selectFields.add(pkFieldName);
        IGetValueMode expressExecutor = runCondCompiler.getExpressionExecuter();
        IGetValueMode gridFilterExecutor = this.ruleContext.getRuleCompiler().getRuleCondCompiler().getGridFilterExecuter();
        this.addSourceFields(expressExecutor.getVars(), selectFields, fieldAlias);
        this.addSourceFields(gridFilterExecutor.getVars(), selectFields, fieldAlias);
        String selectString = StringUtils.join((Object[])selectFields.toArray(), (String)",");
        QFilter idFilter = new QFilter("id", "in", (Object)srcBillIds.toArray());
        qFilters.add(idFilter);
        QFilter[] arrQFilters = new QFilter[qFilters.size()];
        arrQFilters = qFilters.toArray(arrQFilters);
        ORM orm = ORM.create();
        DynamicObjectCollection rows = null;
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectString, arrQFilters);){
            rows = orm.toPlainDynamicObjectCollection(ds);
        }
        HashMap<String, DynamicProperty> fieldPropertys = new HashMap<String, DynamicProperty>(fieldAlias.size());
        DynamicObjectType dType = rows.getDynamicObjectType();
        for (Map.Entry entry : fieldAlias.entrySet()) {
            String fldKey = (String)entry.getKey();
            String fldAlias = (String)entry.getValue();
            DynamicProperty property = (DynamicProperty)dType.getProperties().get((Object)fldAlias);
            fieldPropertys.put(fldKey, property);
        }
        HashMap<String, Long> memIdSet = new HashMap<String, Long>(srcBillIds.size());
        for (Long id : srcBillIds) {
            String idString = String.valueOf(id);
            memIdSet.put(idString, id);
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        for (DynamicObject row : rows) {
            if (!((Boolean)expressExecutor.getValue(fieldPropertys, row)).booleanValue() || !((Boolean)gridFilterExecutor.getValue(fieldPropertys, row)).booleanValue()) continue;
            Object billId = row.get(pkFieldName);
            String idString = String.valueOf(billId);
            Long memBillId = (Long)memIdSet.get(idString);
            hashSet.add(memBillId);
        }
        return hashSet;
    }

    public Map<String, BigDecimal> runCondition(Set<Long> srcBillIds, String amtFieldProp, String entryIdFieldProp) {
        HashMap<String, BigDecimal> myBillIds = new HashMap<String, BigDecimal>();
        ConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
        CRConditionCompiler runCondCompiler = ruleCompiler.compileRunCondition();
        BillEntityType srcMainType = this.context.getSourceMainType();
        String entityNumber = srcMainType.getName();
        String pkFieldName = srcMainType.getPrimaryKey().getName();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
        QFilter idFilter = new QFilter("id", "in", (Object)srcBillIds.toArray());
        qFilters.add(idFilter);
        QFilter[] arrQFilters = new QFilter[qFilters.size()];
        arrQFilters = qFilters.toArray(arrQFilters);
        if (runCondCompiler.getGridQFilters().isEmpty() && runCondCompiler.getExpressionExecuter() instanceof GetConstValue && ((Boolean)((GetConstValue)runCondCompiler.getExpressionExecuter()).getConstValue()).booleanValue()) {
            ORM orm = ORM.create();
            DynamicObjectCollection rows = null;
            try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, entryIdFieldProp + "," + amtFieldProp, arrQFilters);){
                rows = orm.toPlainDynamicObjectCollection(ds);
            }
            for (DynamicObject row : rows) {
                Object entryId = row.get(entryIdFieldProp);
                Object amt = row.get(amtFieldProp);
                myBillIds.put(String.valueOf(entryId), new BigDecimal(String.valueOf(amt)));
            }
            return myBillIds;
        }
        HashMap<String, String> fieldAlias = new HashMap<String, String>();
        ArrayList<String> selectFields = new ArrayList<String>();
        fieldAlias.put(pkFieldName, pkFieldName);
        fieldAlias.put(amtFieldProp, amtFieldProp);
        fieldAlias.put(entryIdFieldProp, entryIdFieldProp);
        selectFields.add(pkFieldName);
        selectFields.add(amtFieldProp);
        selectFields.add(entryIdFieldProp);
        IGetValueMode expressExecutor = runCondCompiler.getExpressionExecuter();
        IGetValueMode gridFilterExecutor = this.ruleContext.getRuleCompiler().getRuleCondCompiler().getGridFilterExecuter();
        this.addSourceFields(expressExecutor.getVars(), selectFields, fieldAlias);
        this.addSourceFields(gridFilterExecutor.getVars(), selectFields, fieldAlias);
        String selectString = StringUtils.join((Object[])selectFields.toArray(), (String)",");
        ORM orm = ORM.create();
        DynamicObjectCollection rows = null;
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectString, arrQFilters);){
            rows = orm.toPlainDynamicObjectCollection(ds);
        }
        HashMap<String, DynamicProperty> fieldPropertys = new HashMap<String, DynamicProperty>(fieldAlias.size());
        DynamicObjectType dType = rows.getDynamicObjectType();
        for (Map.Entry aliasItem : fieldAlias.entrySet()) {
            String fldKey = (String)aliasItem.getKey();
            String fldAlias = (String)aliasItem.getValue();
            DynamicProperty property = (DynamicProperty)dType.getProperties().get((Object)fldAlias);
            fieldPropertys.put(fldKey, property);
        }
        for (DynamicObject row : rows) {
            if (!((Boolean)expressExecutor.getValue(fieldPropertys, row)).booleanValue() || !((Boolean)gridFilterExecutor.getValue(fieldPropertys, row)).booleanValue()) continue;
            Object entryId = row.get(entryIdFieldProp);
            Object amt = row.get(amtFieldProp);
            myBillIds.put(String.valueOf(entryId), new BigDecimal(String.valueOf(amt)));
        }
        return myBillIds;
    }

    public Boolean isMatchCondition(DynamicObject row) {
        ConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
        CRConditionCompiler runCondCompiler = ruleCompiler.compileRunCondition();
        if (runCondCompiler.getGridQFilters().isEmpty() && runCondCompiler.getExpressionExecuter() instanceof GetConstValue && ((Boolean)((GetConstValue)runCondCompiler.getExpressionExecuter()).getConstValue()).booleanValue()) {
            return true;
        }
        BillEntityType srcMainType = this.context.getSourceMainType();
        String pkFieldName = srcMainType.getPrimaryKey().getName();
        HashMap<String, String> fieldAlias = new HashMap<String, String>();
        fieldAlias.put(pkFieldName, pkFieldName);
        IGetValueMode expressExecutor = runCondCompiler.getExpressionExecuter();
        IGetValueMode gridFilterExecutor = this.ruleContext.getRuleCompiler().getRuleCondCompiler().getGridFilterExecuter();
        for (IVariableMode var : expressExecutor.getVars()) {
            if (!(var instanceof SourceFieldVariable)) continue;
            fieldAlias.put(var.getVar(), var.getVar());
        }
        for (IVariableMode var : gridFilterExecutor.getVars()) {
            if (!(var instanceof SourceFieldVariable)) continue;
            fieldAlias.put(var.getVar(), var.getVar());
        }
        HashMap<String, DynamicProperty> fieldPropertys = new HashMap<String, DynamicProperty>(fieldAlias.size());
        DynamicObjectType dType = row.getDynamicObjectType();
        for (Map.Entry aliasItem : fieldAlias.entrySet()) {
            String fldKey = (String)aliasItem.getKey();
            String fldAlias = (String)aliasItem.getValue();
            DynamicProperty property = (DynamicProperty)dType.getProperties().get((Object)fldAlias);
            fieldPropertys.put(fldKey, property);
        }
        if (expressExecutor.getValue(fieldPropertys, row) == null || gridFilterExecutor.getValue(fieldPropertys, row) == null) {
            return false;
        }
        if (((Boolean)expressExecutor.getValue(fieldPropertys, row)).booleanValue() && ((Boolean)gridFilterExecutor.getValue(fieldPropertys, row)).booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean isMatchCondition(CRCondition condition, DynamicObject row) {
        MainEntityType mainEntityType = (MainEntityType)row.getDataEntityType();
        FilterCondition filterCondition = condition.getFilterCondition();
        FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition);
        String[] scripts = filterBuilder.buildFilterScript();
        String expression = scripts[0];
        RowDataModel rowDataModel = new RowDataModel(mainEntityType.getName(), mainEntityType);
        ExpressionParameter expressionParameter = new ExpressionParameter(expression, rowDataModel);
        Set vars = expressionParameter.getBOSExpression().getVars();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        for (String fieldName : vars) {
            Object value = row.get(fieldName);
            if (value instanceof OrmLocaleValue) {
                params.put(fieldName, ((OrmLocaleValue)value).getLocaleValue());
                continue;
            }
            params.put(fieldName, value);
        }
        return (Boolean)FormulaEngine.execExcelFormula((String)expression, params);
    }

    private void addSourceFields(List<IVariableMode> vars, List<String> selectFldStrings, Map<String, String> fieldAlias) {
        int fieldIndex = fieldAlias.size();
        for (IVariableMode var : vars) {
            if (!(var instanceof SourceFieldVariable) || fieldAlias.containsKey(var.getVar())) continue;
            SourceFieldVariable srcField = (SourceFieldVariable)var;
            String fldAlias = "f" + fieldIndex;
            String selectFldString = srcField.getFullPropName() + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            fieldAlias.put(var.getVar(), fldAlias);
            ++fieldIndex;
        }
    }

    public List<String> getAllFields(CRCondition targetCondition) {
        Set fields = Optional.ofNullable(targetCondition.getFilterCondition().getFilterRow()).orElseGet(Collections::emptyList).stream().map(SimpleFilterRow::getFieldName).collect(Collectors.toSet());
        fields.add("id");
        return new ArrayList<String>(fields);
    }

    public DynamicObject convertToPlainObject(DynamicObject bill, List<String> fields) {
        DynamicObjectType dt = new DynamicObjectType("PlainObject");
        DynamicObject obj = new DynamicObject(dt, true);
        obj.beginInit();
        for (String field : fields) {
            Class<?> propertyType = this.getPropertyType(field, bill);
            if (propertyType == null) continue;
            DynamicSimpleProperty property = new DynamicSimpleProperty(field, propertyType, null);
            dt.registerSimpleProperty(property);
            Object val = ILocaleString.class.equals((Object)property.getPropertyType()) ? bill.getString(field) : bill.get(field);
            property.setValueFast((Object)obj, val);
        }
        obj.endInit();
        return obj;
    }

    public Class<?> getPropertyType(String field, DynamicObject bill) {
        int idx = field.indexOf(DOT);
        if (idx < 0) {
            IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)field);
            if (EmptyUtil.isNoEmpty(iDataEntityProperty)) {
                return iDataEntityProperty.getPropertyType();
            }
            return null;
        }
        DynamicObject dynamicObject = bill.getDynamicObject(field.substring(0, idx));
        if (EmptyUtil.isNoEmpty(dynamicObject)) {
            return this.getPropertyType(field.substring(idx + 1), dynamicObject);
        }
        return null;
    }
}

