/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.tmc.utils.helper.fbd;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.ext.tmc.utils.helper.ConditionFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;

public class AttachTypeHelper {
    private static final Log LOGGER = LogFactory.getLog(AttachTypeHelper.class);
    private static AttachTypeHelper INSTANCE;

    private AttachTypeHelper() {
    }

    public static synchronized AttachTypeHelper getInstance() {
        if (null == INSTANCE) {
            INSTANCE = new AttachTypeHelper();
        }
        return INSTANCE;
    }

    public DynamicObject getMatchAttachment(DynamicObject bill) {
        String billType = bill.getDataEntityType().getName();
        List settingList = QueryServiceHelper.query((String)"fbd_attachmenttype", (String)"id,savecondition_tag", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("billentity", "=", (Object)billType)}).stream().filter(t -> this.isFilterBill(t.getString("savecondition_tag"), bill)).collect(Collectors.toList());
        if (settingList.size() == 1) {
            return (DynamicObject)settingList.get(0);
        }
        return null;
    }

    public boolean isFilterBill(String filterStr, DynamicObject bill) {
        if (StringUtils.isBlank((CharSequence)filterStr)) {
            return true;
        }
        CRCondition targetCondition = (CRCondition)SerializationUtils.fromJsonString((String)filterStr, CRCondition.class);
        ConditionFactory conditionFactory = new ConditionFactory();
        conditionFactory.init(targetCondition, bill.getDataEntityType().getName());
        DynamicObject obj = conditionFactory.convertToPlainObject(bill, conditionFactory.getAllFields(targetCondition));
        return conditionFactory.isMatchCondition(obj);
    }

    public String getUid() {
        StringBuilder uid = new StringBuilder("rc-upload-");
        uid.append(new Date().getTime());
        uid.append("-");
        SecureRandom RANDOM = null;
        int index = 1000;
        try {
            RANDOM = SecureRandom.getInstance("SHA1PRNG");
            index = (int)(1.0 + (double)RANDOM.nextInt(10000) * 10.0);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        uid.append(index);
        return uid.toString();
    }

    public Map<String, Object> getFileInfo(DynamicObject attach) {
        HashMap<String, Object> fileInfo = new HashMap<String, Object>(10);
        fileInfo.put("name", attach.getString("name"));
        String url = attach.getString("url");
        fileInfo.put("previewurl", UrlService.getAttachmentPreviewUrl((String)url));
        fileInfo.put("size", attach.getLong("size"));
        fileInfo.put("status", "success");
        fileInfo.put("type", attach.getString("type"));
        fileInfo.put("uid", attach.getString("uid"));
        fileInfo.put("url", UrlService.getAttachmentDownloadUrl((String)url));
        return fileInfo;
    }
}

