/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class RequireTypeHelper {
    private static final Log logger = LogFactory.getLog(RequireTypeHelper.class);
    private static final String ALGO_KEY = RequireTypeHelper.class.getName();
    public static final String GZ004 = "GZ004";
    public static final String GZ005 = "GZ005";
    public static final String GZ007 = "GZ007";
    public static final String GZ009 = "GZ009";
    private static final String DOT = ".";
    private static final String ID_SUFFIX = ".id";

    public static Map<Long, Set<Long>> queryRequireTypeRange(Set<Long> manuStrGroupIdSet) {
        HashMap<Long, Set<Long>> requireTypeRangeMap = new HashMap<Long, Set<Long>>(manuStrGroupIdSet.size());
        Map<Long, Set<Long>> manuStrategyMap = RequireTypeHelper.queryManuStrategyMap(manuStrGroupIdSet);
        HashSet<Long> allManuStrategyIdSet = new HashSet<Long>(manuStrGroupIdSet.size());
        for (Set<Long> manuStrategyIdSet : manuStrategyMap.values()) {
            allManuStrategyIdSet.addAll(manuStrategyIdSet);
        }
        if (allManuStrategyIdSet.isEmpty()) {
            return requireTypeRangeMap;
        }
        Map<Long, Long> requireTypeMap = RequireTypeHelper.queryRequireTypeMap(allManuStrategyIdSet);
        HashSet<Long> allRequireTypeIdSet = new HashSet<Long>(requireTypeMap.size());
        allRequireTypeIdSet.addAll(requireTypeMap.values());
        if (allRequireTypeIdSet.isEmpty()) {
            return requireTypeRangeMap;
        }
        Set<Long> enableRequireTypeIdSet = RequireTypeHelper.queryEnableRequireTypeIdSet(allRequireTypeIdSet);
        if (enableRequireTypeIdSet.isEmpty()) {
            return requireTypeRangeMap;
        }
        for (Long manuStrGroupId : manuStrGroupIdSet) {
            Set<Long> manuStrategyIdSet = manuStrategyMap.get(manuStrGroupId);
            if (manuStrategyIdSet == null || manuStrategyIdSet.isEmpty()) continue;
            for (Long manuStrategyId : manuStrategyIdSet) {
                Long requireTypeId = requireTypeMap.get(manuStrategyId);
                if (!enableRequireTypeIdSet.contains(requireTypeId)) continue;
                Set requireTypeIdSet = requireTypeRangeMap.computeIfAbsent(manuStrGroupId, v -> new HashSet(16));
                requireTypeIdSet.add(requireTypeId);
            }
        }
        return requireTypeRangeMap;
    }

    private static Set<Long> queryEnableRequireTypeIdSet(Set<Long> requireTypeIdSet) {
        HashSet<Long> enableRequireTypeIdSet = new HashSet<Long>(requireTypeIdSet.size());
        QFilter[] requireTypeFilters = new QFilter[]{new QFilter("id", "in", requireTypeIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DataSet requireTypeDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_requiretype", (String)"id", (QFilter[])requireTypeFilters, null);
        for (Row row : requireTypeDataSet) {
            Long requireTypeId = row.getLong("id");
            enableRequireTypeIdSet.add(requireTypeId);
        }
        return enableRequireTypeIdSet;
    }

    private static Map<Long, Long> queryRequireTypeMap(Set<Long> manuStrategyIdSet) {
        HashMap<Long, Long> requireTypeMap = new HashMap<Long, Long>(manuStrategyIdSet.size());
        QFilter[] manuStrategyFilters = new QFilter[]{new QFilter("id", "in", manuStrategyIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DataSet manuStrategyDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_manustrategy", (String)"id, requiretype", (QFilter[])manuStrategyFilters, null);
        for (Row row : manuStrategyDataSet) {
            Long manuStrategyId = row.getLong("id");
            Long requireTypeId = row.getLong("requiretype");
            requireTypeMap.put(manuStrategyId, requireTypeId);
        }
        return requireTypeMap;
    }

    private static Map<Long, Set<Long>> queryManuStrategyMap(Set<Long> manuStrGroupIdSet) {
        HashMap<Long, Set<Long>> manuStrategyMap = new HashMap<Long, Set<Long>>(manuStrGroupIdSet.size());
        QFilter[] manuStrGroupFilters = new QFilter[]{new QFilter("id", "in", manuStrGroupIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DataSet manuStrGroupDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_manustrategygroup", (String)"id, entryentity.manustrategy", (QFilter[])manuStrGroupFilters, null);
        for (Row row : manuStrGroupDataSet) {
            Long manuStrGroupId = row.getLong("id");
            Long manuStrategyId = row.getLong("entryentity.manustrategy");
            Set idSet = manuStrategyMap.computeIfAbsent(manuStrGroupId, v -> new HashSet(16));
            idSet.add(manuStrategyId);
        }
        return manuStrategyMap;
    }

    public static Map<Long, DynamicObject> queryPriorityRequireType(Set<Long> manuStrGroupIdSet, QFilter aloneDemandtypeFilter) {
        HashMap<Long, Long> manuStrategyMap = new HashMap<Long, Long>(manuStrGroupIdSet.size());
        HashMap<Long, DynamicObject> manuStrategyGroupRequireTypeMap = new HashMap<Long, DynamicObject>(manuStrGroupIdSet.size());
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("status", "=", (Object)"C"));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        Map requireTypes = BusinessDataServiceHelper.loadFromCache((String)"bd_requiretype", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        qFilters.add(new QFilter("entryentity.manustrategy.status", "=", (Object)"C"));
        qFilters.add(new QFilter("entryentity.manustrategy.enable", "=", (Object)"1"));
        qFilters.add(new QFilter("id", "in", manuStrGroupIdSet));
        if (aloneDemandtypeFilter != null) {
            qFilters.add(aloneDemandtypeFilter);
        }
        HashMap<Long, Integer> lastPriorityMap = new HashMap<Long, Integer>(16);
        try (DataSet manuStrGroupDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_manustrategygroup", (String)"id, entryentity.manustrategy.requiretype,entryentity.priority", (QFilter[])qFilters.toArray(new QFilter[0]), null);){
            for (Row row : manuStrGroupDataSet) {
                Integer lastPriority;
                Long manuStrGroupId = row.getLong("id");
                int priority = row.getInteger("entryentity.priority");
                if (priority < (lastPriority = lastPriorityMap.getOrDefault(manuStrGroupId, 0))) continue;
                manuStrategyMap.put(manuStrGroupId, row.getLong("entryentity.manustrategy.requiretype"));
                lastPriorityMap.put(manuStrGroupId, priority);
            }
        }
        Iterator iterator = manuStrategyMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = iterator.next();
            if (StringUtils.isBlank(next.getValue())) continue;
            if (!requireTypes.containsKey(next.getValue())) {
                iterator.remove();
                continue;
            }
            manuStrategyGroupRequireTypeMap.put((Long)next.getKey(), requireTypes.getOrDefault(next.getValue(), null));
        }
        return manuStrategyGroupRequireTypeMap;
    }

    public static Map<Long, Long> queryManuStrGroup(Set<Long> materialInvSet) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", materialInvSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        String selectFields = "id, manustrategygroup";
        DataSet materialInvDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_materialinventoryinfo", (String)selectFields, (QFilter[])filters, null);
        HashMap<Long, Long> manuStrGroupMap = new HashMap<Long, Long>(16);
        for (Row row : materialInvDataSet) {
            Long materialInvId = row.getLong("id");
            Long manuStrGroupId = row.getLong("manustrategygroup");
            manuStrGroupMap.put(materialInvId, manuStrGroupId);
        }
        return manuStrGroupMap;
    }

    public static Map<String, Long> queryManuStrGroup(Long orgId, Set<Long> materialIdSet) {
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
        QFilter[] filters = new QFilter[]{baseDataFilter, new QFilter("masterid", "in", materialIdSet), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        String selectFields = "id, createorg, masterid, manustrategygroup";
        DataSet materialInvDataSet = QueryServiceHelper.queryDataSet((String)ALGO_KEY, (String)"bd_materialinventoryinfo", (String)selectFields, (QFilter[])filters, null);
        HashMap<String, Long> manuStrGroupMap = new HashMap<String, Long>(16);
        for (Row row : materialInvDataSet) {
            Long createOrgId = row.getLong("createorg");
            Long materialId = row.getLong("masterid");
            Long manuStrGroupId = row.getLong("manustrategygroup");
            String keyStr = RequireTypeHelper.buildMapKey(orgId, materialId);
            if (!orgId.equals(createOrgId) && manuStrGroupMap.containsKey(keyStr)) continue;
            manuStrGroupMap.put(keyStr, manuStrGroupId);
        }
        return manuStrGroupMap;
    }

    public static String buildMapKey(long orgId, long materialId) {
        return String.format("%1$s_%2$s", orgId, materialId);
    }

    public static Map<String, String> parsingManuStrategyDimKey(String entityName, DynamicObject manuStrConfig, String requireTypeKey) {
        List<Map<String, String>> dimKeyList = RequireTypeHelper.parsingManuStrategyDimKey(entityName, manuStrConfig);
        for (Map<String, String> dimMap : dimKeyList) {
            String fieldKey = dimMap.getOrDefault(GZ009, "");
            if (!fieldKey.contains(requireTypeKey)) continue;
            return dimMap;
        }
        HashMap<String, String> dimMap = new HashMap<String, String>(8);
        dimMap.put(GZ007, "");
        dimMap.put(GZ005, "");
        dimMap.put(GZ004, "");
        dimMap.put(GZ009, "");
        return dimMap;
    }

    public static List<Map<String, String>> parsingManuStrategyDimKey(String entityName, DynamicObject manuStrConfig) {
        ArrayList<Map<String, String>> dimList = new ArrayList<Map<String, String>>(10);
        DynamicObjectCollection entryEntity = manuStrConfig.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryRow : entryEntity) {
            String billEntityName;
            DynamicObject billEntity = entryRow.getDynamicObject("billentity");
            if (billEntity == null || !entityName.equals(billEntityName = billEntity.getPkValue().toString())) continue;
            DynamicObjectCollection subEntryEntity = entryRow.getDynamicObjectCollection("subentryentity");
            boolean isMatchDim = false;
            for (DynamicObject subEntryRow : subEntryEntity) {
                String dimNumber;
                DynamicObject dimension = subEntryRow.getDynamicObject("dimension");
                if (dimension == null || !GZ009.equals(dimNumber = dimension.getString("number"))) continue;
                isMatchDim = true;
                break;
            }
            if (!isMatchDim) continue;
            String materialKey = "";
            String orgKey = "";
            String materialInvKey = "";
            String requireTypeKey = "";
            for (DynamicObject subEntryRow : subEntryEntity) {
                DynamicObject dimension = subEntryRow.getDynamicObject("dimension");
                if (dimension == null) continue;
                String dimNumber = dimension.getString("number");
                if (GZ007.equals(dimNumber)) {
                    materialInvKey = subEntryRow.getString("field");
                    continue;
                }
                if (GZ005.equals(dimNumber)) {
                    materialKey = subEntryRow.getString("field");
                    continue;
                }
                if (GZ004.equals(dimNumber)) {
                    orgKey = subEntryRow.getString("field");
                    continue;
                }
                if (!GZ009.equals(dimNumber)) continue;
                requireTypeKey = subEntryRow.getString("field");
            }
            HashMap<String, String> dimMap = new HashMap<String, String>(8);
            dimMap.put(GZ007, materialInvKey);
            dimMap.put(GZ005, materialKey);
            dimMap.put(GZ004, orgKey);
            dimMap.put(GZ009, requireTypeKey);
            dimList.add(dimMap);
        }
        return dimList;
    }

    public static void recursiveCollectDimValue(DynamicObject parent, String fieldKey, Map<String, Integer> entryIndexMap, Map<String, String> dimMap, DynamicObject bill, Map<Long, Set<Long>> orgMaterialMap, Set<Long> materialInvSet) {
        if (!fieldKey.contains(DOT)) {
            RequireTypeHelper.collectDimValue(dimMap, entryIndexMap, bill, orgMaterialMap, materialInvSet);
            return;
        }
        int index = fieldKey.indexOf(DOT);
        String subFieldKey = fieldKey.substring(0, index);
        Object obj = parent.get(subFieldKey);
        fieldKey = fieldKey.substring(index + 1);
        if (obj instanceof DynamicObject) {
            RequireTypeHelper.recursiveCollectDimValue((DynamicObject)obj, fieldKey, entryIndexMap, dimMap, bill, orgMaterialMap, materialInvSet);
        } else if (obj instanceof DynamicObjectCollection) {
            DynamicObjectCollection entry = (DynamicObjectCollection)obj;
            for (int i = 0; i < entry.size(); ++i) {
                entryIndexMap.put(subFieldKey, i);
                DynamicObject row = (DynamicObject)entry.get(i);
                RequireTypeHelper.recursiveCollectDimValue(row, fieldKey, entryIndexMap, dimMap, bill, orgMaterialMap, materialInvSet);
            }
        }
    }

    public static void collectDimValue(Map<String, String> dimMap, Map<String, Integer> entryIndexMap, DynamicObject bill, Map<Long, Set<Long>> orgMaterialMap, Set<Long> materialInvSet) {
        Map<String, Object> dimValueMap = RequireTypeHelper.getDimValue(dimMap, entryIndexMap, bill);
        Object materialInvValue = dimValueMap.get(GZ007);
        Object orgValue = dimValueMap.get(GZ004);
        Object materialValue = dimValueMap.get(GZ005);
        if (materialInvValue != null) {
            long materialInvId = RequireTypeHelper.getId(materialInvValue);
            materialInvSet.add(materialInvId);
        } else if (materialValue != null && orgValue != null) {
            long materialId = RequireTypeHelper.getId(materialValue);
            long orgId = RequireTypeHelper.getId(orgValue);
            Set materialIdSet = orgMaterialMap.computeIfAbsent(orgId, v -> new HashSet(16));
            materialIdSet.add(materialId);
        }
    }

    public static long getId(Object object) {
        if (object instanceof DynamicObject) {
            return ((DynamicObject)object).getLong("id");
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        return 0L;
    }

    public static Map<String, Object> getDimValue(Map<String, String> dimMap, Map<String, Integer> entryIndexMap, DynamicObject bill) {
        Object materialValue;
        Object orgValue;
        Object materialInvValue;
        String materialInvKey = dimMap.getOrDefault(GZ007, "");
        String orgKey = dimMap.getOrDefault(GZ004, "");
        String materialKey = dimMap.getOrDefault(GZ005, "");
        try {
            materialInvValue = RequireTypeHelper.getValue(materialInvKey, entryIndexMap, bill);
            orgValue = RequireTypeHelper.getValue(orgKey, entryIndexMap, bill);
            materialValue = RequireTypeHelper.getValue(materialKey, entryIndexMap, bill);
        }
        catch (Exception exception) {
            logger.error("\u6839\u636e\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e\u83b7\u53d6\u7ef4\u5ea6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6709\u8bef", (Throwable)exception);
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e\u83b7\u53d6\u7ef4\u5ea6\u503c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e\u662f\u5426\u6709\u8bef\u3002", (String)"CheckRequireTypeRangeValidator_6", (String)"bos-ext-mmc", (Object[])new Object[0]));
        }
        HashMap<String, Object> dimValueMap = new HashMap<String, Object>(8);
        dimValueMap.put(GZ007, materialInvValue);
        dimValueMap.put(GZ004, orgValue);
        dimValueMap.put(GZ005, materialValue);
        return dimValueMap;
    }

    public static String removeIdSuffix(String field) {
        if (field.endsWith(ID_SUFFIX)) {
            field = field.substring(0, field.lastIndexOf(DOT));
        }
        return field;
    }

    public static Object getValue(String fieldKey, Map<String, Integer> entryIndexMap, DynamicObject bill) {
        if (StringUtils.isBlank((CharSequence)fieldKey)) {
            return null;
        }
        DynamicObject parent = bill;
        int i = fieldKey.indexOf(DOT);
        while (i != -1) {
            String subFieldKey = fieldKey.substring(0, i);
            Object obj = parent.get(subFieldKey);
            if (obj instanceof DynamicObject) {
                parent = (DynamicObject)obj;
            } else if (obj instanceof DynamicObjectCollection) {
                Integer rowIndex = entryIndexMap.get(subFieldKey);
                if (rowIndex == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5236\u9020\u7b56\u7565\u7ef4\u5ea6\u914d\u7f6e\u6709\u8bef\uff0c\u9700\u6c42\u7c7b\u578b\u7ef4\u5ea6\u4e0e\u5176\u4ed6\u7ef4\u5ea6\u4e0d\u5b58\u5728\u5173\u8054\u5173\u7cfb\u3002", (String)"CheckRequireTypeRangeValidator_7", (String)"bos-ext-mmc", (Object[])new Object[0]));
                }
                parent = (DynamicObject)((DynamicObjectCollection)obj).get(rowIndex.intValue());
            } else {
                if (obj instanceof Long) {
                    return obj;
                }
                if (obj == null) {
                    return null;
                }
            }
            fieldKey = fieldKey.substring(i + 1);
            i = fieldKey.indexOf(DOT);
        }
        return parent.get(fieldKey);
    }
}

