/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.bizrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.mmc.operation.bizrule.IMmcServiceConfigCacheHelper;
import kd.bos.ext.mmc.operation.bizrule.IMmcServiceDataLoadHandler;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceBean;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceConfigCacheHelper;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceFieldBean;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public class MmcServiceDataLoadHandler
implements IMmcServiceDataLoadHandler {
    private IMmcServiceConfigCacheHelper msccache = new MmcServiceConfigCacheHelper();

    @Override
    public List<MmcServiceBean> loadWorkerBean(String billid, String opnum) {
        ArrayList<MmcServiceBean> msbs = new ArrayList<MmcServiceBean>();
        List<MmcServiceBean> caches = this.msccache.get(billid, opnum);
        if (caches != null) {
            return caches;
        }
        Map map = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMmcServConfigLoadService", (String)"loadConfig", (Object[])new Object[]{billid, opnum});
        if (map != null && map.containsKey("entries")) {
            this.changeBean(msbs, map.get("entries"));
        }
        if (!msbs.isEmpty()) {
            this.msccache.save(billid, opnum, msbs);
        }
        return msbs;
    }

    private void changeBean(List<MmcServiceBean> msbs, Object entries) {
        if (entries instanceof List) {
            List list = (List)entries;
            for (DynamicObject o : list) {
                MmcServiceBean bean = new MmcServiceBean();
                DynamicObject atmo = o.getDynamicObject("atmop");
                bean.setInparam(o.getString("inparam"));
                bean.setDataEntityId(o.getString("dataentityid"));
                bean.setNumber(atmo.getString("number"));
                bean.setName(atmo.getString("name"));
                bean.setAppId(atmo.getString("appid").toLowerCase());
                bean.setClassPath(atmo.getString("classpath"));
                bean.setDataEntityNum(atmo.getString("dataentitynum"));
                bean.setOpDescrip(atmo.getString("opdescrip"));
                bean.setMms(atmo.getBoolean("isms"));
                bean.setPeriod(atmo.getString("period"));
                if (bean.isMs()) {
                    bean.setCloudId(atmo.getString("cloudid").toLowerCase());
                    bean.setServiceName(atmo.getString("servicename"));
                    bean.setMethodName(atmo.getString("methodname"));
                    DynamicObjectCollection fields = atmo.getDynamicObjectCollection("entryentity");
                    if (fields != null && !fields.isEmpty()) {
                        ArrayList<MmcServiceFieldBean> ff = new ArrayList<MmcServiceFieldBean>();
                        for (DynamicObject field : fields) {
                            MmcServiceFieldBean fb = new MmcServiceFieldBean();
                            fb.setFieldKey(field.getString("fieldkey"));
                            fb.setFieldname(field.getString("fieldname"));
                            fb.setFieldType(field.getString("fieldtype"));
                            fb.setMust(field.getBoolean("ismust"));
                            ff.add(fb);
                        }
                        bean.setFields(ff);
                    }
                }
                msbs.add(bean);
            }
        }
    }

    @Override
    public String loadAppid(String billid) {
        QFilter[] q;
        DynamicObject amgp;
        if (billid != null && !StringUtils.isBlank((CharSequence)billid) && (amgp = BusinessDataServiceHelper.loadSingle((String)"mpdm_atmocfggp", (String)"appid", (QFilter[])(q = new QFilter[]{new QFilter("number", "=", (Object)billid), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")}))) != null) {
            return amgp.getString("appid").toLowerCase();
        }
        return null;
    }
}

