/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.mmc.operation.bizrule;

import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.OperateProgress;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.IOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.bos.ext.mmc.operation.bizrule.IMmcServicePluginProxy;
import kd.bos.ext.mmc.operation.bizrule.IMmcServiceTrigger;
import kd.bos.ext.mmc.operation.bizrule.MmcMServiceExecuteHelper;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceBean;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceExecutePeriod;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceOptionHelper;
import kd.bos.ext.mmc.operation.bizrule.MmcServiceWorkerHolder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class MmcServiceTrigger
implements IMmcServiceTrigger {
    private String nowApp;
    private MmcServiceBean bean;
    private OperateOption option;
    private OperateProgress operateProgress;
    private Map<String, Object> operateMeta;
    private MainEntityType billEntityType;
    private IOperationServicePlugIn plugin;
    private IMmcServicePluginProxy proxy;
    private static final Log logger = LogFactory.getLog(MmcServiceTrigger.class);

    public MmcServiceTrigger(String nowApp, MmcServiceBean bean, OperateOption option, OperateProgress operateProgress, Map<String, Object> operateMeta, MainEntityType billEntityType) {
        this.nowApp = nowApp;
        this.bean = bean;
        this.option = option;
        this.operateProgress = operateProgress;
        this.operateMeta = operateMeta;
        this.billEntityType = billEntityType;
        this.initTrigger();
    }

    @Override
    public void initOpResult(OperationResult result) {
        if (this.plugin == null) {
            logger.info("plugin is null");
        } else {
            this.plugin.initializeOperationResult(result);
        }
    }

    private void initTrigger() {
        logger.info(String.format("nowApp:%s,bean.getAppID:%s,bean.isMs:%s,bean.getClassPath:%s", this.nowApp, this.bean.getAppId(), this.bean.isMs(), this.bean.getClassPath()));
        if (!this.bean.isMs()) {
            MmcServiceOptionHelper.mergeOption(this.option, this.bean);
            MmcServiceWorkerHolder holder = MmcServiceWorkerHolder.getInstance();
            this.plugin = holder.get(this.bean.getClassPath());
            this.plugin.setContext(this.billEntityType, this.operateMeta, this.option);
            this.plugin.setOperateProgress(this.operateProgress);
        }
    }

    @Override
    public void trigger(MmcServiceExecutePeriod period, Object args) {
        if (period.getValue().equals(this.bean.getPeriod()) || MmcServiceExecutePeriod.ALL.equalsValue(this.bean.getPeriod()) || StringUtils.isBlank((CharSequence)this.bean.getPeriod())) {
            if (this.plugin != null) {
                this.runPlugin(this.plugin, period, args);
            } else if (this.proxy != null) {
                this.runPlugin(this.proxy, period, args);
            } else {
                MmcMServiceExecuteHelper.execMs(this.nowApp, this.bean, this.option);
            }
        }
    }

    private void runPlugin(IOperationServicePlugIn worker, MmcServiceExecutePeriod period, Object e) {
        switch (period) {
            case ONPREPARE: {
                worker.onPreparePropertys((PreparePropertysEventArgs)e);
                break;
            }
            case ONADDVALIDATORS: {
                worker.onAddValidators((AddValidatorsEventArgs)e);
                break;
            }
            case BEFOREEXECUTE: {
                worker.beforeExecuteOperationTransaction((BeforeOperationArgs)e);
                break;
            }
            case BEGINOPERATION: {
                worker.beginOperationTransaction((BeginOperationTransactionArgs)e);
                break;
            }
            case ENDOPERATION: {
                worker.endOperationTransaction((EndOperationTransactionArgs)e);
                break;
            }
            case ROLLBACK: {
                worker.rollbackOperation((RollbackOperationArgs)e);
                break;
            }
            case AFTEREXECUTE: {
                worker.afterExecuteOperationTransaction((AfterOperationArgs)e);
                break;
            }
        }
    }
}

