/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operate;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.operate.FahOperateUtil;
import kd.bos.ext.fi.ai.v2.fah.FahSerializeHelper;
import kd.bos.ext.fi.ai.v2.fah.SysParamConfig;
import kd.bos.ext.fi.ai.v2.fah.dto.FahVoucherCompleteDto;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.SessionManager;

public class DeleteVoucher
extends DefaultEntityOperate
implements ICloseCallBack {
    private static final int batch = 100000;

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!this.checkSaved()) {
            return false;
        }
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        return this.invokeBuildXlaAndGlTipTask();
    }

    protected boolean invokeBuildXlaAndGlTipTask() {
        if (Boolean.parseBoolean(SysParamConfig.get("fah.vch.delete.v1.enable", "false"))) {
            OperateOption option = this.getOption();
            option = option == null ? OperateOption.create() : option;
            Map optionMap = option.getVariables();
            return FahOperateUtil.invokeBuildXlaAndGlTipTask((AbstractOperate)this, optionMap);
        }
        return true;
    }

    protected boolean checkSaved() {
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58%s\u3002", (String)"DeleteVoucher_0", (String)"bos-ext-fi", (Object[])new Object[]{this.getView().getFormShowParameter().getCaption()}));
                return false;
            }
        }
        return true;
    }

    protected Set<Long> getSelectedBillIds() {
        return FahOperateUtil.getSelectedBillIds(this.getView());
    }

    public String getConfirmMessage() {
        this.setConfirmTypes(ConfirmTypes.Delete);
        return ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u5df2\u751f\u6210\u7684\u6240\u6709\u51ed\u8bc1\u5417\uff1f", (String)"DeleteVoucher_1", (String)"bos-ext-fi", (Object[])new Object[0]);
    }

    protected void afterOperationClose(OperationResult result) {
        List errorInfo = result.getAllErrorOrValidateInfo();
        if (result.isSuccess()) {
            super.afterOperationClose(result);
            return;
        }
        Set<Long> errorIds = this.getSelectedBillIds();
        errorIds.removeAll(result.getSuccessPkIds());
        if (errorIds.isEmpty()) {
            super.afterOperationClose(result);
            return;
        }
        FahVoucherCompleteDto vchComplete = new FahVoucherCompleteDto(errorIds, this.getEntityId());
        if (vchComplete.check().booleanValue()) {
            super.afterOperationClose(result);
            return;
        }
        if (!vchComplete.getMissBillMap().isEmpty()) {
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(true);
            String op_result = DataEntitySerializer.serializerToString((Object)result, (DataEntitySerializerOption)option);
            FormShowParameter formShow = new FormShowParameter();
            formShow.setFormId("ai_deletevoucher_confirm");
            formShow.setCustomParam("opresult", (Object)op_result);
            formShow.setCustomParam("sourceId", (Object)SerializationUtils.toJsonString(this.getSelectedBillIds()));
            formShow.setCustomParam("entityname", (Object)this.getEntityId());
            formShow.getCustomParams().put("pageid", this.getView().getPageId());
            formShow.getOpenStyle().setShowType(ShowType.Modal);
            formShow.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "ai_deletevoucher_confirm"));
            this.getView().showForm(formShow);
        }
    }

    protected int getBatchSize() {
        return 100000;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String key;
        switch (key = closedCallBackEvent.getActionId()) {
            case "ai_deletevoucher_confirm": {
                Map dataMap;
                Object returnData = closedCallBackEvent.getReturnData();
                if (returnData == null || (dataMap = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class)) == null) break;
                IFormView view = SessionManager.getCurrent().getView((String)dataMap.get("pageid"));
                String operationresultdata = (String)dataMap.get("operationresultdata");
                if (operationresultdata == null) break;
                OperationResult opResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)operationresultdata, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
                if (opResult.isSuccess()) {
                    String msg = ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1\u6210\u529f\u3002", (String)"DeleteVoucher_4", (String)"bos-ext-fi", (Object[])new Object[0]);
                    view.showSuccessNotification(msg);
                } else {
                    view.showOperationResult(opResult);
                }
                this.refreshData(view);
                break;
            }
            case "fah_build_xla_gl_tip": {
                Map map;
                String data = (String)closedCallBackEvent.getReturnData();
                if (data == null || (map = FahSerializeHelper.fromJsonString(data, Map.class)) == null) break;
                String error = (String)map.get("error");
                String or = (String)map.get("operationResult");
                IFormView currentView = SessionManager.getCurrent().getView((String)map.get("pageId"));
                if (or != null) {
                    OperationResult opResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)or, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
                    this.showResult(currentView, opResult);
                    break;
                }
                if (!StringUtils.isNotBlank((CharSequence)error)) break;
                currentView.showTipNotification(error);
                break;
            }
        }
    }

    public void showResult(IFormView currentView, OperationResult operationResult) {
        if (operationResult.isSuccess()) {
            String successMsg = ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1\u6210\u529f\u3002", (String)"DeleteVoucher_4", (String)"bos-ext-fi", (Object[])new Object[0]);
            currentView.showSuccessNotification(successMsg, Integer.valueOf(15000));
        } else {
            String opName = ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"DeleteVoucher_3", (String)"bos-ext-fi", (Object[])new Object[0]);
            currentView.showOperationResult(operationResult, opName);
        }
        this.refreshData(currentView);
    }

    private void refreshData(IFormView view) {
        FahOperateUtil.refreshData(view);
    }
}

