/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operate;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kd.bos.bill.IBillView;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.ext.fi.ai.operate.BuildVoucher;
import kd.bos.ext.fi.ai.operate.DeleteVoucher;
import kd.bos.ext.fi.ai.operate.FahOperateTask;
import kd.bos.ext.fi.ai.operate.PreviewVoucherOp;
import kd.bos.ext.fi.ai.v2.fah.FahSerializeHelper;
import kd.bos.ext.fi.ai.v2.fah.SysParamConfig;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.StringUtils;

public class FahOperateUtil {
    private static final Log logger = LogFactory.getLog(FahOperateUtil.class);
    public static final String PROGRESS_TAG = "progress_tag_cache";

    static boolean invokeBuildXlaAndGlTipTask(AbstractOperate operate, Map<String, String> optionMap) {
        if (Boolean.parseBoolean(SysParamConfig.get("fah.evt.operate.v1.enable", "false"))) {
            return FahOperateUtil.invokeBuildXlaAndGlTipTaskV1(operate, optionMap);
        }
        return FahOperateUtil.invokeBuildXlaAndGlTipTaskV0(operate, optionMap);
    }

    private static boolean invokeBuildXlaAndGlTipTaskV1(AbstractOperate operate, Map<String, String> optionMap) {
        long start = System.currentTimeMillis();
        Set<Long> idSet = FahOperateUtil.__getSelectedBillIds(operate);
        String entityId = operate.getEntityId();
        String pageId = operate.getView().getPageId();
        String opKey = operate.getOperateKey();
        String progressTag = DBServiceHelper.genStringId() + "-XLA-" + opKey + "-" + pageId;
        String optionStr = FahSerializeHelper.getInstance().toJSONString(optionMap);
        long requestId = DB.genLongId((String)"t_fah_request_task");
        String requestIdStr = String.valueOf(requestId);
        FahOperateTask myTask = new FahOperateTask(RequestContext.get(), idSet, entityId, progressTag, opKey, optionStr, false, requestIdStr);
        myTask.operateClassName = operate.getClass().getName();
        try {
            OperationResult operationResult;
            long timeout;
            long end1;
            if (Boolean.parseBoolean(SysParamConfig.get("fah.evt.operate.v1.timeout.enable", "false"))) {
                FutureTask<OperationResult> futureTask = new FutureTask<OperationResult>(myTask);
                ThreadPools.executeOnce((String)"fah_build_xla_gl_tip", futureTask);
                end1 = System.currentTimeMillis();
                timeout = Long.parseLong(SysParamConfig.get("fah.evt.operate.v1.timeout.milliseconds", "3000"));
                operationResult = futureTask.get(timeout, TimeUnit.MILLISECONDS);
            } else {
                end1 = System.currentTimeMillis();
                timeout = 0L;
                operationResult = myTask.call();
            }
            long end2 = System.currentTimeMillis();
            DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
            String currProgress = distributeCache.get(progressTag);
            IFormView currentView = operate.getView();
            if (StringUtils.isEmpty((String)currProgress)) {
                if (operate instanceof DeleteVoucher) {
                    ((DeleteVoucher)operate).showResult(currentView, operationResult);
                }
                operate.getView().showOperationResult(operationResult);
            } else {
                Map cacheDataMap = (Map)SerializationUtils.fromJsonString((String)currProgress, Map.class);
                if (operate instanceof PreviewVoucherOp) {
                    ((PreviewVoucherOp)operate).showResult(currentView, requestId, cacheDataMap);
                } else if (operate instanceof BuildVoucher) {
                    ((BuildVoucher)operate).showResult(currentView, cacheDataMap);
                } else if (operate instanceof DeleteVoucher) {
                    ((DeleteVoucher)operate).showResult(currentView, operationResult);
                }
            }
            long end3 = System.currentTimeMillis();
            logger.info("{}_cost, timeout/cost: {}/{}, executeOnce/showResult: {}/{}", new Object[]{operate.getClass().getName(), timeout, end2 - end1, end1 - start, end3 - end2});
        }
        catch (TimeoutException e) {
            FahOperateUtil.showXlaTipForm(operate, progressTag, requestIdStr, optionMap, true);
        }
        catch (Exception e) {
            logger.error("previewVoucher_error", (Throwable)e);
            operate.getView().showTipNotification(e.getMessage());
        }
        return false;
    }

    static Set<Long> __getSelectedBillIds(AbstractOperate operate) {
        Set<Long> selectedBillIds;
        if (operate instanceof PreviewVoucherOp) {
            selectedBillIds = ((PreviewVoucherOp)operate).getSelectedBillIds();
        } else if (operate instanceof BuildVoucher) {
            selectedBillIds = ((BuildVoucher)operate).getSelectedBillIds();
        } else if (operate instanceof DeleteVoucher) {
            selectedBillIds = ((DeleteVoucher)operate).getSelectedBillIds();
        } else {
            throw new RuntimeException("operate is not PreviewVoucherOp or BuildVoucher or DeleteVoucher");
        }
        return selectedBillIds;
    }

    private static boolean invokeBuildXlaAndGlTipTaskV0(AbstractOperate operate, Map<String, String> optionMap) {
        FahOperateUtil.showXlaTipForm(operate, null, null, optionMap, false);
        return false;
    }

    static void showXlaTipForm(AbstractOperate operate, String progressTag, String requestIdStr, Map<String, String> optionMap, boolean executedTask) {
        Set<Long> selectedBillIds = FahOperateUtil.__getSelectedBillIds(operate);
        FormShowParameter param = new FormShowParameter();
        param.setFormId("fah_build_xla_gl_tip");
        param.getOpenStyle().setShowType(ShowType.Modal);
        if (operate instanceof PreviewVoucherOp) {
            param.setCaption(ResManager.loadKDString((String)"\u9884\u89c8\u51ed\u8bc1", (String)"FahOperateUtil_1", (String)"bos-ext-fi", (Object[])new Object[0]));
        } else if (operate instanceof DeleteVoucher) {
            param.setCaption(ResManager.loadKDString((String)"\u5220\u9664\u51ed\u8bc1", (String)"FahOperateUtil_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        param.getCustomParams().put("ids", FahSerializeHelper.getInstance().toJSONString(selectedBillIds));
        param.getCustomParams().put("option", FahSerializeHelper.getInstance().toJSONString(optionMap));
        param.getCustomParams().put("entityId", operate.getEntityId());
        param.getCustomParams().put("pageId", operate.getView().getPageId());
        param.getCustomParams().put("operateKey", operate.getOperateKey());
        if (executedTask) {
            param.getCustomParams().put(PROGRESS_TAG, progressTag);
            param.getCustomParams().put("requestId", requestIdStr);
            param.getCustomParams().put("executedTask", "true");
        }
        param.setCloseCallBack(new CloseCallBack(operate.getClass().getName(), "fah_build_xla_gl_tip"));
        operate.getView().showForm(param);
    }

    static Set<Long> getSelectedBillIds(IFormView view) {
        IBillModel billModel;
        Object pkValue;
        if (view instanceof IListView) {
            IListView listView = (IListView)view;
            HashSet<Long> billIds = new HashSet<Long>(listView.getSelectedRows().size());
            for (ListSelectedRow row : listView.getSelectedRows()) {
                Object pkValue2 = row.getPrimaryKeyValue();
                if (!(pkValue2 instanceof Long)) continue;
                billIds.add((Long)pkValue2);
            }
            return billIds;
        }
        if (view instanceof IBillView && (pkValue = (billModel = (IBillModel)view.getModel()).getPKValue()) instanceof Long) {
            return Collections.singleton((Long)pkValue);
        }
        return Collections.emptySet();
    }

    public static void refreshData(IFormView view) {
        if (view instanceof IListView) {
            ((IListView)view).refreshWithSelected();
        } else {
            view.invokeOperation("refresh");
        }
    }

    public static void updateProcessInfo(OperateOption option, OperationResult operationResult) {
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
        if (option.containsVariable("GenerateProcessKey")) {
            String GenerateProcessKey = option.getVariableValue("GenerateProcessKey");
            String cacheData = distributeCache.get(GenerateProcessKey);
            Map<String, String> cacheDataMap = new HashMap<String, Integer>(8);
            if (cacheData != null) {
                cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
            }
            cacheDataMap.put("currProgress", (String)((Object)Integer.valueOf(100)));
            DataEntitySerializerOption serializerOption = new DataEntitySerializerOption();
            serializerOption.setIncludeComplexProperty(true);
            cacheDataMap.put("operationResult", DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)serializerOption));
            distributeCache.put(GenerateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
        }
    }

    public static void checkAndCacheOperationResult(String progressTag, OperationResult operationResult) {
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
        String currProgress = distributeCache.get(progressTag);
        Map cacheDataMap = currProgress == null ? new HashMap(8) : (Map)SerializationUtils.fromJsonString((String)currProgress, Map.class);
        Object operationResultStr = cacheDataMap.get("operationResult");
        if (null == operationResultStr) {
            DataEntitySerializerOption option = new DataEntitySerializerOption();
            option.setIncludeComplexProperty(true);
            cacheDataMap.put("operationResult", DataEntitySerializer.serializerToString((Object)operationResult, (DataEntitySerializerOption)option));
        }
        cacheDataMap.put("currProgress", 100);
        distributeCache.put(progressTag, SerializationUtils.toJsonString(cacheDataMap));
    }
}

