/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operate;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.IListView;
import kd.bos.mvc.SessionManager;

public class ReverseVoucher
extends DefaultEntityOperate
implements ICloseCallBack {
    private static final int BATCH = 100000;
    private static final String SELECT_BOOK_DATE = "ai_selectbookdate";

    protected boolean beforeInvokeOperation(OperationResult result) {
        String returnDataMapStr;
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u201c%s\u201d\u3002", (String)"ReverseVoucher_0", (String)"bos-ext-fi", (Object[])new Object[]{this.getView().getFormShowParameter().getCaption()}));
                return false;
            }
        }
        if (null == (returnDataMapStr = this.getOption().getVariableValue(SELECT_BOOK_DATE, null))) {
            Set<Long> selectedBillIds = this.getSelectedBillIds();
            return this.openSelectBookedDate(selectedBillIds);
        }
        return true;
    }

    private boolean openSelectBookedDate(Set<Long> residueBillIds) {
        FormShowParameter formShow = new FormShowParameter();
        formShow.setFormId(SELECT_BOOK_DATE);
        formShow.setCustomParam("billType", (Object)this.getEntityId());
        formShow.setCustomParam("billId", (Object)SerializationUtils.toJsonString(residueBillIds));
        formShow.setCustomParam("pageId", (Object)this.getView().getPageId());
        formShow.setCustomParam("operationKey", (Object)this.getOperateKey());
        formShow.getOpenStyle().setShowType(ShowType.Modal);
        formShow.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), SELECT_BOOK_DATE));
        this.getView().showForm(formShow);
        return false;
    }

    protected Set<Long> getSelectedBillIds() {
        IBillModel billModel;
        Object pkValue;
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            HashSet<Long> billIds = new HashSet<Long>(listView.getSelectedRows().size());
            for (ListSelectedRow row : listView.getSelectedRows()) {
                Object pkValue2 = row.getPrimaryKeyValue();
                if (!(pkValue2 instanceof Long)) continue;
                billIds.add((Long)pkValue2);
            }
            return billIds;
        }
        if (this.getView() instanceof IBillView && (pkValue = (billModel = (IBillModel)this.getView().getModel()).getPKValue()) instanceof Long) {
            return Collections.singleton((Long)pkValue);
        }
        return Collections.emptySet();
    }

    protected int getBatchSize() {
        return 100000;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        Object returnData;
        String returnValue;
        Map map;
        String key = evt.getActionId();
        if (key.equals(SELECT_BOOK_DATE) && (map = (Map)SerializationUtils.fromJsonString((String)(returnValue = String.valueOf(returnData = evt.getReturnData())), Map.class)) != null) {
            String pageId = (String)map.get("pageId");
            OperateOption create = OperateOption.create();
            create.setVariableValue(SELECT_BOOK_DATE, returnValue);
            String genKey = (String)map.get("operationKey");
            genKey = genKey == null ? ReverseVoucher.getGenVoucherKey((String)map.get("billType")) : genKey;
            IFormView view = SessionManager.getCurrent().getView(pageId);
            view.invokeOperation(genKey, create);
        }
    }

    private static String getGenVoucherKey(String billType) {
        List opts = EntityMetadataCache.getDataEntityOperate((String)billType);
        String reverseVoucherOptName = "reversevoucher";
        for (Map opt : opts) {
            String optKey = (String)opt.get("type");
            if (!optKey.equalsIgnoreCase("reversevoucher")) continue;
            reverseVoucherOptName = (String)opt.get("key");
        }
        return reverseVoucherOptName;
    }
}

