/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.service.operation.EntityOperateService;

public class BackNoGenVoucherService
extends EntityOperateService {
    private String billType;
    private DBRoute route;
    private String tableName;

    protected void preparePropertys(List<String> fieldKeys) {
        fieldKeys.add("id");
        super.preparePropertys(fieldKeys);
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        this.billType = this.billEntityType.getName();
        this.route = DBRoute.of((String)this.billEntityType.getDBRouteKey());
        this.tableName = this.billEntityType.getAlias();
        validators.add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] exDatas = this.getDataEntities();
                List<ExtendedDataEntity> list = Arrays.asList(exDatas);
                List<Object> pkIds = list.stream().map(p -> p.getBillPkId()).collect(Collectors.toList());
                HashSet<Long> inDap = new HashSet<Long>(DapVoucherUtil.getBuildedBill(pkIds, BackNoGenVoucherService.this.billType));
                HashSet<Long> inDapn = new HashSet<Long>(DapVoucherUtil.getNogenVch(BackNoGenVoucherService.this.route, pkIds, BackNoGenVoucherService.this.tableName));
                for (ExtendedDataEntity exData : exDatas) {
                    Long tempId = (Long)exData.getBillPkId();
                    if (inDap.contains(tempId)) {
                        this.addMessage(exData, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u64cd\u4f5c\u201c\u53d6\u6d88\u4e0d\u751f\u6210\u51ed\u8bc1\u201d\u3002", (String)"BackNoGenVoucherService_01", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (inDapn.contains(tempId)) continue;
                    this.addMessage(exData, ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u4e0d\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd\u53d6\u6d88\u4e0d\u751f\u6210\u3002", (String)"BackNoGenVoucherService_02", (String)"bos-ext-fi", (Object[])new Object[0]), ErrorLevel.Error);
                }
            }
        });
        super.addDefaultValidator(validators);
    }

    private List<Object[]> changeParams(Map<Long, Object[]> insertparams, List<Long> params, DBRoute route, String tableName) {
        ArrayList<Object[]> returnList = new ArrayList<Object[]>(16);
        String joinids = StringUtils.join((Object[])params.toArray(), (char)',');
        String sql = "SELECT fid  from " + tableName + " where fid in (" + joinids + ") and fbillstatus >= 'C';";
        try (DataSet set = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.BackNoGenVoucherService", (DBRoute)route, (String)sql);){
            for (Row d : set) {
                long sourceBillid = d.getLong("fid");
                returnList.add(insertparams.get(sourceBillid));
            }
        }
        return returnList;
    }

    protected void executeOperate(DynamicObject[] dataEntities) {
        int count = dataEntities.length;
        OperationResult sr = this.getOperationResult();
        String entityName = this.billEntityType.getName();
        boolean exitsTable = DB.exitsTable((DBRoute)DBRoute.of((String)DapBuildVoucherCommonUtil.getDBRouteKey(entityName)), (String)DapBuildVoucherCommonUtil.getBlackTableName(entityName));
        if (!exitsTable) {
            OperateErrorInfo error = new OperateErrorInfo();
            error.setMessage(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7c7b\u578b\u7684\u201c\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u201d\u53c2\u6570\u672a\u52fe\u9009\uff0c\u8bf7\u524d\u5f80\u201c\u667a\u80fd\u6838\u7b97\u673a\u5668\u4eba>\u57fa\u7840\u8bbe\u7f6e>\u51ed\u8bc1\u6a21\u677f\u201d\u7ef4\u62a4\u8be5\u53c2\u6570\u3002", (String)"BackNoGenVoucherService_03", (String)"bos-ext-fi", (Object[])new Object[0]));
            error.setErrorLevel(ErrorLevel.Warning.name());
            sr.getAllErrorInfo().add(error);
            sr.setSuccess(false);
            return;
        }
        String userId = RequestContext.get().getUserId();
        Date date = new Date();
        long[] insertpkIds = DB.genLongIds((String)(this.tableName + "_dapw"), (int)count);
        ArrayList<Long> sorceIds = new ArrayList<Long>(count);
        HashMap<Long, Object[]> insertparams = new HashMap<Long, Object[]>(count);
        for (int i = 0; i < count; ++i) {
            Object[] obj = new Object[5];
            long sourceBillId = (Long)dataEntities[i].get("id");
            obj[0] = insertpkIds[i];
            obj[1] = sourceBillId;
            DynamicObject dynamicObject = (DynamicObject)dataEntities[i].get(this.billEntityType.getMainOrg());
            obj[2] = dynamicObject.getLong("id");
            obj[3] = date;
            obj[4] = dataEntities[i].getDataEntityType().getName();
            insertparams.put(sourceBillId, obj);
            sorceIds.add(sourceBillId);
        }
        List<Object[]> insertList = this.changeParams(insertparams, sorceIds, this.route, this.tableName);
        String joinids = StringUtils.join((Object[])sorceIds.toArray(), (char)',');
        String string = " delete from %s_dapn where fsourcebillid in (%s)";
        String deletesql = String.format(string, this.tableName, joinids);
        string = "insert into %s_dapw (fid,fsourcebillid,forgid,fcreatetime,fbilltype, foper) values (?,?,?,?,?,'audit')";
        String insertsql = String.format(string, this.tableName);
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)this.route, (String)deletesql);
            if (insertList.size() > 0) {
                DB.executeBatch((DBRoute)this.route, (String)insertsql, insertList);
            }
        }
    }
}

