/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operation;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.ext.fi.ai.operation.DapOperationResultHelper;
import kd.bos.ext.fi.ai.v2.fah.BuildXLAAndGLUtils;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.FahSerializeHelper;
import kd.bos.ext.fi.ai.v2.fah.constant.BuildVoucherServiceParamConstants;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.DapEntityOperateService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PreviewVoucherService
extends DapEntityOperateService {
    private static final Log log = LogFactory.getLog(PreviewVoucherService.class);
    private Set<Long> billIds;
    private String GenerateProcessKey = "";

    @Override
    public OperationResult excute(Object[] ids) throws Exception {
        String buildMode = this.getOption().getVariableValue("build_mode", null);
        if ("true".equalsIgnoreCase(buildMode)) {
            return this.getXlaOperationResult(ids);
        }
        return this.getVoucherOperationResult(ids);
    }

    private OperationResult getVoucherOperationResult(Object[] ids) throws Exception {
        OperationResult sr = super.excute(ids);
        if (sr.getSuccessPkIds().size() == 0) {
            return sr;
        }
        HashSet<Long> billIds = new HashSet<Long>();
        if (sr.getAllErrorOrValidateInfo().size() > 0) {
            List succes = sr.getSuccessPkIds();
            Iterator iterator = succes.iterator();
            while (iterator.hasNext()) {
                Object suid = iterator.next();
                billIds.add(Long.valueOf(suid.toString()));
            }
        } else {
            for (Object id : ids) {
                billIds.add(Long.valueOf(id.toString()));
            }
        }
        Date start = new Date();
        Calendar date = Calendar.getInstance();
        date.setTime(start);
        date.set(13, date.get(13) - 1);
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("previewpageid", this.getOption().getVariableValue("previewpageid"));
        if (this.getOption().getVariables().containsKey("tempId")) {
            map.put("tempInfo", this.getOption().getVariableValue("tempId"));
        }
        if (this.getOption().getVariables().containsKey("multidap")) {
            map.put("multidap", Boolean.valueOf(this.getOption().getVariableValue("multidap")));
        }
        if (this.getOption().getVariables().containsKey("ignoretemplateunique")) {
            map.put("ignoretemplateunique", this.getOption().getVariableValue("ignoretemplateunique"));
        }
        if (this.getOption().getVariables().containsKey("vchtemplateprevoucher")) {
            map.put("vchtemplateprevoucher", this.getOption().getVariableValue("vchtemplateprevoucher"));
        }
        String paramStr = SerializationUtils.toJsonString(map);
        StringBuilder error = new StringBuilder();
        if ("ai_event".equals(this.getOperationContext().getEntityTypeId())) {
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(billIds);
            for (Map.Entry<String, List<Long>> billTypeGroup : billTypeGroups.entrySet()) {
                String errorMsg = "ai_event".equals(billTypeGroup.getKey()) ? this.splitEventBuildVoucher(billIds, paramStr) : this.buildVoucher(billTypeGroup.getKey(), new HashSet<Long>((Collection)billTypeGroup.getValue()), paramStr);
                if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
                error.append(errorMsg);
            }
        } else {
            String errorMsg = this.buildVoucher(this.getOperationContext().getEntityTypeId(), billIds, paramStr);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                error.append(errorMsg);
            }
        }
        IAppCache cache = AppCache.get((String)"gl");
        String string = (String)cache.get("accSys_" + this.getOption().getVariableValue("previewpageid") + "_perviewvouchernew", String.class);
        String stringOld = (String)cache.get("accSys_" + this.getOption().getVariableValue("previewpageid") + "_perviewvoucher", String.class);
        if (StringUtils.isBlank((CharSequence)string) && StringUtils.isBlank((CharSequence)stringOld)) {
            return DapOperationResultHelper.buildResult(billIds.toArray(new Long[0]), error.toString(), sr, date.getTime());
        }
        return super.createOperationResult();
    }

    @Override
    public String getGenerateProcessKey() {
        return this.GenerateProcessKey;
    }

    private OperationResult getXlaOperationResult(Object[] ids) throws Exception {
        HashSet<Long> billIds = new HashSet<Long>(16);
        for (Object id : ids) {
            billIds.add(Long.valueOf(id.toString()));
        }
        this.billIds = billIds;
        long superStart = System.currentTimeMillis();
        this.setGenerateProKey();
        log.info("--XlaAndGl--GenerateProcessKey:{};ids.size:{}", (Object)this.GenerateProcessKey, (Object)ids.length);
        OperationResult sr = super.excute(ids);
        log.info("super.excute+\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u548c\u603b\u8d26\u5408\u8ba1\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - superStart));
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
        String cacheData = distributeCache.get(this.GenerateProcessKey);
        Map<String, String> cacheDataMap = new HashMap<String, Integer>(8);
        if (cacheData != null) {
            cacheDataMap = (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
        }
        cacheDataMap.put("currProgress", (String)((Object)Integer.valueOf(100)));
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        option.setIncludeComplexProperty(true);
        cacheDataMap.put("operationResult", DataEntitySerializer.serializerToString((Object)sr, (DataEntitySerializerOption)option));
        distributeCache.put(this.GenerateProcessKey, SerializationUtils.toJsonString(cacheDataMap));
        return sr;
    }

    protected DynamicObject[] callOperation(DynamicObject[] objs) {
        DynamicObject[] sd = super.callOperation(objs);
        String buildMode = this.getOption().getVariableValue("build_mode", null);
        if ("true".equalsIgnoreCase(buildMode)) {
            List succids = this.getOperationResult().getSuccessPkIds();
            DynamicObject[] rel = (DynamicObject[])Stream.of(sd).filter(d -> succids.contains(d.getPkValue())).toArray(DynamicObject[]::new);
            succids.removeAll(Stream.of(rel).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            IDataEntityProperty billNoProp = null;
            if (this.subEntityType instanceof BasedataEntityType) {
                BasedataEntityType bdType = (BasedataEntityType)this.subEntityType;
                if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                    billNoProp = this.subEntityType.findProperty(bdType.getNumberProperty());
                }
            } else if (this.subEntityType instanceof BillEntityType) {
                billNoProp = "ai_event".equals(this.subEntityType.getName()) ? this.subEntityType.findProperty("number") : this.subEntityType.findProperty(((BillEntityType)this.subEntityType).getBillNo());
            }
            List errors = this.getOperationResult().getAllErrorInfo();
            HashMap<Object, DynamicObject> dataMap = new HashMap<Object, DynamicObject>(sd.length);
            for (DynamicObject dd : sd) {
                dataMap.put(dd.getPkValue(), dd);
            }
            for (OperateErrorInfo error : errors) {
                String billNo;
                DynamicObject errorObj = (DynamicObject)dataMap.get(error.getPkValue());
                if (errorObj == null) continue;
                String string = billNo = billNoProp == null ? "" : (String)billNoProp.getValue((Object)errorObj);
                if (billNo == null) {
                    error.setMessage(String.format(ResManager.loadKDString((String)"\u9884\u89c8\u51ed\u8bc1\u5931\u8d25\uff1a%s", (String)"PreviewVoucherService_1", (String)"bos-ext-fi", (Object[])new Object[0]), error.getMessage()));
                    continue;
                }
                error.setMessage(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u201c%1$s\u201d\u9884\u89c8\u51ed\u8bc1\u5931\u8d25\uff1a%2$s", (String)"PreviewVoucherService_2", (String)"bos-ext-fi", (Object[])new Object[0]), billNo, error.getMessage()));
            }
            return rel;
        }
        return sd;
    }

    protected void executeOperate(DynamicObject[] arg0) {
        String buildMode = this.getOption().getVariableValue("build_mode", null);
        if ("true".equalsIgnoreCase(buildMode)) {
            this.doBuildXlaAndGlExecuteOperate(arg0);
        }
    }

    private void doBuildXlaAndGlExecuteOperate(DynamicObject[] arg0) {
        OperationResult sr = this.getOperationResult();
        if (!sr.getAllErrorOrValidateInfo().isEmpty()) {
            this.billIds.removeAll(sr.getValidateResult().getErrorPkIds());
        }
        String paramStr = this.parseXlaParams();
        log.info("--XLA--parseXlaParams--paramStr:{}", (Object)paramStr);
        long startTime = System.currentTimeMillis();
        String returnData = this.dispatchBuildXlaAndGl(this.billIds, paramStr);
        Set<Long> ids = BuildXLAAndGLUtils.buildSetData(arg0);
        BuildXLAAndGLUtils.buildXlaResult(ids, returnData, this.getOperationResult());
        log.info("\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u548c\u63a5\u53e3\u8868\u51ed\u8bc1\u603b\u8017\u65f6\uff1a{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private String parseXlaParams() {
        HashMap<String, String> param = new HashMap<String, String>(16);
        String varStr = this.getOption().getVariableValue("SubmitPopWinValue", null);
        if (varStr != null) {
            Map returnParamMap = FahSerializeHelper.fromJsonString(varStr, Map.class);
            param.putAll(returnParamMap);
        } else {
            param.put("isPreview", "true");
            param.put("includeTaskGrp", FahSerializeHelper.toJsonString(BuildVoucherServiceParamConstants.TaskGrps_Bill_To_InterfaceVoucher));
            param.put("requestId", this.getOption().getVariableValue("requestId", null));
        }
        param.put("GenerateProcessKey", this.GenerateProcessKey);
        return FahSerializeHelper.getInstance().toJSONString(param);
    }

    private String dispatchBuildXlaAndGl(Set<Long> billIds, String paramStr) {
        StringBuilder error = new StringBuilder();
        if ("ai_event".equals(this.getOperationContext().getEntityTypeId())) {
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(billIds);
            for (Map.Entry<String, List<Long>> billTypeGroup : billTypeGroups.entrySet()) {
                String errorMsg = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"IBuildXLAAndGLService", (String)"buildXLAAndGL", (Object[])new Object[]{billTypeGroup.getKey(), new HashSet(billTypeGroup.getValue()), paramStr});
                if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
                error.append(errorMsg);
            }
        } else {
            String errorMsg = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"IBuildXLAAndGLService", (String)"buildXLAAndGL", (Object[])new Object[]{this.getOperationContext().getEntityTypeId(), billIds, paramStr});
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                error.append(errorMsg);
            }
        }
        log.info("#####dispatchBuildXlaAndGl--error:{}", (Object)error);
        return error.toString();
    }

    private String buildVoucher(String billType, Set<Long> billIds, String paramStr) {
        return (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"buildVoucher", (Object[])new Object[]{billType, billIds, paramStr});
    }

    private String splitEventBuildVoucher(Set<Long> billIds, String paramStr) {
        HashMap<Long, Set> map = new HashMap<Long, Set>();
        DynamicObjectCollection events = QueryServiceHelper.query((String)"ai_event", (String)"id,eventclass", (QFilter[])new QFilter("id", "in", billIds).toArray());
        for (DynamicObject event : events) {
            Set set = map.computeIfAbsent(event.getLong("eventclass"), fun -> new HashSet());
            set.add(event.getLong("id"));
        }
        StringBuilder str = new StringBuilder();
        for (Map.Entry<Long, Set<Long>> entry : map.entrySet()) {
            String error = this.eventBuildVoucher(paramStr, entry);
            if (!StringUtils.isNotBlank((CharSequence)error)) continue;
            str.append(error);
        }
        return str.toString();
    }

    private String eventBuildVoucher(String paramStr, Map.Entry<Long, Set<Long>> entry) {
        return (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"eventBuildVoucher", (Object[])new Object[]{this.getOperationContext().getEntityTypeId(), entry.getValue(), paramStr, entry.getKey()});
    }

    private void setGenerateProKey() {
        if (this.getOption().containsVariable("GenerateProcessKey")) {
            String generateProcessKey;
            this.GenerateProcessKey = generateProcessKey = this.getOption().getVariableValue("GenerateProcessKey");
        }
    }
}

