/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.cal.plugin;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class CalFuncBalFieldPropPlugin
extends AbstractFuncParamPlugIn {
    public void afterCreateNewData(EventObject e) {
        this.getModel().setValue("balid", (Object)"balid");
    }

    public String getSetting() {
        String balid = (String)this.getModel().getValue("balid");
        String balField = (String)this.getModel().getValue("balfield");
        String setting = String.format("%s(%s,'%s')", this.getFuncId(), balid, balField);
        return setting;
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String balid = (String)this.getModel().getValue("balid");
        String balField = (String)this.getModel().getValue("balfield");
        if (StringUtils.isEmpty((CharSequence)balid) || StringUtils.isEmpty((CharSequence)balField)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u5355\u636e\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CalFuncBizBillPropPlugin_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"balfield"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        this.doClick(source.getKey());
    }

    private void doClick(String key) {
        if ("balfield".equals(key)) {
            MainEntityType mainType = this.getBillEntityType();
            if (mainType == null) {
                return;
            }
            PropTreeBuildOption option = new PropTreeBuildOption();
            new FormTreeBuilder();
            TreeNode tree = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
            this.showSelectFieldForm(tree, "balfield");
        }
    }

    private MainEntityType getBillEntityType() {
        String billEntityTypeNumber = "cal_balance";
        MainEntityType billEntityType = EntityMetadataCache.getDataEntityType((String)billEntityTypeNumber);
        return billEntityType;
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "balfield"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("balfield".equals(sourceFldKey) && returnData != null) {
            this.getModel().setValue("balfield", returnData);
        }
    }
}

