/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.evp.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.evp.model.PullevpDataParam;
import kd.bos.ext.fi.evp.service.IBizevpDataService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class BizevpDataErImpl
implements IBizevpDataService {
    private static final Log logger = LogFactory.getLog(BizevpDataErImpl.class);
    private static final String SEQNO = "seqno";
    private static final String COSTCOMPANY = "costcompany";

    @Override
    public Map<Long, List<JSONObject>> getEvpJsonList(PullevpDataParam pullevpDataParam) {
        Map invoiceMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"erGetBizBillInfoImpl", (String)"getBizBillTicketListNew", (Object[])new Object[]{pullevpDataParam.getBillType(), pullevpDataParam.getBillIds()});
        logger.info("getEvpJsonList param {}, return {}", (Object)pullevpDataParam.toString(), (Object)invoiceMap);
        return invoiceMap;
    }

    @Override
    public List<Long> getBkrsids(Long orgid, Date startdate, Date enddate) {
        return null;
    }

    public static Map<String, JSONObject> getSeqNoAndJson(Map<Long, List<JSONObject>> billInvoice) {
        Map<String, Object> seqNoAndJsonObject = new HashMap<String, JSONObject>(16);
        if (billInvoice.size() == 0) {
            return seqNoAndJsonObject;
        }
        Map<String, Map<Long, Set<String>>> ticketTypeAndSeqNos = BizevpDataErImpl.getTicketTypeAndSeqNos(billInvoice.values());
        seqNoAndJsonObject = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"erGetBizBillInfoImpl", (String)"getSeqNoAndJsonNew", (Object[])new Object[]{ticketTypeAndSeqNos});
        logger.info(ResManager.loadKDString((String)"getSeqNoAndJson \u53c2\u6570 {},\u8fd4\u56de\u503c:{}", (String)"logger", (String)"fi-aef-common", (Object[])new Object[0]), ticketTypeAndSeqNos, seqNoAndJsonObject);
        return seqNoAndJsonObject;
    }

    private static Map<String, Map<Long, Set<String>>> getTicketTypeAndSeqNos(Collection<List<JSONObject>> values) {
        HashMap<String, Map<Long, Set<String>>> ticketTypeAndSeqNos = new HashMap<String, Map<Long, Set<String>>>(values.size());
        for (List<JSONObject> list : values) {
            for (JSONObject jsonObject : list) {
                String seqNo = jsonObject.getString(SEQNO);
                Long costcompany = jsonObject.getLong(COSTCOMPANY);
                String tickettype = jsonObject.getString("tickettype");
                if (StringUtils.isEmpty((String)seqNo)) continue;
                ticketTypeAndSeqNos.computeIfAbsent(tickettype, value -> new HashMap()).computeIfAbsent(costcompany, value -> new HashSet()).add(seqNo);
            }
        }
        return ticketTypeAndSeqNos;
    }
}

