/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.servicehelper.DispatchServiceHelper;

public class ArApExecControlOpAction
extends AbstractOpBizRuleAction {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        if (this.operateMeta != null) {
            Object opName = this.operateMeta.get("type");
            Object opKey = this.operateMeta.get("key");
            if ("delete".equals(opName) || "cancelpay".equals(opKey) || "cancelrec".equals(opKey)) {
                this.invokeApBizService(opName, e.getDataEntities());
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        if (this.operateMeta != null) {
            Object opName = this.operateMeta.get("type");
            Object opKey = this.operateMeta.get("key");
            if (!("delete".equals(opName) || "cancelpay".equals(opKey) || "cancelrec".equals(opKey))) {
                this.invokeApBizService(opName, e.getDataEntities());
            }
        }
    }

    private void invokeApBizService(Object opName, DynamicObject[] dataEntities) {
        if ("donothing".equals(opName)) {
            opName = this.operateMeta.get("key");
        }
        Set billIds = Arrays.stream(dataEntities).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
        String entityName = dataEntities[0].getDataEntityType().getName();
        Map errorMessageMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ExecControlService", (String)"getExecControlInfo", (Object[])new Object[]{entityName, opName, billIds});
        if (errorMessageMap == null || errorMessageMap.isEmpty()) {
            return;
        }
        StringBuilder errorBuilder = new StringBuilder();
        for (DynamicObject billInfo : dataEntities) {
            String errorMsg = (String)errorMessageMap.get(billInfo.getLong("id"));
            if (StringUtils.isNotEmpty(errorMsg)) {
                throw new KDBizException(String.format("%1$s:%2$s", billInfo.getString("billno"), errorMsg));
            }
            DynamicObjectCollection entryCol = billInfo.getDynamicObjectCollection("entry");
            for (DynamicObject entryInfo : entryCol) {
                String msg = (String)errorMessageMap.get(entryInfo.getLong("id"));
                if (!StringUtils.isNotEmpty(msg)) continue;
                errorBuilder.append(msg).append("\n");
            }
        }
        if (errorBuilder.length() > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u3010\u4e8b\u4e2d\u76d1\u63a7\u3011\n%s", (String)"ArApExecControlOpAction_0", (String)"bos-ext-fi", (Object[])new Object[]{errorBuilder}));
        }
    }
}

