/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.DispatchServiceHelper;

public class BillDeleteProcessSettleRecordOpAction
extends AbstractOpBizRuleAction {
    private List<Long> hasWriteoffIds = new ArrayList<Long>(2);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if (!"delete".equals(operateKey)) {
                    return;
                }
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                ArrayList<Long> billIds = new ArrayList<Long>(dataEntities.length);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    billIds.add(dataEntity.getDataEntity().getLong("id"));
                }
                Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"BillDeleteProcessSRService", (String)"validateSettleRecordForDelete", (Object[])new Object[]{this.entityKey, billIds});
                if (ObjectUtils.isEmpty((Object)resultMap)) {
                    return;
                }
                ArrayList<Long> hasNoWriteoffIds = new ArrayList<Long>(resultMap.size());
                ArrayList<Long> hasWriteoffVoucherIds = new ArrayList<Long>(resultMap.size());
                for (Map.Entry entry : resultMap.entrySet()) {
                    Long key = (Long)entry.getKey();
                    String value = (String)entry.getValue();
                    if ("has_writeoff".equals(value)) {
                        BillDeleteProcessSettleRecordOpAction.this.hasWriteoffIds.add(key);
                        continue;
                    }
                    if ("has_no_writeoff".equals(value)) {
                        hasNoWriteoffIds.add(key);
                        continue;
                    }
                    if (!"has_writeoff_voucher".equals(value)) continue;
                    hasWriteoffVoucherIds.add(key);
                }
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    long id = dataEntity.getDataEntity().getLong("id");
                    if (hasNoWriteoffIds.contains(id)) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5b58\u5728\u672a\u7ea2\u51b2\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BillDeleteProcessSettleRecord_0", (String)"bos-ext-fi", (Object[])new Object[0]));
                        continue;
                    }
                    if (!hasWriteoffVoucherIds.contains(id)) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7684\u7ed3\u7b97\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"BillDeleteProcessSettleRecord_1", (String)"bos-ext-fi", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        List billIds = Arrays.stream(dataEntities).map(bill -> bill.getLong("id")).collect(Collectors.toList());
        DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"BillDeleteProcessSRService", (String)"billDeleteCompensate", (Object[])new Object[]{this.billEntityType.getName(), this.hasWriteoffIds, billIds});
    }
}

