/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OnTimeGenerateVoucherOpAction
extends AbstractOpBizRuleAction {
    private static Log log = LogFactory.getLog(OnTimeGenerateVoucherOpAction.class);
    private String billTypeKey;

    public void endOperationTransaction(final EndOperationTransactionArgs e) {
        this.billTypeKey = e.getDataEntities()[0].getDynamicObjectType().getName();
        TX.addCommitListener((CommitListener)new CommitListener(){

            public void onCommitted() {
                if (e.getDataEntities().length > 0) {
                    ArrayList<Object> ids = new ArrayList<Object>(e.getDataEntities().length);
                    for (DynamicObject db : e.getDataEntities()) {
                        ids.add(db.get("id"));
                    }
                    OnTimeGenerateVoucherOpAction.this.generateVoucher(ids, e.getOperationKey());
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateVoucher(List<Object> successPkIds, String operationKey) {
        block5: {
            try {
                if (successPkIds == null || successPkIds.size() <= 0) break block5;
                try (MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "kd.fi.ai.DapQueue");){
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("billIds", successPkIds);
                    params.put("billEntity", this.billTypeKey);
                    params.put("operationKey", operationKey);
                    pub.publish(params);
                }
            }
            catch (Exception e) {
                log.error("\u5355\u636e\u751f\u6210\u51ed\u8bc1\u53d1\u9001\u6d88\u606f\u961f\u5217\u5931\u8d25\uff0c\u5355\u636e\u7f16\u7801\uff1a" + this.billTypeKey + ", ", (Throwable)e);
            }
        }
    }

    public static Map<String, String> getOnTimeDapConfigs() {
        IAppCache cache = AppCache.get((String)"ai");
        HashMap<String, String> billoprtconfig = (HashMap<String, String>)cache.get("fi-ai-dapconfigs-dapcontrol", Map.class);
        if (billoprtconfig == null) {
            Map<String, String> dapBillEntitys = OnTimeGenerateVoucherOpAction.getDapBillEntitys();
            DynamicObject[] templates = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)"fsourcebill,buildvchgen", (QFilter[])new QFilter[]{new QFilter("fsourcebill.id", "in", dapBillEntitys.keySet()), new QFilter("enable", "!=", (Object)"0"), new QFilter("buildvchgen", "=", (Object)"1")});
            billoprtconfig = new HashMap<String, String>(templates.length);
            for (DynamicObject template : templates) {
                DynamicObject fsourcebill = (DynamicObject)template.get("fsourcebill");
                String sourceBill = fsourcebill.getPkValue().toString();
                billoprtconfig.put(sourceBill, dapBillEntitys.get(sourceBill));
            }
            if (billoprtconfig.size() > 0) {
                cache.put("fi-ai-dapconfigs-dapcontrol", billoprtconfig);
            }
        }
        return billoprtconfig;
    }

    private static Map<String, String> getDapBillEntitys() {
        DynamicObject[] dapconfigs = BusinessDataServiceHelper.load((String)"ai_dapconfig", (String)"id,isdap,billentity,oper", (QFilter[])new QFilter[]{new QFilter("isdap", "=", (Object)true)});
        HashMap<String, String> bills = new HashMap<String, String>(dapconfigs.length);
        for (DynamicObject config : dapconfigs) {
            bills.put(config.getString("billentity.id"), config.getString("oper"));
        }
        return bills;
    }

    public static void clearDapConfigsCache() {
        IAppCache cache = AppCache.get((String)"ai");
        cache.remove("fi-ai-dapconfigs-dapcontrol");
    }
}

