/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.bei.util.EmptyUtil;
import kd.bos.ext.fi.plugin.ArApConvert.helper.SystemParameterHelper;
import kd.bos.ext.fi.plugin.ArApConvert.util.EmptyUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.sdk.annotation.SdkDeprecated;
import org.apache.commons.lang3.StringUtils;

public class AsstactConvertHelper {
    public static final String INTERNAL = "internal";
    public static final String NO_INTERNAL = "noInternal";

    public static void setAccountBankField(ExtendedDataEntity[] entities, String entryField, String asstacttypeField, String asstactField, String accountField, String bebankField) {
        HashMap<String, Set> asstactMap = new HashMap<String, Set>(2);
        String asstactIdField = asstactField + ".id";
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            if (ObjectUtils.isEmpty((Object)entryField)) {
                if (!ObjectUtils.isEmpty((Object)bill.get(accountField)) && !ObjectUtils.isEmpty((Object)bill.get(bebankField))) continue;
                Set asstactIds = asstactMap.computeIfAbsent(bill.getString(asstacttypeField), v -> new HashSet(16));
                asstactIds.add(bill.getLong(asstactIdField));
                continue;
            }
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryField);
            for (DynamicObject entry : entries) {
                if (!ObjectUtils.isEmpty((Object)entry.get(accountField)) && !ObjectUtils.isEmpty((Object)entry.get(bebankField))) continue;
                Set asstactIds = asstactMap.computeIfAbsent(entry.getString(asstacttypeField), v -> new HashSet(16));
                asstactIds.add(entry.getLong(asstactIdField));
            }
        }
        if (ObjectUtils.isEmpty(asstactMap)) {
            return;
        }
        HashMap<Long, Map<String, Object>> accbebankMapByAsstactId = new HashMap<Long, Map<String, Object>>(16);
        for (Map.Entry asstactEntry : asstactMap.entrySet()) {
            switch ((String)asstactEntry.getKey()) {
                case "bos_user": {
                    accbebankMapByAsstactId.putAll(AsstactConvertHelper.getErPayeerAccbebankMap((Set)asstactEntry.getValue()));
                    break;
                }
                case "bd_customer": 
                case "bd_supplier": {
                    Map<String, Set<Long>> diffAsstActIdMap = AsstactConvertHelper.getDiffAsstActIdMap((String)asstactEntry.getKey(), (Set)asstactEntry.getValue());
                    accbebankMapByAsstactId.putAll(AsstactConvertHelper.getCusOrSupAccbebankMap((String)asstactEntry.getKey(), diffAsstActIdMap.get(NO_INTERNAL)));
                    AsstactConvertHelper.setInternalCusOrSupAccountBankField(diffAsstActIdMap.get(INTERNAL), entities, entryField, asstactField, accountField, bebankField);
                }
            }
        }
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            if (ObjectUtils.isEmpty((Object)entryField)) {
                Map accountBankInfo;
                if (!ObjectUtils.isEmpty((Object)bill.get(accountField)) && !ObjectUtils.isEmpty((Object)bill.get(bebankField)) || ObjectUtils.isEmpty((Object)(accountBankInfo = (Map)accbebankMapByAsstactId.get(bill.getLong(asstactIdField))))) continue;
                bill.set(accountField, accountBankInfo.get("accountStr"));
                bill.set(bebankField, accountBankInfo.get("bebank"));
                continue;
            }
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryField);
            for (DynamicObject entry : entries) {
                Map accountBankInfo;
                if (!ObjectUtils.isEmpty((Object)entry.get(accountField)) && !ObjectUtils.isEmpty((Object)entry.get(bebankField)) || ObjectUtils.isEmpty((Object)(accountBankInfo = (Map)accbebankMapByAsstactId.get(entry.getLong(asstactIdField))))) continue;
                entry.set(accountField, accountBankInfo.get("accountStr"));
                entry.set(bebankField, accountBankInfo.get("bebank"));
            }
        }
    }

    private static Map<String, Set<Long>> getDiffAsstActIdMap(String asstActType, Set<Long> asstActIdSet) {
        HashMap<String, Set<Long>> orgIdSetMap = new HashMap<String, Set<Long>>();
        if (asstActIdSet == null) {
            return orgIdSetMap;
        }
        HashSet<Long> internalAsstActIdSet = new HashSet<Long>(16);
        HashSet<Long> noInternalAsstActIdSet = new HashSet<Long>(16);
        Map<Long, Boolean> existInternalBusinessUnit = AsstactConvertHelper.isExistInternalBusinessUnit(asstActType, asstActIdSet.toArray(new Long[0]));
        for (Map.Entry<Long, Boolean> entry : existInternalBusinessUnit.entrySet()) {
            if (entry.getValue().booleanValue()) {
                internalAsstActIdSet.add(entry.getKey());
                continue;
            }
            noInternalAsstActIdSet.add(entry.getKey());
        }
        orgIdSetMap.put(INTERNAL, internalAsstActIdSet);
        orgIdSetMap.put(NO_INTERNAL, noInternalAsstActIdSet);
        return orgIdSetMap;
    }

    private static Map<Long, Boolean> isExistInternalBusinessUnit(String entityName, Long[] assIds) {
        HashMap<Long, Boolean> result = new HashMap<Long, Boolean>(assIds.length);
        if (StringUtils.isEmpty((CharSequence)entityName) || EmptyUtils.isEmpty(assIds)) {
            return result;
        }
        Map assactMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)"id,internal_company", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)assIds)});
        for (Map.Entry entrySet : assactMap.entrySet()) {
            DynamicObject asstact = (DynamicObject)entrySet.getValue();
            result.put(asstact.getLong("id"), EmptyUtils.isNotEmpty(asstact.getDynamicObject("internal_company")));
        }
        return result;
    }

    private static void setInternalCusOrSupAccountBankField(Set<Long> internalAsstActIds, ExtendedDataEntity[] entities, String entryField, String asstactField, String accountField, String bebankField) {
        for (ExtendedDataEntity entity : entities) {
            DynamicObject currency;
            DynamicObject bill = entity.getDataEntity();
            if (ObjectUtils.isEmpty((Object)entryField)) {
                currency = bill.getDynamicObject("currency");
                if (!internalAsstActIds.contains(bill.getLong(asstactField + ".id"))) continue;
                AsstactConvertHelper.setAccountBankField(bill.getDynamicObject(asstactField), bill.getLong("org.id"), bill, currency.getPkValue(), accountField, bebankField);
                continue;
            }
            currency = bill.getDynamicObject("settlecurrency");
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(entryField);
            for (DynamicObject entry : entries) {
                if (!internalAsstActIds.contains(entry.getLong(asstactField + ".id"))) continue;
                AsstactConvertHelper.setAccountBankField(entry.getDynamicObject(asstactField), bill.getLong("settleorg.id"), entry, currency.getPkValue(), accountField, bebankField);
            }
        }
    }

    private static void setAccountBankField(DynamicObject asstAct, Long settleOrgId, DynamicObject entity, Object settleCurrencyPk, String accountField, String bebankField) {
        if (entity.get(accountField) != null && entity.get(bebankField) != null) {
            return;
        }
        if (asstAct != null) {
            Map<Object, Object> accountBankInfo = AsstactConvertHelper.getDefaultBankInfoMap(asstAct, settleOrgId, settleCurrencyPk);
            entity.set(accountField, accountBankInfo.get("account"));
            entity.set(bebankField + "_id", accountBankInfo.get("bebank"));
        }
    }

    private static Map<Object, Object> getBankByAccountBank(DynamicObject payee, Object settleCurrencyPk) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        List<QFilter> payeeAccBankQFilter = AsstactConvertHelper.getPayeeAccBankQFilter(payee, true, settleCurrencyPk);
        DynamicObject account = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"id,bank.id,bankaccountnumber,bank.bebank", (QFilter[])payeeAccBankQFilter.toArray(new QFilter[0]));
        if (!ObjectUtils.isEmpty((Object)account)) {
            map.put("account", account.getString("bankaccountnumber"));
            if (!ObjectUtils.isEmpty((Object)account.getDynamicObject("bank.bebank"))) {
                map.put("bebank", account.getDynamicObject("bank.bebank").getPkValue());
            }
        }
        return map;
    }

    private static Map<Object, Object> getDefaultBankInfoMap(DynamicObject payee, Long settleOrgId, Object settleCurrencyPk) {
        if (payee != null) {
            DynamicObject internalOrg = AsstactConvertHelper.getInternalOrg(payee);
            if (internalOrg != null) {
                int internalAccSource = AsstactConvertHelper.getInternalAccountSourceParam(settleOrgId);
                if (internalAccSource == 1) {
                    return AsstactConvertHelper.getBankByAccountBank(payee, settleCurrencyPk);
                }
                if (internalAccSource == 2) {
                    return AsstactConvertHelper.getAccBeBankMapForCusOrSup(payee);
                }
            } else {
                return AsstactConvertHelper.getAccBeBankMapForCusOrSup(payee);
            }
        }
        return new HashMap<Object, Object>();
    }

    private static Map<Object, Object> getAccBeBankMapForCusOrSup(DynamicObject asstact) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getPkValue(), (String)asstact.getDataEntityType().getName());
        DynamicObjectCollection bankColls = asstact.getDynamicObjectCollection("entry_bank");
        for (int i = 0; i < bankColls.size(); ++i) {
            DynamicObject bank;
            DynamicObject bankInfo = (DynamicObject)bankColls.get(i);
            if (bankInfo.getBoolean("isdefault_bank")) {
                map.put("account", bankInfo.getString("bankaccount"));
                bank = bankInfo.getDynamicObject("bank");
                if (ObjectUtils.isEmpty((Object)bank)) break;
                map.put("bebank", bank.getLong("id"));
                break;
            }
            if (i != 0) continue;
            map.put("account", bankInfo.getString("bankaccount"));
            bank = bankInfo.getDynamicObject("bank");
            if (ObjectUtils.isEmpty((Object)bank)) continue;
            map.put("bebank", bank.getLong("id"));
        }
        map.put("settlementtypeid", asstact.getDynamicObject("settlementtypeid"));
        return map;
    }

    private static int getInternalAccountSourceParam(long orgId) {
        String internalAccSource = (String)SystemParameterHelper.getAppParameter("0efa1992000000ac", orgId, "internalaccsource");
        return EmptyUtil.isNoEmpty(internalAccSource) ? Integer.parseInt(internalAccSource) : 2;
    }

    private static DynamicObject getInternalOrg(DynamicObject baseData) {
        String entity = baseData.getDataEntityType().getName();
        return AsstactConvertHelper.getInternalOrg(entity, baseData.getPkValue());
    }

    private static DynamicObject getInternalOrg(String assActType, Object assActPk) {
        if (!"bd_customer".equals(assActType) && !"bd_supplier".equals(assActType)) {
            return null;
        }
        DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)assActPk, (String)assActType, (String)"internal_company");
        if (baseData == null) {
            return null;
        }
        return baseData.getDynamicObject("internal_company");
    }

    private static List<QFilter> getPayeeAccBankQFilter(DynamicObject payee, boolean isDefaultPay, Object currency) {
        DynamicObject useOrg;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter("acctstatus", "in", (Object)new String[]{"normal", "closing"}));
        qFilters.add(new QFilter("accttype", "in", (Object)new String[]{"in_out", "in"}));
        qFilters.add(new QFilter("currency.fbasedataid.id", "in", currency));
        if (payee != null && (useOrg = AsstactConvertHelper.getInternalOrg(payee)) != null) {
            QFilter useOrgFilter = BaseDataServiceHelper.getLookUpListFilter((String)"bd_accountbanks", (Long)((Long)useOrg.getPkValue()), null);
            qFilters.add(useOrgFilter);
        }
        if (isDefaultPay) {
            qFilters.add(new QFilter("isdefaultrec", "=", (Object)true));
        }
        return qFilters;
    }

    public static Map<Long, Map<String, Object>> getErPayeerAccbebankMap(Set<Long> userIds) {
        if (ObjectUtils.isEmpty(userIds)) {
            return new HashMap<Long, Map<String, Object>>(2);
        }
        HashMap<Long, Map<String, Object>> accbebankMapByUserId = new HashMap<Long, Map<String, Object>>(userIds.size());
        QFilter uFilter = new QFilter("payer", "in", userIds);
        uFilter = uFilter.and("status", "=", (Object)"C");
        uFilter = uFilter.and("enable", "=", (Object)Boolean.TRUE);
        Map payeerMap = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)"id,payer,payerbank,payeraccount", (QFilter[])new QFilter[]{uFilter});
        for (DynamicObject payeer : payeerMap.values()) {
            Long userId = payeer.getLong("payer.id");
            HashMap<String, Object> map = (HashMap<String, Object>)accbebankMapByUserId.get(userId);
            if (!ObjectUtils.isEmpty((Object)map) && !payeer.getBoolean("isdefault")) continue;
            map = new HashMap<String, Object>(4);
            map.put("accountStr", payeer.getString("payeraccount"));
            map.put("bebank", payeer.getDynamicObject("payerbank"));
            map.put("bebankId", payeer.getLong("payerbank.id"));
            map.put("bebankName", payeer.getString("payerbank.name"));
            accbebankMapByUserId.put(userId, map);
        }
        return accbebankMapByUserId;
    }

    public static Map<Long, Map<String, Object>> getCusOrSupAccbebankMap(String asstactType, Set<Long> asstactIds) {
        if (ObjectUtils.isEmpty(asstactIds)) {
            return new HashMap<Long, Map<String, Object>>(2);
        }
        HashMap<Long, Map<String, Object>> accbebankMapByAsstactId = new HashMap<Long, Map<String, Object>>(asstactIds.size());
        Map asstactMap = BusinessDataServiceHelper.loadFromCache((String)asstactType, (String)"id,settlementtypeid,tx_register_no,bizpartner_address,bizpartner_phone,entry_bank.isdefault_bank,entry_bank.bankaccount,entry_bank.bank", (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds)});
        for (DynamicObject asstact : asstactMap.values()) {
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            DynamicObjectCollection bankColls = asstact.getDynamicObjectCollection("entry_bank");
            for (DynamicObject bankInfo : bankColls) {
                if (!ObjectUtils.isEmpty(map) && !bankInfo.getBoolean("isdefault_bank")) continue;
                map.put("accountStr", bankInfo.getString("bankaccount"));
                map.put("bebank", bankInfo.getDynamicObject("bank"));
                map.put("bebankId", bankInfo.getLong("bank.id"));
                map.put("bebankName", bankInfo.getString("bank.name"));
            }
            map.put("settlementtypeid", asstact.getDynamicObject("settlementtypeid"));
            map.put("tx_register_no", asstact.getString("tx_register_no"));
            map.put("bizpartner_address", asstact.getLocaleString("bizpartner_address").getLocaleValue_zh_CN());
            map.put("bizpartner_phone", asstact.getString("bizpartner_phone"));
            accbebankMapByAsstactId.put(asstact.getLong("id"), map);
        }
        return accbebankMapByAsstactId;
    }

    @SdkDeprecated
    public static void setAccountBankField(DynamicObject asstact, DynamicObject entity, String accountField, String bebankField) {
        if (entity.get(accountField) != null && entity.get(bebankField) != null) {
            return;
        }
        if (asstact != null) {
            Map<String, Object> accountBankInfo = AsstactConvertHelper.getAccountBankInfo(asstact);
            entity.set(accountField, accountBankInfo.get("accountStr"));
            entity.set(bebankField, accountBankInfo.get("bebank"));
        }
    }

    private static Map<String, Object> getAccountBankInfo(DynamicObject asstact) {
        String accountStr = "";
        DynamicObject bebank = null;
        String asstactType = asstact.getDataEntityType().getName();
        if ("bos_user".equals(asstactType)) {
            DynamicObject erPayeeInfo = AsstactConvertHelper.getErPayeeInfo(asstact.getLong("id"));
            if (erPayeeInfo != null) {
                bebank = erPayeeInfo.getDynamicObject("payerbank");
                accountStr = erPayeeInfo.getString("payeraccount");
            }
        } else if ("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType)) {
            asstact = BusinessDataServiceHelper.loadSingleFromCache((Object)asstact.getPkValue(), (String)asstactType);
            DynamicObjectCollection bankInfoCollection = asstact.getDynamicObjectCollection("entry_bank");
            DynamicObject bankInfo = null;
            if (bankInfoCollection.size() > 0) {
                bankInfo = (DynamicObject)bankInfoCollection.get(0);
            }
            for (int i = 0; i < bankInfoCollection.size(); ++i) {
                DynamicObject bank = (DynamicObject)bankInfoCollection.get(i);
                if (!bank.getBoolean("isdefault_bank")) continue;
                bankInfo = bank;
                break;
            }
            if (bankInfo != null) {
                accountStr = bankInfo.getString("bankaccount");
                bebank = bankInfo.getDynamicObject("bank");
                if (!ObjectUtils.isEmpty((Object)bebank)) {
                    // empty if block
                }
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountStr", accountStr);
        map.put("bebank", bebank);
        return map;
    }

    private static DynamicObject getErPayeeInfo(long userId) {
        String orderBys;
        DynamicObject dynamicObject = null;
        QFilter uFilter = new QFilter("payer", "=", (Object)userId);
        String selectFields = "id,payerbank,payeraccount";
        QFilter[] qFilters = new QFilter[]{uFilter = uFilter.and(new QFilter("status", "=", (Object)Character.valueOf('C')))};
        DynamicObject[] defaultAccounts = BusinessDataServiceHelper.load((String)"er_payeer", (String)selectFields, (QFilter[])qFilters, (String)(orderBys = "isdefault desc"), (int)1);
        if (defaultAccounts != null && defaultAccounts.length > 0) {
            dynamicObject = defaultAccounts[0];
        }
        return dynamicObject;
    }

    public static void checkAsstactType(List<DynamicObject> entities) {
        DynamicObjectCollection execcontrols = QueryServiceHelper.query((String)"arap_execcontrol", (String)"enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"SZJK-PRE-0120")});
        if (ObjectUtils.isEmpty((Object)execcontrols)) {
            return;
        }
        List<String> asstactTypeList = Arrays.asList("bd_customer", "bd_supplier", "bos_user");
        for (DynamicObject ctrl : execcontrols) {
            if (!ctrl.getBoolean("enable")) continue;
            for (DynamicObject entity : entities) {
                String asstactType = entity.getString("asstacttype");
                if (asstactTypeList.contains(asstactType)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25\uff0c\u76ee\u6807\u5355\u7684\u5f80\u6765\u7c7b\u578b\u987b\u4e3a\u5ba2\u6237\u3001\u4f9b\u5e94\u5546\u6216\u4eba\u5458\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AsstactConvertHelper_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            }
        }
    }
}

