/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildGroupModeEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.AsstactConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;

public class BillToPayApplyConvertPlugin
extends AbstractConvertPlugIn {
    public void beforeBuildGroupMode(BeforeBuildGroupModeEventArgs e) {
        BOTPHelper.checkGroupByModeStrategy(this.getRule());
    }

    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber);
        AsstactConvertHelper.setAccountBankField(billDataEntitys, "entry", "e_asstacttype", "e_asstact", "e_assacct", "e_bebank");
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = targetBill.getDynamicObjectCollection("entry");
            BigDecimal applyAmount = BigDecimal.ZERO;
            BigDecimal approvalAmount = BigDecimal.ZERO;
            BigDecimal applySettleAmt = BigDecimal.ZERO;
            BigDecimal approvalSettleAmt = BigDecimal.ZERO;
            for (DynamicObject entry : entryEntity) {
                applyAmount = applyAmount.add(entry.getBigDecimal("e_applyamount"));
                applySettleAmt = applySettleAmt.add(entry.getBigDecimal("e_appseleamount"));
                approvalAmount = approvalAmount.add(entry.getBigDecimal("e_approvedamt"));
                approvalSettleAmt = approvalSettleAmt.add(entry.getBigDecimal("e_approvedseleamt"));
            }
            BigDecimal exchangeRate = targetBill.getBigDecimal("exchangeRate");
            if (ObjectUtils.isEmpty((Object)exchangeRate) || BigDecimal.ZERO.compareTo(exchangeRate) == 0) {
                exchangeRate = BigDecimal.ONE;
            }
            targetBill.set("exchangeRate", (Object)exchangeRate);
            targetBill.set("applyamount", (Object)applyAmount);
            targetBill.set("appseleamount", (Object)applySettleAmt);
            targetBill.set("approvalamount", (Object)approvalAmount);
            targetBill.set("aprseleamount", (Object)approvalSettleAmt);
        }
    }
}

