/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.ctbotp.plugin.save.ICtSavePlugIn;
import kd.bos.entity.ctbotp.plugin.save.args.BeforeSaveEventArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.botp.helper.QuotationHelper;
import kd.bos.ext.fi.plugin.ArApConvert.BookDateHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ArPlanSplitAndBuilder;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanSplitSchemeServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.TaxCodeConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.util.EmptyUtils;
import kd.bos.ext.fi.util.price.FXPriceLocalCalculator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class CtBillToFinArConvertSavePlugin
implements ICtSavePlugIn {
    private static Log logger = LogFactory.getLog(CtBillToFinArConvertSavePlugin.class);
    private Map<Long, DynamicObject> orgInitMap;
    public static final String ExRate_CONVERT_MODE_DIRECT = "0";
    public static final String ExRate_CONVERT_MODE_INDIRECT = "1";
    private final Map<Long, Boolean> orgIsTaxMap = new HashMap<Long, Boolean>(1);
    private final List<Object> bizPartnerIds = new ArrayList<Object>(8);
    private DynamicObject[] needMatchSplitSchemes;

    public void beforeSave(BeforeSaveEventArgs e) {
        List entities = e.getDynamicObjects();
        this.prepareData(entities);
        for (DynamicObject finArBill : entities) {
            DynamicObject org = finArBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            this.checkOrgInit(org, this.orgInitMap, true);
            this.setHeadValue(finArBill);
            this.setDetailEntryValue(finArBill);
        }
        for (DynamicObject finArBill : entities) {
            this.setHeadAmtValue(finArBill);
            this.setPlanEntryValue(finArBill);
        }
        BookDateHelper.setBookDate(entities.toArray(new DynamicObject[0]), true);
        logger.info("CtBillToFinArConvertPlugin.afterConvert end");
    }

    private void prepareData(List<DynamicObject> entities) {
        logger.info("CtBillToFinArConvertPlugin.prepareData start");
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashMap<String, List> asstactTypeToAsstactIdMap = new HashMap<String, List>(8);
        for (DynamicObject dynamicObject : entities) {
            List asstactIds = asstactTypeToAsstactIdMap.computeIfAbsent(dynamicObject.getString("asstacttype"), c -> new ArrayList(8));
            asstactIds.add(dynamicObject.getLong("asstact.id"));
            long orgId = dynamicObject.getLong("org.id");
            if (orgId == 0L) continue;
            orgIds.add(orgId);
        }
        this.orgInitMap = this.loadInitInfos(orgIds, true);
        for (Long l : orgIds) {
            this.orgIsTaxMap.put(l, TaxCodeConvertHelper.isNeedTax(l, true));
        }
        for (Map.Entry entry : asstactTypeToAsstactIdMap.entrySet()) {
            this.bizPartnerIds.addAll(CtBillToFinArConvertSavePlugin.getBizPartnerIds((String)entry.getKey(), (List)entry.getValue()));
        }
        this.needMatchSplitSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes("ar_finarbill", 0L);
        logger.info("CtBillToFinArConvertPlugin.prepareData end");
    }

    private void setHeadValue(DynamicObject finArBill) {
        logger.info("BillToFinArConvertPlugin.setHeadValue start");
        DynamicObject org = finArBill.getDynamicObject("org");
        this.setBizDate(finArBill, this.orgInitMap.get(org.getLong("id")), null);
        boolean isSettingForExchange = EmptyUtils.isNotEmpty(finArBill.get("exchangerate"));
        CtBillToFinArConvertSavePlugin.setInitValue(finArBill, this.orgInitMap.get(org.getLong("id")), isSettingForExchange);
        DynamicObject recorg = finArBill.getDynamicObject("recorg");
        if (ObjectUtils.isEmpty((Object)recorg) || !recorg.getBoolean("fisbankroll")) {
            finArBill.set("recorg", (Object)org);
            recorg = org;
        }
        if (!ObjectUtils.isEmpty((Object)recorg) && !recorg.getBoolean("fisbankroll")) {
            finArBill.set("recorg", null);
        }
        finArBill.set("relationpay", (Object)this.bizPartnerIds.contains(finArBill.getLong("asstact.id")));
        logger.info("CtBillToFinArConvertPlugin.setHeadValue end");
    }

    private void checkOrgInit(DynamicObject org, Map<Long, DynamicObject> orgInitMap, boolean isAr) {
        DynamicObject orgInit = orgInitMap.get(org.getLong("id"));
        boolean isInit = true;
        if (orgInit == null) {
            isInit = false;
        } else {
            Date startdate = orgInit.getDate("startdate");
            if (startdate == null) {
                isInit = false;
            }
        }
        if (!isInit) {
            ErrorCode ARAPORGNAME_NOT_SET = isAr ? new ErrorCode("ARAPORGNAME_NOT_SET_2", ResManager.loadKDString((String)"\u7ec4\u7ec7:%1$s\u6ca1\u6709\u8fdb\u884c\u5e94\u6536\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u5230\u5e94\u6536\u5e94\u7528\u4e0b\u5148\u8fdb\u884c\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u8bd5\u3002", (String)"ARAPORGNAME_NOT_SET_2", (String)"bos-ext-fi", (Object[])new Object[0])) : new ErrorCode("ARAPORGNAME_NOT_SET_1", ResManager.loadKDString((String)"\u7ec4\u7ec7:%1$s\u6ca1\u6709\u8fdb\u884c\u5e94\u4ed8\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u5230\u5e94\u4ed8\u5e94\u7528\u4e0b\u5148\u8fdb\u884c\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u8bd5\u3002", (String)"ARAPORGNAME_NOT_SET_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            throw new KDBizException(ARAPORGNAME_NOT_SET, new Object[]{org.getLocaleString("name").getLocaleValue()});
        }
    }

    private Map<Long, DynamicObject> loadInitInfos(Set<Long> orgIds, boolean isAr) {
        HashMap<Long, DynamicObject> initInfoMap = new HashMap<Long, DynamicObject>(8);
        QFilter qFilter = new QFilter("org", "in", orgIds);
        if (isAr) {
            DynamicObject[] inits;
            for (DynamicObject initInfo : inits = BusinessDataServiceHelper.load((String)"ar_init", (String)(this.getInitSelectors() + ", policytype.type"), (QFilter[])new QFilter[]{qFilter})) {
                Long orgId = initInfo.getLong("org.id");
                String policytype = initInfo.getString("policytype.type");
                if ("master".equals(policytype)) {
                    initInfoMap.put(orgId, initInfo);
                    continue;
                }
                initInfoMap.putIfAbsent(orgId, initInfo);
            }
        } else {
            DynamicObject[] inits;
            for (DynamicObject initInfo : inits = BusinessDataServiceHelper.load((String)"ap_init", (String)this.getInitSelectors(), (QFilter[])new QFilter[]{qFilter})) {
                initInfoMap.put(initInfo.getLong("org.id"), initInfo);
            }
        }
        return initInfoMap;
    }

    private String getInitSelectors() {
        ArrayList<String> selectors = new ArrayList<String>(8);
        selectors.add("id");
        selectors.add("org");
        selectors.add("standardcurrency");
        selectors.add("exratetable");
        selectors.add("isfinishinit");
        selectors.add("startdate");
        selectors.add("currentdate");
        return String.join((CharSequence)",", selectors);
    }

    private void setBizDate(DynamicObject finBill, DynamicObject init, ConvertRuleElement rule) {
        boolean isSettingForBizDate = CtBillToFinArConvertSavePlugin.ruleIsSetting(rule, false, "bizdate");
        Date bizdate = finBill.getDate("bizdate");
        if (!isSettingForBizDate) {
            Date currentdate;
            Date date = currentdate = ObjectUtils.isEmpty((Object)init.getDate("currentdate")) ? init.getDate("startdate") : init.getDate("currentdate");
            if (currentdate != null && bizdate != null && currentdate.compareTo(bizdate) > 0) {
                finBill.set("bizdate", (Object)currentdate);
            }
        }
        if (bizdate == null) {
            finBill.set("bizdate", (Object)new Date());
        }
    }

    private void setDetailEntryValue(DynamicObject finArBill) {
        logger.info("CtBillToFinArConvertSavePlugin.setDetailEntryValue start");
        int basePrecision = finArBill.getInt("basecurrency.amtprecision");
        boolean includeTax = finArBill.getBoolean("isincludetax");
        String quotation = finArBill.getString("quotation");
        BigDecimal exchangeRate = finArBill.getBigDecimal("exchangerate");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0 && ExRate_CONVERT_MODE_INDIRECT.equals(quotation)) {
            quotation = ExRate_CONVERT_MODE_DIRECT;
        }
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal e_tax = detailEntry.getBigDecimal("e_tax");
            BigDecimal e_recAmount = detailEntry.getBigDecimal("e_recamount");
            BigDecimal e_amount = detailEntry.getBigDecimal("e_amount");
            BigDecimal discountamount = detailEntry.getBigDecimal("e_discountamount");
            BigDecimal eAdjustamount = detailEntry.getBigDecimal("e_adjustamount");
            FXPriceLocalCalculator calculator = new FXPriceLocalCalculator(includeTax, e_tax, e_amount, discountamount, exchangeRate, basePrecision, eAdjustamount, quotation);
            calculator.calculate();
            BigDecimal e_amountbase = calculator.getAmountLocal();
            BigDecimal e_taxlocamt = calculator.getTaxLocal();
            BigDecimal e_pricetaxtotalbase = calculator.getPriceTaxTotalLocal();
            BigDecimal discountamountLocal = calculator.getDiscountamountLocal();
            BigDecimal e_adjustlocalamt = calculator.getAdjustamtlocal();
            detailEntry.set("e_discountlocalamt", (Object)discountamountLocal);
            detailEntry.set("e_localamt", (Object)e_amountbase);
            detailEntry.set("e_taxlocalamt", (Object)e_taxlocamt);
            detailEntry.set("e_reclocalamt", (Object)e_pricetaxtotalbase);
            detailEntry.set("e_unsettlelocalamt", (Object)e_pricetaxtotalbase);
            detailEntry.set("e_adjustlocalamt", (Object)e_adjustlocalamt);
            detailEntry.set("e_uninvoicedlocalamt", (Object)e_pricetaxtotalbase);
            BigDecimal quantity = detailEntry.getBigDecimal("e_quantity");
            BigDecimal e_baseunitqty = detailEntry.getBigDecimal("e_baseunitqty");
            detailEntry.set("e_unverifyamt", (Object)e_amount);
            detailEntry.set("e_unlockamt", (Object)e_recAmount);
            detailEntry.set("e_unsettleamt", (Object)e_recAmount);
            detailEntry.set("e_unconfirmamt", (Object)e_amount);
            detailEntry.set("e_uninvoicedamt", (Object)e_recAmount);
            detailEntry.set("e_unconfirmqty", (Object)quantity);
            detailEntry.set("e_unconfirmbaseqty", (Object)e_baseunitqty);
            detailEntry.set("e_unverifyqty", (Object)quantity);
            detailEntry.set("e_uninvoicedqty", (Object)quantity);
        }
        logger.info("CtBillToFinArConvertSavePlugin.setDetailEntryValue end");
    }

    private void setHeadAmtValue(DynamicObject finArBill) {
        logger.info("BillToFinArConvertPlugin.setHeadAmtValue start");
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotal = priceTaxTotal.add(detailEntry.getBigDecimal("e_recamount"));
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_reclocalamt"));
            amount = amount.add(detailEntry.getBigDecimal("e_amount"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_localamt"));
            tax = tax.add(detailEntry.getBigDecimal("e_tax"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamt = adjustamt.add(detailEntry.getBigDecimal("e_adjustamount"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finArBill.set("recamount", (Object)priceTaxTotal);
        finArBill.set("reclocalamt", (Object)priceTaxTotalBase);
        finArBill.set("amount", (Object)amount);
        finArBill.set("localamt", (Object)amountBase);
        finArBill.set("tax", (Object)tax);
        finArBill.set("taxlocamt", (Object)taxLocAmt);
        finArBill.set("unverifyamount", (Object)amount);
        finArBill.set("unsettleamount", (Object)priceTaxTotal);
        finArBill.set("unsettlelocalamt", (Object)priceTaxTotalBase);
        finArBill.set("adjustamount", (Object)adjustamt);
        finArBill.set("adjustlocalamt", (Object)adjustamtlocal);
        finArBill.set("uninvoicedamt", (Object)priceTaxTotal);
        finArBill.set("uninvoicedlocalamt", (Object)priceTaxTotalBase);
        logger.info("BillToFinArConvertPlugin.setHeadAmtValue end");
    }

    private void setPlanEntryValue(DynamicObject finArBill) {
        logger.info("BillToFinArConvertPlugin.setPlanEntryValue start");
        DynamicObject matchSplitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme(finArBill, this.needMatchSplitSchemes);
        finArBill.set("splitscheme", (Object)matchSplitScheme);
        ArPlanSplitAndBuilder.splitAndBuild(finArBill, matchSplitScheme);
        this.setHeadDueDate(finArBill);
        logger.info("BillToFinArConvertPlugin.setPlanEntryValue end");
    }

    private void setHeadDueDate(DynamicObject finArBill) {
        Date planMaxDuedate = finArBill.getDate("duedate");
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finArBill.set("duedate", (Object)planMaxDuedate);
    }

    public static void setInitValue(DynamicObject finBill, DynamicObject init, boolean isSetting) {
        DynamicObject basecurrency = init.getDynamicObject("standardcurrency");
        finBill.set("basecurrency", (Object)basecurrency);
        if (ObjectUtils.isEmpty((Object)finBill.get("exratetable"))) {
            finBill.set("exratetable", (Object)init.getDynamicObject("exratetable"));
        }
        if (ObjectUtils.isEmpty((Object)finBill.get("exratedate"))) {
            finBill.set("exratedate", (Object)new Date());
        }
        long srcCurrencyId = finBill.getLong("currency.id");
        String quotation = finBill.getString("quotation");
        BigDecimal exchangerate = finBill.getBigDecimal("exchangerate");
        if (!isSetting || ObjectUtils.isEmpty((Object)exchangerate) || BigDecimal.ZERO.compareTo(exchangerate) == 0 || ObjectUtils.isEmpty((Object)quotation) || quotation.equals(ExRate_CONVERT_MODE_DIRECT)) {
            long destCurrencyId = basecurrency.getLong("id");
            if (srcCurrencyId == destCurrencyId) {
                finBill.set("quotation", (Object)ExRate_CONVERT_MODE_DIRECT);
                finBill.set("exchangerate", (Object)BigDecimal.valueOf(1L));
            } else {
                QuotationHelper quotationHelper = new QuotationHelper();
                Tuple<String, BigDecimal> tuple = quotationHelper.getExchangeRateMap(finBill.getLong("exratetable.id"), srcCurrencyId, destCurrencyId, finBill.getDate("exratedate"));
                if (ObjectUtils.isEmpty((Object)quotation) || quotation.equals(ExRate_CONVERT_MODE_DIRECT)) {
                    finBill.set("quotation", tuple.item1);
                }
                if (!isSetting || ObjectUtils.isEmpty((Object)exchangerate) || BigDecimal.ZERO.compareTo(exchangerate) == 0) {
                    finBill.set("exchangerate", tuple.item2);
                }
            }
        }
    }

    private static List<Object> getBizPartnerIds(String asstactType, List<Object> asstactIds) {
        List<Object> bizPartnerIds = new ArrayList<Object>(2);
        if (!asstactIds.isEmpty() && ("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType))) {
            bizPartnerIds = QueryServiceHelper.queryPrimaryKeys((String)asstactType, (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds), new QFilter("internal_company", "!=", (Object)0L)}, (String)"", (int)-1);
        }
        return bizPartnerIds;
    }

    private static boolean ruleIsSetting(ConvertRuleElement rule, boolean onlySourceField, String fieldKey) {
        boolean isSetting = false;
        if (rule != null && !ObjectUtils.isEmpty((Object)fieldKey)) {
            List fieldMaps = rule.getFieldMapPolicy().getFieldMaps();
            for (FieldMapItem field : fieldMaps) {
                if (!fieldKey.equals(field.getTargetFieldKey())) continue;
                if ("SourceField".equals(field.getConvertType()) && !ObjectUtils.isEmpty((Object)field.getSourceFieldKey())) {
                    isSetting = true;
                    break;
                }
                if (onlySourceField || "SourceField".equals(field.getConvertType()) || ObjectUtils.isEmpty((Object)field.getFormula())) break;
                isSetting = true;
                break;
            }
        }
        return isSetting;
    }
}

