/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.BookDateHelper;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.util.QueryUtil;
import kd.bos.ext.fi.util.price.FXPriceLocalCalculator;

public class RevcfmbillConvertPlugin
extends AbstractConvertPlugIn {
    protected DynamicObject init = null;
    private String targetEntityNumber;

    public void initVariable(InitVariableEventArgs e) {
        this.targetEntityNumber = this.getTgtMainType().getName();
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey(this.targetEntityNumber);
        HashMap<Long, List<DynamicObject>> revcfmBillByOrgId = new HashMap<Long, List<DynamicObject>>(4);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            Long orgId = bill.getLong("org.id");
            if (ObjectUtils.isEmpty((Object)orgId)) {
                return;
            }
            List revcfmBillList = revcfmBillByOrgId.computeIfAbsent(orgId, a -> new ArrayList(64));
            revcfmBillList.add(bill);
        }
        new InitConvertHelper("ar_init", this.getRule(), revcfmBillByOrgId);
        QueryUtil queryUtil = new QueryUtil();
        HashSet<DynamicObject> revcfmBills = new HashSet<DynamicObject>(entities.length);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            revcfmBills.add(bill);
            DynamicObject org = bill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            int precision = bill.getInt("currency.amtprecision");
            int basePrecision = bill.getInt("basecurrency.amtprecision");
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            BigDecimal exchangeRate = bill.getBigDecimal("exchangerate");
            String quotation = bill.getString("quotation");
            if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                quotation = "0";
            }
            boolean includeTax = bill.getBoolean("isincludetax");
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal pricetaxtotal = BigDecimal.ZERO;
            BigDecimal localamt = BigDecimal.ZERO;
            BigDecimal taxlocalamt = BigDecimal.ZERO;
            BigDecimal pricetaxtotalbase = BigDecimal.ZERO;
            BigDecimal confirmamt = BigDecimal.ZERO;
            BigDecimal confirmlocamt = BigDecimal.ZERO;
            BigDecimal quantity = BigDecimal.ZERO;
            BigDecimal confirmQty = BigDecimal.ZERO;
            for (DynamicObject entry : entries) {
                BigDecimal e_confirmLocPriceTaxTotal;
                BigDecimal e_confirmLocTax;
                BigDecimal e_confirmLocAmt;
                BigDecimal e_confirmPriceTaxTotal;
                BigDecimal e_confirmTax;
                BigDecimal e_amount = entry.getBigDecimal("e_amount");
                amount = amount.add(e_amount);
                BigDecimal e_tax = entry.getBigDecimal("e_tax");
                tax = tax.add(e_tax);
                BigDecimal e_pricetaxtotal = entry.getBigDecimal("e_pricetaxtotal");
                pricetaxtotal = pricetaxtotal.add(e_pricetaxtotal);
                BigDecimal discountAmt = entry.getBigDecimal("e_discountamount");
                FXPriceLocalCalculator localCalculator = new FXPriceLocalCalculator(includeTax, e_tax, e_amount, discountAmt, exchangeRate, basePrecision, BigDecimal.ZERO, quotation);
                localCalculator.calculate();
                BigDecimal e_localamt = localCalculator.getAmountLocal();
                localamt = localamt.add(e_localamt);
                entry.set("e_localamt", (Object)e_localamt);
                BigDecimal e_taxlocalamt = localCalculator.getTaxLocal();
                taxlocalamt = taxlocalamt.add(e_taxlocalamt);
                entry.set("e_taxlocalamt", (Object)e_taxlocalamt);
                BigDecimal e_pricetaxtotalbase = localCalculator.getPriceTaxTotalLocal();
                pricetaxtotalbase = pricetaxtotalbase.add(e_pricetaxtotalbase);
                entry.set("e_pricetaxtotalbase", (Object)e_pricetaxtotalbase);
                entry.set("e_unverifyqty", (Object)entry.getBigDecimal("e_confirmqty"));
                BigDecimal e_quantity = entry.getBigDecimal("e_quantity");
                if (e_quantity == null) {
                    e_quantity = BigDecimal.ZERO;
                }
                quantity = quantity.add(e_quantity);
                entry.set("e_actunitprice", (Object)e_amount.divide(e_quantity, 10, RoundingMode.HALF_UP));
                entry.set("e_acttaxunitprice", (Object)e_pricetaxtotal.divide(e_quantity, 10, RoundingMode.HALF_UP));
                BigDecimal covertRate = entry.getBigDecimal("e_unitcoefficient");
                boolean covertRateIsEmpty = covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0;
                DynamicObject material = entry.getDynamicObject("e_material");
                DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
                DynamicObject baseUnit = entry.getDynamicObject("e_baseunitid");
                if (!ObjectUtils.isEmpty((Object)material)) {
                    if (ObjectUtils.isEmpty((Object)baseUnit)) {
                        baseUnit = material.getDynamicObject("baseunit");
                        entry.set("e_baseunitid", (Object)baseUnit);
                    }
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if (covertRateIsEmpty) {
                        covertRate = queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                    }
                } else if (covertRateIsEmpty) {
                    covertRate = BigDecimal.ONE;
                }
                if (covertRateIsEmpty) {
                    entry.set("e_unitcoefficient", (Object)covertRate);
                }
                if (entry.getBigDecimal("e_baseunitqty").compareTo(BigDecimal.ZERO) == 0) {
                    entry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(e_quantity, covertRate, baseUnit));
                }
                BigDecimal e_confirmQty = entry.getBigDecimal("e_confirmqty");
                confirmQty = confirmQty.add(e_confirmQty);
                if (entry.getBigDecimal("e_confirmBaseQty").compareTo(BigDecimal.ZERO) == 0) {
                    entry.set("e_confirmBaseQty", (Object)InitConvertHelper.getBaseunitqty(e_confirmQty, covertRate, baseUnit));
                }
                BigDecimal e_confirmBaseQty = entry.getBigDecimal("e_confirmbaseqty");
                entry.set("e_unverifybaseqty", (Object)e_confirmBaseQty);
                BigDecimal e_confirmAmt = entry.getBigDecimal("e_confirmamt");
                BigDecimal taxrate = entry.getBigDecimal("e_taxrate").divide(new BigDecimal("100"));
                if (e_confirmAmt.compareTo(e_amount) == 0) {
                    e_confirmAmt = e_amount;
                    e_confirmTax = e_tax;
                    e_confirmPriceTaxTotal = e_pricetaxtotal;
                    e_confirmLocAmt = e_localamt;
                    e_confirmLocTax = e_taxlocalamt;
                    e_confirmLocPriceTaxTotal = e_pricetaxtotalbase;
                } else if (includeTax) {
                    e_confirmPriceTaxTotal = entry.getBigDecimal("e_cfmpricetax");
                    e_confirmTax = e_confirmPriceTaxTotal.multiply(taxrate).divide(BigDecimal.ONE.add(taxrate), precision, RoundingMode.HALF_UP);
                    e_confirmAmt = e_confirmPriceTaxTotal.subtract(e_confirmTax);
                    e_confirmLocPriceTaxTotal = this.getLocalAmt(e_confirmPriceTaxTotal, quotation, exchangeRate, basePrecision);
                    e_confirmLocTax = this.getLocalAmt(e_confirmTax, quotation, exchangeRate, basePrecision);
                    e_confirmLocAmt = e_confirmLocPriceTaxTotal.subtract(e_confirmLocTax);
                } else {
                    e_confirmAmt = entry.getBigDecimal("e_confirmamt");
                    e_confirmTax = e_confirmAmt.multiply(taxrate).setScale(precision, RoundingMode.HALF_UP);
                    e_confirmPriceTaxTotal = e_confirmAmt.add(e_confirmTax);
                    e_confirmLocAmt = this.getLocalAmt(e_confirmAmt, quotation, exchangeRate, basePrecision);
                    e_confirmLocTax = this.getLocalAmt(e_confirmTax, quotation, exchangeRate, basePrecision);
                    e_confirmLocPriceTaxTotal = e_confirmLocAmt.add(e_confirmLocTax);
                }
                entry.set("e_confirmamt", (Object)e_confirmAmt);
                confirmamt = confirmamt.add(e_confirmAmt);
                entry.set("e_unverifyamt", (Object)e_confirmAmt);
                entry.set("e_confirmlocamt", (Object)e_confirmLocAmt);
                confirmlocamt = confirmlocamt.add(e_confirmLocAmt);
                entry.set("e_confirmtax", (Object)e_confirmTax);
                entry.set("e_confirmloctax", (Object)e_confirmLocTax);
                entry.set("e_cfmpricetax", (Object)e_confirmPriceTaxTotal);
                entry.set("e_cfmpricetaxbase", (Object)e_confirmLocPriceTaxTotal);
                entry.set("e_unrecqty", (Object)e_confirmQty);
                entry.set("e_unrecbaseqty", (Object)e_confirmBaseQty);
                entry.set("e_recqty", (Object)BigDecimal.ZERO);
                entry.set("e_recbaseqty", (Object)BigDecimal.ZERO);
                entry.set("e_unrecamt", (Object)e_confirmAmt);
                entry.set("e_recamt", (Object)BigDecimal.ZERO);
                BigDecimal e_confirmRate = new BigDecimal(100);
                if (e_amount.compareTo(BigDecimal.ZERO) != 0 || e_quantity.compareTo(BigDecimal.ZERO) != 0) {
                    e_confirmRate = e_quantity.compareTo(BigDecimal.ZERO) != 0 ? e_confirmQty.multiply(BigDecimal.valueOf(100L)).divide(e_quantity, 2, 4) : e_confirmAmt.multiply(BigDecimal.valueOf(100L)).divide(e_amount, 2, 4);
                }
                entry.set("e_confirmrate", (Object)e_confirmRate);
            }
            bill.set("amount", (Object)amount);
            bill.set("localamt", (Object)localamt);
            bill.set("tax", (Object)tax);
            bill.set("taxlocamt", (Object)taxlocalamt);
            bill.set("pricetaxtotal", (Object)pricetaxtotal);
            bill.set("pricetaxtotalbase", (Object)pricetaxtotalbase);
            bill.set("confirmamt", (Object)confirmamt);
            bill.set("confirmlocamt", (Object)confirmlocamt);
            bill.set("unverifyamt", (Object)confirmamt);
            BigDecimal confirmRate = new BigDecimal(100);
            if (amount.compareTo(BigDecimal.ZERO) != 0 || quantity.compareTo(BigDecimal.ZERO) != 0) {
                confirmRate = quantity.compareTo(BigDecimal.ZERO) != 0 ? confirmQty.multiply(BigDecimal.valueOf(100L)).divide(quantity, 2, 4) : confirmamt.multiply(BigDecimal.valueOf(100L)).divide(amount, 2, 4);
            }
            bill.set("confirmrate", (Object)confirmRate);
        }
        BookDateHelper.setBookDate(revcfmBills.toArray(new DynamicObject[0]), true);
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }
}

