/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.thread;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadExecutorService;
import kd.bos.ext.fi.thread.ThreadService;

public class BlockedExecutor
implements ThreadExecutorService {
    static final BlockedExecutor INSTANCE = new BlockedExecutor();
    private final Map<String, BlockingTaskQueue> taskQueueMap = Collections.synchronizedMap(new HashMap(4));

    @Override
    public void execute(Runnable runnable, String taskType, RequestContext requestContext, OperationContext operationContext) {
        BlockingTaskQueue taskQueue = this.getTaskQueue(taskType);
        TaskWrap task = new TaskWrap(runnable, taskType, requestContext, operationContext);
        this.enqueue(task, taskQueue);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable, String taskType, RequestContext requestContext, OperationContext operationContext) {
        TaskWrap<T> task = new TaskWrap<T>(callable, taskType, requestContext, operationContext);
        BlockingTaskQueue taskQueue = this.getTaskQueue(taskType);
        this.enqueue(task, taskQueue);
        return task;
    }

    void enqueue(TaskWrap task, BlockingTaskQueue taskQueue) {
        taskQueue.offer(task);
    }

    private BlockingTaskQueue getTaskQueue(String taskType) {
        return this.taskQueueMap.computeIfAbsent(taskType, BlockingTaskQueue::new);
    }

    class TaskWrap<T>
    extends FutureTask<T> {
        private final String taskType;
        private final RequestContext context;
        private final OperationContext oc;

        public TaskWrap(Callable<T> callable, String taskType, RequestContext context, OperationContext oc) {
            super(callable);
            this.taskType = taskType;
            this.context = context;
            this.oc = oc;
        }

        public TaskWrap(Runnable runnable, String taskType, RequestContext context, OperationContext oc) {
            super(runnable, null);
            this.taskType = taskType;
            this.context = context;
            this.oc = oc;
        }

        @Override
        public void run() {
            try {
                super.run();
            }
            finally {
                BlockedExecutor.this.getTaskQueue(this.taskType).poll();
            }
        }
    }

    static class BlockingTaskQueue {
        final BlockingQueue<Object> taskQueue;
        final String taskType;

        BlockingTaskQueue(String taskType) {
            this.taskType = taskType;
            this.taskQueue = new LinkedBlockingQueue<Object>(this.getQueueMaxSize(taskType));
        }

        final int getQueueMaxSize(String taskTypeStr) {
            for (TaskType taskType : TaskType.values()) {
                if (!taskType.getName().equals(taskTypeStr)) continue;
                return taskType.getTaskQueueMaxSize();
            }
            throw new IllegalStateException("illegal task type name:" + taskTypeStr);
        }

        void offer(TaskWrap task) {
            try {
                if (!this.taskQueue.offer(new Object(), 1L, TimeUnit.DAYS)) {
                    throw new IllegalStateException("thread push time-out.");
                }
                ThreadService.getThreadExecutor().execute((Runnable)task, task.taskType, task.context, task.oc);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("InterruptedException blocked.", e);
            }
        }

        void poll() {
            this.taskQueue.poll();
        }
    }
}

