/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.ext.fi.thread.BlockedExecutor;
import kd.bos.ext.fi.thread.ThreadExecutorService;
import kd.bos.ext.fi.thread.ThreadService;

public enum ExtThreadStrategy {
    DEFAULT,
    BLOCKED;


    ThreadExecutorService getExecuteService() {
        switch (this) {
            case BLOCKED: {
                return BlockedExecutor.INSTANCE;
            }
            case DEFAULT: {
                return DefaultExecutor.INSTANCE;
            }
        }
        throw new IllegalStateException("unknown strategy.");
    }

    private static class DefaultExecutor
    implements ThreadExecutorService {
        static final DefaultExecutor INSTANCE = new DefaultExecutor();

        private DefaultExecutor() {
        }

        @Override
        public void execute(Runnable runnable, String s, RequestContext requestContext, OperationContext operationContext) {
            ThreadService.getThreadExecutor().execute(runnable, s, requestContext, operationContext);
        }

        @Override
        public <T> Future<T> submit(Callable<T> callable, String s, RequestContext requestContext, OperationContext operationContext) {
            return ThreadService.getThreadExecutor().submit(callable, s, requestContext, operationContext);
        }
    }
}

