/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.validate;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.v2.fah.BuildXlaOrGlSelectModeServiceImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.log4j.Logger;

public class HasVoucherValidator
extends AbstractValidator {
    private static final String FI_AI_DAP_BILLTYPE = "fi-ai-dap-billtype";
    private static Logger log = Logger.getLogger(HasVoucherValidator.class);

    public void validate() {
        log.info((Object)"\u6267\u884c\u201c\u5355\u636e\u662f\u5426\u751f\u6210\u51ed\u8bc1\u6821\u9a8c\u5668\u201d\u6821\u9a8c");
        if (this.dataEntities == null || this.dataEntities.length == 0) {
            return;
        }
        this.validateFahAndAiDapTracker();
    }

    private void validateFahAndAiDapTracker() {
        if (!new BuildXlaOrGlSelectModeServiceImpl().getBuildXlaOrGlSelectMode(this.getEntityKey()) && !this.getCachedVoucherBillTypes().contains(this.getEntityKey())) {
            return;
        }
        HashSet<Long> idSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            idSet.add(dataEntity.getDataEntity().getLong("id"));
        }
        Map<String, Set<Long>> billIdMap = DapVoucherUtil.getBillIdByFahAndAiTracker(this.getEntityKey(), idSet);
        if (billIdMap.isEmpty()) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            Long id = dataEntity.getDataEntity().getLong("id");
            for (Map.Entry<String, Set<Long>> entry : billIdMap.entrySet()) {
                if (!entry.getValue().contains(id)) continue;
                String operationName = this.getOperationName();
                if (ResManager.loadKDString((String)"\u672a\u77e5\u65b9\u6cd5", (String)"HasVoucherValidator_0", (String)"bos-ext-fi", (Object[])new Object[0]).equals(operationName)) {
                    operationName = ResManager.loadKDString((String)"\u6267\u884c\u8be5\u64cd\u4f5c", (String)"HasVoucherValidator_1", (String)"bos-ext-fi", (Object[])new Object[0]);
                }
                String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u80fd%1$s\u3002", (String)"HasVoucherValidator_2", (String)"bos-ext-fi", (Object[])new Object[0]), operationName);
                this.addMessage(dataEntity, message, ErrorLevel.Error);
            }
        }
    }

    private Set<String> getCachedVoucherBillTypes() {
        IAppCache cache = AppCache.get((String)"ai");
        HashSet<String> billTypes = (HashSet<String>)cache.get(FI_AI_DAP_BILLTYPE, Set.class);
        if (billTypes == null) {
            billTypes = new HashSet<String>();
            QFilter modeltypeQfilter = new QFilter("modeltype", "=", (Object)"BillFormModel");
            QFilter voucherQfilter = new QFilter("voucher", "=", (Object)"1");
            try (DataSet childDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_entityobject", (String)"id", (QFilter[])new QFilter[]{modeltypeQfilter, voucherQfilter}, null);){
                for (Row rowChild : childDataSet) {
                    billTypes.add(rowChild.getString("id"));
                }
            }
            cache.put(FI_AI_DAP_BILLTYPE, billTypes);
        }
        return billTypes;
    }
}

