/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.dap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.IOperationTask;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fs.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class DapControlImpl
implements IOperationTask {
    private static Log log = LogFactory.getLog(DapControlImpl.class);
    private String billTypeKey;
    private String operationKey;
    private static final Map<String, String> optPairs = new HashMap<String, String>();
    private static final Set<String> antiOptSet = new HashSet<String>();

    public void execute(OperationContext context, DynamicObject[] colls, OperationResult operationResult) {
        this.billTypeKey = context.getEntityTypeId();
        this.operationKey = context.getOperationKey();
        this.generateVoucher(operationResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateVoucher(OperationResult operationResult) {
        block6: {
            try {
                Map<String, String> dapconfigs = this.getCachedDapConfigs();
                if (!dapconfigs.containsKey(this.billTypeKey) || !this.operationKey.equalsIgnoreCase(dapconfigs.get(this.billTypeKey))) {
                    return;
                }
                List successPkIds = operationResult.getSuccessPkIds();
                if (successPkIds == null || successPkIds.size() <= 0) break block6;
                try (MessagePublisher pub = MQFactory.get().createSimplePublisher("fi", "kd.fi.ai.DapQueue");){
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("billIds", successPkIds);
                    params.put("billEntity", this.billTypeKey);
                    pub.publish(params);
                }
            }
            catch (Exception e) {
                log.error("\u5355\u636e\u751f\u6210\u51ed\u8bc1\u53d1\u9001\u6d88\u606f\u961f\u5217\u5931\u8d25\uff0c\u5355\u636e\u7f16\u7801\uff1a" + this.billTypeKey + ", ", (Throwable)e);
            }
        }
    }

    private Map<String, String> getCachedDapConfigs() {
        HashMap<String, String> billoprtconfig;
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fi-ai");
        String jsonOperation = (String)cache.get("fi-ai-dapconfigs-dapcontrol");
        if (!StringUtils.isEmpty((String)jsonOperation)) {
            billoprtconfig = (HashMap<String, String>)SerializationUtils.fromJsonString((String)jsonOperation, Map.class);
        } else {
            DynamicObject[] configs = BusinessDataServiceHelper.load((String)"ai_vchtemplate", (String)"fsourcebill,oper", (QFilter[])new QFilter[]{new QFilter("fsourcebill.id", "in", this.getDapBillEntitys()), new QFilter("enable", "!=", (Object)"0")});
            billoprtconfig = new HashMap<String, String>(configs.length);
            for (DynamicObject config : configs) {
                DynamicObject fsourcebill = (DynamicObject)config.get("fsourcebill");
                billoprtconfig.put(fsourcebill.getPkValue().toString(), config.getString("oper"));
            }
            if (billoprtconfig.size() > 0) {
                cache.put("fi-ai-dapconfigs-dapcontrol", (Object)SerializationUtils.toJsonString(billoprtconfig));
            }
        }
        return billoprtconfig;
    }

    private List<String> getDapBillEntitys() {
        DynamicObject[] dapconfigs = BusinessDataServiceHelper.load((String)"ai_dapconfig", (String)"id,isdap,billentity", (QFilter[])new QFilter[]{new QFilter("isdap", "=", (Object)true)});
        ArrayList<String> bills = new ArrayList<String>(dapconfigs.length);
        for (DynamicObject config : dapconfigs) {
            bills.add(config.getString("billentity.id"));
        }
        return bills;
    }

    public static void clearDapConfigsCache() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("fi-ai");
        cache.remove("fi-ai-dapconfigs-dapcontrol");
    }

    static {
        optPairs.put("audit", "unaudit");
        optPairs.put("submit", "unsubmit");
        antiOptSet.add("unaudit");
        antiOptSet.add("unsubmit");
    }
}

