/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ai.mservice.service.dto;

import java.io.Serializable;

public class HoverContent
implements Serializable {
    private static final long serialVersionUID = 2268859933703141752L;
    private ContentType type;
    private String content;

    public ContentType getType() {
        return this.type;
    }

    public void setType(ContentType type) {
        this.type = type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public static HoverContent createText(String content) {
        HoverContent hoverContent = new HoverContent();
        hoverContent.content = content;
        hoverContent.type = ContentType.TEXT;
        return hoverContent;
    }

    public static HoverContent createTitle(String content) {
        HoverContent hoverContent = new HoverContent();
        hoverContent.content = content;
        hoverContent.type = ContentType.TITLE;
        return hoverContent;
    }

    public static enum ContentType {
        TITLE("title"),
        TEXT("text");

        private String type;

        private ContentType(String type) {
            this.type = type;
        }

        public static ContentType convertFromMatchType(String type) {
            if (type != null) {
                for (ContentType e : ContentType.values()) {
                    if (!type.equals(e.type)) continue;
                    return e;
                }
            }
            return null;
        }
    }
}

