/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.iep.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.ext.fi.fa.business.util.FiBillParamUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.ServiceFactory;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.bos.util.StringUtils;
import kd.fi.iep.dao.IntellAccountSchemaExecLogDao;
import kd.fi.iep.dao.IntellAccountSchemaExecLogDaoNew;
import kd.fi.iep.enums.ExecuteStatus;
import kd.fi.iep.enums.ExecuteType;
import kd.fi.iep.info.IntellExceOperInfo;
import kd.fi.iep.info.IntellSchemeExecInfo;
import kd.fi.iep.task.AbstractExecute;
import kd.fi.iep.task.IExecuteLog;
import kd.fi.iep.task.IntellExecuteContext;
import kd.fi.iep.task.MessageServiceNew;
import kd.fi.iep.task.impl.GeneralExecute;
import kd.fi.iep.task.impl.InternalTradeExecute;
import kd.fi.iep.task.impl.VchBatchExecute;
import kd.fi.iep.util.IntelAccountingConstant;
import kd.fi.iep.util.IntellExecuteUtil;

public class IntellAccountingExecPlan
implements IExecuteLog {
    private static final Log logger = LogFactory.getLog((String)"IntellAccountingExecPlan");
    private static final String SRC_SELECT_FIELDS = "id,number,name,executor,executor.name,stoptimerange_starttime,stoptimerange_endtime,failretrystrategy,operationentry.appid,operationentry.appid.number,operationentry.appid.name,operationentry.bussiness,operationentry.entity,operationentry.oper,operationentry.datafilter,operationentry.datafilter_tag,operationentry.seq,operationentry.param,operationentry.issingle,operationentry.eachbatchsize,operationentry.groupbyscoll";
    private static final String TARGET_SELECT_FIELDS = "id,orgentryentity.orgid";
    private final List<Long> schemaList;
    private final String taskId;
    private final ExecuteType type;
    private final String traceId;

    public IntellAccountingExecPlan(List<Long> schemaList, String taskId, ExecuteType type) {
        this.schemaList = schemaList;
        this.taskId = taskId;
        this.type = type;
        this.traceId = RequestContext.get().getTraceId();
    }

    public void intelSchemaHandler() {
        for (Long intelschemaId : this.schemaList) {
            IntellExecuteUtil.removeStopFlag(intelschemaId);
            Date execstartdate = new Date();
            if (this.disableScheduleByScheme(intelschemaId)) {
                return;
            }
            long sumLogId = this.execSchemeStartLog(intelschemaId);
            try {
                DLock lock = DLock.create((String)IntelAccountingConstant.getIntellSchemaExecutingKey(intelschemaId)).fastMode();
                Throwable throwable = null;
                try {
                    if (lock.tryLock()) {
                        IntellSchemeExecInfo.removeIntellExecInfo(intelschemaId);
                        IntellAccountSchemaExecLogDao.updateAllProcessingSchemaFail(intelschemaId, (Long)sumLogId);
                        logger.info("\u667a\u80fd\u6838\u7b97\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1\u5f00\u59cb\u6267\u884c: " + intelschemaId + " \u8c03\u5ea6");
                        List<IntellExceOperInfo> execOperInfoList = this.getSchemaOperList(intelschemaId);
                        if (execOperInfoList.size() == 0) continue;
                        IntellSchemeExecInfo schemeExecInfo = new IntellSchemeExecInfo(intelschemaId);
                        schemeExecInfo.setExecuteStatus(ExecuteStatus.PROCESSING);
                        schemeExecInfo.setOperTC(execOperInfoList.size());
                        schemeExecInfo.setExecStartDate(execstartdate);
                        List<Long> targetInfoList = this.getTargetOrgList(intelschemaId);
                        this.intellShemaExec(intelschemaId, schemeExecInfo, execOperInfoList, targetInfoList, sumLogId);
                        this.execSchemeEndLog(schemeExecInfo);
                        continue;
                    }
                    this.getLockFail(intelschemaId, sumLogId, execstartdate);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (lock == null) continue;
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    lock.close();
                }
            }
            catch (Exception e) {
                IntellAccountSchemaExecLogDao.updateExecSumLog(sumLogId, 0, "3", new Date(), e.getMessage());
                logger.error((Throwable)e);
            }
        }
    }

    @Override
    public long execSchemeStartLog(long intelschemaId) {
        long sumLogId = IntellAccountSchemaExecLogDao.insertExceSumLog(intelschemaId, new Date(), this.taskId, this.type);
        boolean exists = QueryServiceHelper.exists((String)"iep_todaycomplete", (Object)intelschemaId);
        if (!exists) {
            DynamicObject dynObj = BusinessDataServiceHelper.newDynamicObject((String)"iep_todaycomplete");
            dynObj.set("id", (Object)intelschemaId);
            OperationServiceHelper.executeOperate((String)"save", (String)"iep_todaycomplete", (DynamicObject[])new DynamicObject[]{dynObj}, (OperateOption)OperateOption.create());
        }
        return sumLogId;
    }

    @Override
    public void execSchemeEndLog(IntellSchemeExecInfo schemeExecInfo) {
        String execStatus;
        IntellExceOperInfo exceOperInfo = schemeExecInfo.getExceOperInfo();
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)schemeExecInfo.getSchemaId(), (String)"iep_todaycomplete");
        dynObj.set("compcount", (Object)(dynObj.getInt("compcount") + 1));
        dynObj.set("lastexectime", (Object)new Date());
        OperationServiceHelper.executeOperate((String)"save", (String)"iep_todaycomplete", (DynamicObject[])new DynamicObject[]{dynObj}, (OperateOption)OperateOption.create());
        if (ExecuteStatus.STOP == schemeExecInfo.getExecuteStatus()) {
            execStatus = "4";
        } else {
            QFilter qFilter = new QFilter("schemasumlogid", "=", (Object)exceOperInfo.getSumLogId());
            qFilter.and("execstatus", "!=", (Object)"2");
            boolean exists = QueryServiceHelper.exists((String)"gl_intellopersumlog", (QFilter[])qFilter.toArray());
            execStatus = exists ? "3" : "2";
        }
        int successBillSumQty = schemeExecInfo.getRecordTSC();
        int failBillSumQty = schemeExecInfo.getRecordTFC();
        int billSumQty = schemeExecInfo.getRecordTC();
        int failSumPkIdSize = schemeExecInfo.getRecordTFSC();
        IntellAccountSchemaExecLogDao.update2SchemaSumLog(exceOperInfo.getSumLogId(), billSumQty, execStatus, new Date(), failSumPkIdSize, successBillSumQty, failBillSumQty, exceOperInfo.getExecuteType());
        IntellAccountSchemaExecLogDao.update4SchemaSumLog(exceOperInfo.getSchemaId(), billSumQty, schemeExecInfo.getExecStartDate(), new Date(), failSumPkIdSize);
        MessageServiceNew.sendIntellShemaExecMessage(schemeExecInfo.getSchemaId(), exceOperInfo.getSumLogId(), schemeExecInfo.getOperSumLogs(), schemeExecInfo.getExecDetailLogs());
        IntellSchemeExecInfo.removeIntellExecInfo(exceOperInfo.getSchemaId());
    }

    private boolean disableScheduleByScheme(Long intelschemaId) {
        boolean exists = QueryServiceHelper.exists((String)"gl_intellexecschema", (Object)intelschemaId);
        if (!exists) {
            logger.info(" intellexecschema {} not exists", (Object)intelschemaId);
            DynamicObject schTask = BusinessDataServiceHelper.loadSingle((Object)this.taskId, (String)"sch_task");
            if (Objects.nonNull(schTask)) {
                String scheduleId = schTask.getString("schedule");
                OperationServiceHelper.executeOperate((String)"disable", (String)"sch_schedule", (Object[])new Object[]{scheduleId}, (OperateOption)OperateOption.create());
                ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                scheduleManager.disableSchedule(scheduleId);
            }
            return true;
        }
        return false;
    }

    private void getLockFail(Long intelschemaId, Long sumLogId, Date execstartdate) {
        String msgResult = ResManager.loadKDString((String)"\u65b9\u6848\u8fd8\u5728\u6267\u884c\u4e2d,\u672c\u6b21\u6267\u884c\u5931\u8d25", (String)"IntellAccountingExecPlan_6", (String)"fi-iep-formplugin", (Object[])new Object[0]);
        IntellAccountSchemaExecLogDao.updateExecSumLog(sumLogId, 0, ExecuteStatus.FAIL.getStatus(), new Date(), msgResult);
        IntellExceOperInfo info = new IntellExceOperInfo();
        info.setSchemaId(intelschemaId);
        info.setBussiness("gl_intellexecschema");
        info.setAppId("3815fd11000209ac");
        String msgExecuteschema = ResManager.loadKDString((String)"\u6267\u884c\u65b9\u6848", (String)"IntellAccountingExecPlan_4", (String)"fi-iep-formplugin", (Object[])new Object[0]);
        info.setOper(msgExecuteschema);
        info.setCreatorId(RequestContext.get().getCurrUserId());
        String msgLock = ResManager.loadKDString((String)"\u83b7\u53d6\u9501\u5931\u8d25", (String)"IntellAccountingExecPlan_5", (String)"fi-iep-formplugin", (Object[])new Object[0]);
        long operSumLog = IntellAccountSchemaExecLogDao.insertOperSumLog(intelschemaId, sumLogId, execstartdate, info, 0, msgLock);
        IntellAccountSchemaExecLogDaoNew.insertExceLog(info, execstartdate, null, ExecuteStatus.FAIL.getStatus(), operSumLog, 0, msgResult, null, this.traceId);
        logger.info(IntelAccountingConstant.getIntellSchemaExecutingKey(intelschemaId) + " has been locked.");
    }

    private List<IntellExceOperInfo> getSchemaOperList(Long intelschemaId) {
        ArrayList<IntellExceOperInfo> srcInfoList = new ArrayList<IntellExceOperInfo>();
        QFilter statusFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter idFilter = new QFilter("id", "=", (Object)intelschemaId);
        HashMap<Integer, IntellExceOperInfo> operMap = new HashMap<Integer, IntellExceOperInfo>();
        try (DataSet srcOrgDataSet = QueryServiceHelper.queryDataSet((String)"gl.intelaccounting.srcOrgList", (String)"gl_intellexecschema", (String)SRC_SELECT_FIELDS, (QFilter[])new QFilter[]{statusFilter, idFilter}, (String)"operationentry.seq");){
            Iterator srcRows = srcOrgDataSet.iterator();
            while (srcRows.hasNext()) {
                IntellExceOperInfo info = new IntellExceOperInfo();
                Row r = (Row)srcRows.next();
                String entity = r.getString("operationentry.entity");
                if (StringUtils.isEmpty((String)entity) || StringUtils.isEmpty((String)entity.trim())) {
                    entity = r.getString("operationentry.bussiness");
                }
                info.setFailRetryStrategy(r.getString("failretrystrategy"));
                info.setBussiness(entity);
                info.setOper(r.getString("operationentry.oper"));
                if (StringUtils.isEmpty((String)r.getString("operationentry.datafilter_tag"))) {
                    info.setDatafilter(this.getFilter(entity, r.getString("operationentry.datafilter")));
                } else {
                    info.setDatafilter(this.getFilter(entity, r.getString("operationentry.datafilter_tag")));
                }
                info.setAppId(r.getString("operationentry.appid"));
                info.setAppNumber(r.getString("operationentry.appid.number"));
                info.setAppName(r.getString("operationentry.appid.name"));
                info.setSchemaId(r.getLong("id"));
                info.setSchemaNumber(r.getString("number"));
                info.setSchemaName(r.getString("name"));
                info.setExecuteType(this.type);
                info.setStopStartTime(r.getInteger("stoptimerange_starttime"));
                info.setStopEndTime(r.getInteger("stoptimerange_endtime"));
                info.setCreatorId(r.getLong("executor"));
                info.setCreatorName(r.getString("executor.name"));
                info.setParams(r.getString("operationentry.param"));
                info.setSeq(r.getInteger("operationentry.seq"));
                info.setIssingle(r.getBoolean("operationentry.issingle"));
                if (this.isGenerateVoucherOperation(info)) {
                    info.setEachbatchsize(r.getInteger("operationentry.eachbatchsize"));
                } else {
                    int eachbatchsize = r.getInteger("operationentry.eachbatchsize");
                    if (eachbatchsize == 0 || eachbatchsize == 10000) {
                        eachbatchsize = 50;
                    }
                    Integer eachBatchValue = FiBillParamUtil.getIntegerValue("83bfebc8000002ac", "3815fd11000209ac", "prop.fi.iep.intellschema.thread.batchsize", null);
                    int eachBatch = Math.max(Optional.ofNullable(eachBatchValue).orElse(50), eachbatchsize);
                    info.setEachbatchsize(eachBatch);
                }
                info.setGroupbyscoll(r.getString("operationentry.groupbyscoll"));
                operMap.put(info.getHash(), info);
            }
        }
        this.preSetFilter(operMap);
        srcInfoList.addAll(operMap.values());
        Collections.sort(srcInfoList);
        return srcInfoList;
    }

    private void preSetFilter(Map<Integer, IntellExceOperInfo> operMap) {
        Integer hash = null;
        HashMap<Integer, QFilter> defaultMap = new HashMap<Integer, QFilter>();
        try (DataSet filterDataSet = QueryServiceHelper.queryDataSet((String)"gl.intelaccounting.preFilter", (String)"gl_intelloper_filter", (String)"bussiness,hash,datafilter_tag", (QFilter[])new QFilter[]{new QFilter("hash", "in", operMap.keySet())}, null);){
            for (Row r : filterDataSet) {
                hash = r.getInteger("hash");
                defaultMap.put(hash, this.getFilter(r.getString("bussiness"), r.getString("datafilter_tag")));
            }
        }
        QFilter preFilter = null;
        QFilter oldFilter = null;
        IntellExceOperInfo operInfo = null;
        for (Map.Entry<Integer, IntellExceOperInfo> info : operMap.entrySet()) {
            operInfo = info.getValue();
            oldFilter = operInfo.getDatafilter();
            preFilter = (QFilter)defaultMap.get(operInfo.getHash());
            if (Objects.nonNull(oldFilter)) {
                if (Objects.nonNull(preFilter)) {
                    QFilter[] preFilters;
                    for (QFilter pref : preFilters = preFilter.recombine()) {
                        String preField = pref.getProperty();
                        QFilter[] oldFilters = oldFilter.recombine();
                        boolean hasFilter = true;
                        for (QFilter oldf : oldFilters) {
                            String field = oldf.getProperty();
                            if (!Objects.nonNull(preField) || !preField.equals(field)) continue;
                            hasFilter = false;
                            break;
                        }
                        if (!hasFilter) continue;
                        oldFilter.and(pref);
                    }
                }
                preFilter = oldFilter;
            }
            info.getValue().setDatafilter(preFilter);
        }
    }

    private List<Long> getTargetOrgList(Long intelschemaId) {
        QFilter statusFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter idFilter = new QFilter("id", "=", (Object)intelschemaId);
        ArrayList<Long> targetOrgList = new ArrayList<Long>();
        try (DataSet targetOrgDataSet = QueryServiceHelper.queryDataSet((String)"gl.intelaccounting.targetOrgList", (String)"gl_intellexecschema", (String)TARGET_SELECT_FIELDS, (QFilter[])new QFilter[]{statusFilter, idFilter}, null);){
            for (Row r : targetOrgDataSet) {
                if (r.getLong("orgentryentity.orgid") <= 0L) continue;
                targetOrgList.add(r.getLong("orgentryentity.orgid"));
            }
        }
        return targetOrgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void intellShemaExec(Long intelschemaId, IntellSchemeExecInfo schemeExecInfo, List<IntellExceOperInfo> execOperInfoList, List<Long> targetInfoList, long sumLogId) {
        Date execstartdate = new Date();
        try {
            logger.info("\u5f00\u59cb\u6267\u884c\u4e1a\u52a1\u64cd\u4f5c...");
            for (IntellExceOperInfo exceOperInfo : execOperInfoList) {
                AbstractExecute exceutor;
                exceOperInfo.setSumLogId(sumLogId);
                exceOperInfo.setExecuteStatus(ExecuteStatus.PROCESSING);
                schemeExecInfo.setExceOperInfo(exceOperInfo);
                if (ExecuteStatus.STOP == schemeExecInfo.getExecuteStatus() || IntellExecuteUtil.isStopExcute(schemeExecInfo)) {
                    execOperInfoList.forEach(v -> v.setStopRuning(true));
                    break;
                }
                IntellExecuteContext ctx = new IntellExecuteContext(this.taskId, this.type, schemeExecInfo, targetInfoList, sumLogId, this.traceId, execstartdate);
                if (Arrays.asList("ict_relacctrecord", "ict_relcfrecord").contains(exceOperInfo.getBussiness()) && Arrays.asList("pullacct", "pullcf").contains(exceOperInfo.getOper())) {
                    exceutor = new InternalTradeExecute(ctx);
                    exceutor.execute();
                    break;
                }
                exceutor = !this.isGenerateVoucherOperation(exceOperInfo) ? new GeneralExecute(ctx) : new VchBatchExecute(ctx);
                exceutor.execute();
                schemeExecInfo.addAllExecDetailLogs(exceOperInfo.getExecDetailLogs());
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            schemeExecInfo.setExecuteStatus(ExecuteStatus.FAIL);
        }
        finally {
            IntellExecuteUtil.removeStopFlag(intelschemaId);
        }
    }

    private QFilter getFilter(String entity, String filter) {
        if (StringUtils.isEmpty((String)filter)) {
            return null;
        }
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entity);
        Map filterConditionMap = (Map)SerializationUtils.fromJsonString((String)filter, Map.class);
        ArrayList<IDataEntityType> dts = new ArrayList<IDataEntityType>();
        dts.add(OrmUtils.getDataEntityType(FilterCondition.class));
        dts.add(OrmUtils.getDataEntityType(SimpleFilterRow.class));
        DcJsonSerializer ser = new DcJsonSerializer(dts);
        FilterCondition filterCondition = (FilterCondition)ser.deserializeFromMap(filterConditionMap, null);
        FilterBuilder filterBuilder = new FilterBuilder(type, filterCondition);
        filterBuilder.setUserService((IUserService)new UserService());
        filterBuilder.setTimeService((ITimeService)new TimeService());
        filterBuilder.buildFilter(false);
        return filterBuilder.getFilterObject().getQFilter();
    }

    private boolean isGenerateVoucherOperation(IntellExceOperInfo operInfo) {
        String bussiness = operInfo.getBussiness();
        String operationName = operInfo.getOper();
        List ops = EntityMetadataCache.getDataEntityOperate((String)bussiness);
        for (Map each : ops) {
            String operationkey = String.valueOf(each.get("key"));
            String type = String.valueOf(each.get("type"));
            if (!Objects.nonNull(operationkey) || !operationkey.equals(operationName)) continue;
            return "buildvoucher".equals(type) || "generatevoucher".equals(type);
        }
        return false;
    }
}

