/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.imsc.imic.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CommonUtils {
    private CommonUtils() {
    }

    public static String getSqlInStr(int size) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(" (");
        for (int i = 0; i < size; ++i) {
            if (i == size - 1) {
                strBuilder.append("?)");
                continue;
            }
            strBuilder.append("?,");
        }
        return strBuilder.toString();
    }

    public static boolean getBooleanCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtils.getCustomParamValue(formView, key);
        if (obj instanceof Boolean) {
            return Boolean.parseBoolean(obj.toString());
        }
        return false;
    }

    public static long getLongCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtils.getCustomParamValue(formView, key);
        if (CommonUtils.isNull(obj)) {
            return 0L;
        }
        return Long.parseLong(obj.toString());
    }

    public static List<Long> getListCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtils.getCustomParamValue(formView, key);
        if (!CommonUtils.isNull(obj)) {
            return (List)SerializationUtils.fromJsonString((String)obj.toString(), List.class);
        }
        return new ArrayList<Long>(0);
    }

    public static String getStringCustomParamValue(IFormView formView, String key) {
        Object obj = CommonUtils.getCustomParamValue(formView, key);
        if (CommonUtils.isNull(obj)) {
            return "";
        }
        return obj.toString();
    }

    public static Object getCustomParamValue(IFormView formView, String key) {
        Map customParams = formView.getFormShowParameter().getCustomParams();
        if (CommonUtils.isNull(customParams) || !customParams.containsKey(key)) {
            return null;
        }
        return customParams.get(key);
    }

    public static OperateOption getMutexOperateOption(boolean strictValidation) {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(strictValidation));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(false));
        saveOption.setVariableValue("ishasright", String.valueOf(true));
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }

    public static OperateOption getOperateOption(boolean strictValidation) {
        OperateOption saveOption = OperateOption.create();
        saveOption.setVariableValue("ignorewarn", String.valueOf(true));
        saveOption.setVariableValue("ignoreinteraction", String.valueOf(true));
        saveOption.setVariableValue("strictvalidation", String.valueOf(strictValidation));
        saveOption.setVariableValue("ignoreValidation", String.valueOf(true));
        saveOption.setVariableValue("ishasright", String.valueOf(true));
        saveOption.setVariableValue("WF", "false");
        return saveOption;
    }

    public static String getErrDetail(OperationResult optResult) {
        StringBuilder errDetail = new StringBuilder();
        if (!CommonUtils.isNull(optResult.getMessage())) {
            errDetail.append(optResult.getMessage());
        }
        for (IOperateInfo errInfo : optResult.getAllErrorOrValidateInfo()) {
            if (CommonUtils.isNull(errInfo.getMessage())) continue;
            errDetail.append(errInfo.getMessage());
        }
        return errDetail.toString();
    }

    public static List<DynamicObject> getOperateSuccessDynObjList(OperationResult operationResult, OperationResult optResult, List<DynamicObject> billDynObjList) {
        if (CommonUtils.isNull(billDynObjList) || optResult == null) {
            return billDynObjList;
        }
        operationResult.mergeOperateResult(optResult);
        List faileBillIdList = optResult.getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).collect(Collectors.toList());
        return billDynObjList.stream().filter(obj -> !faileBillIdList.contains(obj.getPkValue())).collect(Collectors.toList());
    }

    public static boolean isNull(Object o) {
        return o == null || o instanceof String && ((String)o).length() == 0 || o instanceof StringBuffer && ((StringBuffer)o).length() == 0 || o instanceof List && ((List)o).isEmpty() || o instanceof Collection && ((Collection)o).isEmpty() || o instanceof Object[] && ((Object[])o).length == 0 || o instanceof int[] && ((int[])o).length == 0 || o instanceof Map && ((Map)o).size() == 0 || o instanceof DynamicObjectCollection && ((DynamicObjectCollection)o).isEmpty() || o instanceof DynamicObject[] && ((DynamicObject[])o).length == 0;
    }

    public static List<String> buildOperationResultMessage(OperationResult result, DynamicObject[] dataEntitys) {
        ArrayList<String> opMessages;
        block5: {
            opMessages = new ArrayList<String>(0);
            if (result == null || dataEntitys == null || dataEntitys.length <= 0) break block5;
            int batchSize = dataEntitys.length;
            opMessages = new ArrayList(batchSize);
            List successPkIds = result.getSuccessPkIds();
            if (!result.isSuccess() || successPkIds.size() < batchSize) {
                for (DynamicObject dataEntity : dataEntitys) {
                    if (successPkIds.contains(dataEntity.getPkValue())) {
                        opMessages.add("");
                        continue;
                    }
                    opMessages.add(CommonUtils.buildOperationResultMessage(result, dataEntity));
                }
            } else {
                for (int i = 0; i < batchSize; ++i) {
                    opMessages.add("");
                }
            }
        }
        return opMessages;
    }

    public static String buildOperationResultMessage(OperationResult result, DynamicObject entity) {
        return CommonUtils.buildOperationResultMessage(result, entity.getPkValue());
    }

    public static String buildOperationResultMessage(OperationResult result, Object pkValue) {
        ArrayList<String> errorMessages = null;
        if (result != null && pkValue != null) {
            errorMessages = new ArrayList<String>(5);
            int seq = 1;
            for (IOperateInfo operateInfo : result.getAllErrorOrValidateInfo()) {
                if (operateInfo.getPkValue() != null && !operateInfo.getPkValue().equals(pkValue)) continue;
                errorMessages.add(seq++ + ". " + operateInfo.getMessage());
            }
            if (CollectionUtils.isEmpty(errorMessages)) {
                errorMessages.add(result.getMessage());
            }
        }
        return errorMessages == null ? null : String.join((CharSequence)";", errorMessages);
    }

    public static Map<String, Object> getUserInfoById(long userID) {
        List<Map<String, Object>> userList = CommonUtils.getUserInfoById(Collections.singletonList(userID));
        if (userList.isEmpty()) {
            return new HashMap<String, Object>(0);
        }
        return userList.get(0);
    }

    public static List<Map<String, Object>> getUserInfoById(List<Long> userId) {
        QFilter filterUser = new QFilter("id", "in", userId);
        String selectFields = "id,fuid,number,name,phone,email";
        QFilter[] filterUsers = new QFilter[]{filterUser};
        Map userMap = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)selectFields, (QFilter[])filterUsers);
        if (CollectionUtils.isEmpty((Map)userMap)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        ArrayList<Map<String, Object>> userInfoLst = new ArrayList<Map<String, Object>>(userMap.size());
        HashMap<String, Object> userInfo = null;
        for (DynamicObject obj : userMap.values()) {
            userInfo = new HashMap<String, Object>(16);
            userInfo.put("id", obj.getPkValue());
            userInfo.put("userId", userId);
            userInfo.put("uid", obj.getString("fuid"));
            userInfo.put("number", obj.getString("number"));
            userInfo.put("name", obj.getString("name"));
            userInfo.put("phone", obj.getString("phone"));
            userInfo.put("email", obj.getString("email"));
            userInfo.put("type", "1");
            userInfoLst.add(userInfo);
        }
        return userInfoLst;
    }
}

