/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.datagrade.control;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.script.annotations.KSObject;
import org.apache.commons.lang3.StringUtils;

@KSObject
@DataEntityTypeAttribute(name="kd.bos.ext.hr.datagrade.control.DataGradeCalculation")
public class DataGradeCalculation
extends Control
implements ICloseCallBack {
    private static final String DATA_GRADE_VO_PATH = "kd.hr.hbp.business.service.formula.cal.vo.DataGradeVO";
    private static final String CLOSE_BASE_CALL_BACK_KEY = "closeBaseCallBack";

    public void bindData(BindingContext bctx) {
        super.bindData(bctx);
        this.updateControlData(this.getValue());
    }

    public void updateControlData(String data) {
        this.clientViewProxy.setEntryProperty(this.getKey(), "data", (Object)data);
    }

    public String getValue() {
        String valueCache;
        if (this.getView() != null && StringUtils.isNotEmpty((CharSequence)(valueCache = this.getView().getPageCache().get("datagradedecisiontableap#$_allvalue")))) {
            return valueCache;
        }
        return null;
    }

    public void simulateCalculate(Map<String, Object> allParams) {
        if (Objects.nonNull(allParams) && !allParams.isEmpty()) {
            Object paramsObj = allParams.get("params");
            Object dataGradeTableStr = allParams.get("dataGradeTableStr");
            if (Objects.nonNull(paramsObj) && paramsObj instanceof Map && Objects.nonNull(dataGradeTableStr)) {
                Map params = (Map)allParams.get("params");
                try {
                    Class<?> clazz = Class.forName(DATA_GRADE_VO_PATH);
                    Method method = clazz.getMethod("getDataGradeVO", String.class, String.class);
                    Object voObj = method.invoke(null, "", String.valueOf(dataGradeTableStr));
                    Method getDataGradeResultMap = clazz.getMethod("getDataGradeResultMap", Map.class);
                    Object dataGradeResult = getDataGradeResultMap.invoke(voObj, params);
                    if (this.checkResultIsEmpty(dataGradeResult)) {
                        return;
                    }
                    this.clientViewProxy.invokeControlMethod("simulatecalcontrol", "setCalResult", new Object[]{this.dealResult(dataGradeResult)});
                }
                catch (InvocationTargetException exception) {
                    Throwable targetException = exception.getTargetException();
                    if (Objects.isNull(targetException) || !(targetException instanceof KDBizException)) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u62df\u8fd0\u7b97\u5931\u8d25\u3002", (String)"DataGradeCalculation_0", (String)"bos-ext-hr", (Object[])new Object[0]));
                    }
                    throw (KDBizException)targetException;
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException exception) {
                    exception.printStackTrace();
                    throw new KDBizException(ResManager.loadKDString((String)"\u6a21\u62df\u8fd0\u7b97\u5931\u8d25\u3002", (String)"DataGradeCalculation_0", (String)"bos-ext-hr", (Object[])new Object[0]));
                }
            }
        }
    }

    private boolean checkResultIsEmpty(Object dataGradeResult) {
        if (Objects.isNull(dataGradeResult)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6a21\u62df\u8fd0\u7b97\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e3a\u7a7a\u3002", (String)"DataGradeCalculation_1", (String)"bos-ext-hr", (Object[])new Object[0]));
            return true;
        }
        if (dataGradeResult instanceof Map) {
            Map result = (Map)dataGradeResult;
            boolean isEmpty = true;
            for (Map.Entry entry : result.entrySet()) {
                if (!Objects.nonNull(entry.getValue())) continue;
                isEmpty = false;
                break;
            }
            if (isEmpty) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6839\u636e\u8f93\u5165\u6761\u4ef6\u672a\u5339\u914d\u5230\u76f8\u5e94\u7ed3\u679c\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u6761\u4ef6\u662f\u5426\u51c6\u786e\u3002", (String)"DataGradeCalculation_2", (String)"bos-ext-hr", (Object[])new Object[0]));
            }
        }
        return false;
    }

    private Object dealResult(Object dataGradeResultObj) {
        if (dataGradeResultObj instanceof Map) {
            Map dataGradeResult = (Map)dataGradeResultObj;
            for (Map.Entry entry : dataGradeResult.entrySet()) {
                if (!(entry.getValue() instanceof DynamicObject)) continue;
                entry.setValue(((DynamicObject)entry.getValue()).getString("name"));
            }
            return dataGradeResult;
        }
        return dataGradeResultObj;
    }

    public void closeWindow() {
        this.getView().close();
    }

    public void clickBase(Map<String, Object> argsJson) {
        String baseDataField = String.valueOf(argsJson.get("basedatafield"));
        String conditionId = String.valueOf(argsJson.get("conditionID"));
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)baseDataField, (boolean)false, (int)0, (boolean)true);
        listShowParameter.setMultiSelect(Boolean.FALSE.booleanValue());
        listShowParameter.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), DataGradeCalculation.getActionId(this.getKey(), CLOSE_BASE_CALL_BACK_KEY, conditionId)));
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setShowTitle(false);
        listShowParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public static String getActionId(String ... keys) {
        StringBuilder sb = new StringBuilder();
        for (String key : keys) {
            sb.append(key).append('.');
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String[] params = closedCallBackEvent.getActionId().split("\\.");
        if (params.length > 2 && CLOSE_BASE_CALL_BACK_KEY.equals(params[1])) {
            String conditionId = params[2];
            Object returnData = closedCallBackEvent.getReturnData();
            IClientViewProxy clientViewProxy = (IClientViewProxy)closedCallBackEvent.getView().getService(IClientViewProxy.class);
            this.updateBaseParam(clientViewProxy, params[0], returnData, conditionId);
        }
    }

    public void updateBaseParam(IClientViewProxy clientViewProxy, String controlKey, Object returnData, String conditionId) {
        ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)returnData;
        if (Objects.isNull(listSelectedRowCollection)) {
            return;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)3);
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            map.put("id", String.valueOf(listSelectedRow.getPrimaryKeyValue()));
            map.put("name", listSelectedRow.getName());
        }
        map.put("conditionID", conditionId);
        clientViewProxy.invokeControlMethod(controlKey, "updateBaseParam", new Object[]{map});
    }
}

