/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.es.api.storage.highlevel;

import java.io.IOException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.exception.KDException;
import kd.bos.ext.hr.es.api.EsBatchValue;
import kd.bos.ext.hr.es.api.EsDataType;
import kd.bos.ext.hr.es.api.EsMappingProperty;
import kd.bos.ext.hr.es.api.EsPropertyValue;
import kd.bos.ext.hr.es.api.common.BosEsErrorCode;
import kd.bos.ext.hr.es.api.common.util.EsCommonUtils;
import kd.bos.ext.hr.es.api.storage.BaseEsStorage;
import kd.bos.ext.hr.es.api.storage.EsFilterField;
import kd.bos.ext.hr.es.api.storage.EsResultVo;
import kd.bos.ext.hr.es.api.storage.EsStorage;
import kd.bos.ext.hr.es.api.storage.SortField;
import kd.bos.ext.hr.es.api.storage.highlevel.EsAccess;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.collections.MapUtils;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class EsStorageImpl
extends BaseEsStorage
implements EsStorage {
    private static final Log logger = LogFactory.getLog(EsStorageImpl.class);
    private RestHighLevelClient client = null;
    private static String strDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    static Map<String, RestHighLevelClient> clientCacheMap = new ConcurrentHashMap<String, RestHighLevelClient>(8);

    public EsStorageImpl(String region) {
        this.client = this.getClient(region);
    }

    private RestHighLevelClient getClient(String region) {
        Map<String, String> configMap = EsCommonUtils.getServerConfig(region);
        String port = configMap.get("port");
        String ip = configMap.get("ip");
        return clientCacheMap.computeIfAbsent(ip + port, i -> EsAccess.createRestHighLevelClient(configMap));
    }

    @Override
    public void createIndex(String region, String indexName, Map<String, Object> settingsMap) {
        if (MapUtils.isEmpty(settingsMap)) {
            settingsMap = EsCommonUtils.getIndexSettings(region);
        }
        if (!EsAccess.isIndexExist(this.client, indexName)) {
            EsAccess.createIndex(this.client, indexName, settingsMap);
        }
    }

    @Override
    public void updateIndexSetting(String region, String indexName, Map<String, Object> settingsMap) {
        if (MapUtils.isEmpty(settingsMap)) {
            settingsMap = EsCommonUtils.getIndexSettings(region);
        }
        if (EsAccess.isIndexExist(this.client, indexName)) {
            EsAccess.updateIndexSettings(this.client, new String[]{indexName}, settingsMap);
        }
    }

    @Override
    public void addMappingIndex(String indexName, String typeName, EsMappingProperty ... esMappingIndexs) {
        try {
            XContentBuilder jsonBuilder = XContentFactory.jsonBuilder().startObject();
            this.getFieldsMapping(jsonBuilder, typeName, esMappingIndexs);
            jsonBuilder.endObject();
            EsAccess.createIndexMapping(this.client, indexName, typeName, jsonBuilder);
        }
        catch (IOException e) {
            logger.info("ES create index failure! index name:{}", (Object)indexName);
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[]{"ES create index failure:" + e.getMessage()});
        }
    }

    @Override
    public void delMappingIndex(String indexName, String typeName, EsMappingProperty ... esMappingIndexs) {
        HashMap<String, Object> upMap = new HashMap<String, Object>(8);
        for (EsMappingProperty index : esMappingIndexs) {
            upMap.put(index.getPropertyName(), null);
        }
        EsAccess.updateByQuery(this.client, indexName, typeName, null, upMap);
    }

    @Override
    public void refreshDataBase(String indexName) {
        EsAccess.refreshIndex(this.client, indexName);
    }

    @Override
    public void saveStorage(String indexName, Object id, EsPropertyValue[] values) {
        try {
            this.batchSave(indexName, "t_data", new EsBatchValue(id, values));
        }
        catch (Exception e) {
            logger.info("ES save data failure! index name:{}", (Object)indexName);
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[]{"ES save data failure:" + e.getMessage()});
        }
    }

    @Override
    public void batchSave(String indexName, String typeName, EsBatchValue ... values) {
        ArrayList<BulkItemResponse> failureRespList = new ArrayList<BulkItemResponse>(10);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(10);
        int batchFlag = 0;
        int saveSize = 0;
        for (EsBatchValue bv : values) {
            if (++batchFlag > 5000) {
                failureRespList.addAll(EsAccess.batchSave(this.client, indexName, typeName, mapList));
                batchFlag = 1;
                mapList.clear();
            }
            Map<String, Object> map = this.buidPropertyValue(bv.getValues());
            map.put("_id", bv.getId());
            ++saveSize;
            mapList.add(map);
        }
        failureRespList.addAll(EsAccess.batchSave(this.client, indexName, typeName, mapList));
        if (!failureRespList.isEmpty()) {
            logger.info("ES batch save data failure! index name:{}", (Object)indexName);
            throw new KDException(BosEsErrorCode.esException, new Object[]{this.buildBulkFailureMessage(saveSize, failureRespList)});
        }
    }

    private Map<String, Object> buidPropertyValue(Object[] upFields) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Object object : upFields) {
            EsPropertyValue pv = (EsPropertyValue)object;
            String name = pv.getPropertyName();
            Cloneable value = pv.getValue();
            if (value instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)value;
                SimpleDateFormat df = new SimpleDateFormat(strDateFormat);
                String strDate = df.format(timestamp);
                map.put(name, strDate);
                continue;
            }
            if (EsDataType.NESTED == pv.getDataType()) {
                List<Object> objectList = pv.nests;
                ArrayList<Map<String, Object>> nestList = new ArrayList<Map<String, Object>>();
                HashMap<String, Object> nestMap = new HashMap<String, Object>();
                for (Object nestObject : objectList) {
                    if (nestObject instanceof List) {
                        List nestObjectList = (List)nestObject;
                        nestList.add(this.buidPropertyValue(nestObjectList.toArray()));
                        continue;
                    }
                    if (!(nestObject instanceof EsPropertyValue)) continue;
                    EsPropertyValue nestPropertyValue = (EsPropertyValue)nestObject;
                    nestMap.put(nestPropertyValue.getPropertyName(), nestPropertyValue.getValue());
                }
                if (nestList.size() > 0) {
                    value = nestList;
                } else if (nestMap.size() > 0) {
                    value = nestMap;
                }
            }
            map.put(name, value);
        }
        return map;
    }

    @Override
    public EsResultVo query(String indexName, String typeName, String[] selectFileds, List<EsFilterField> filters, SortField[] sortFields, boolean score, int start, int size) {
        QueryBuilder queryBuilder = this.buidQueryBuilder(filters);
        return EsAccess.query(this.client, indexName, typeName, selectFileds, queryBuilder, sortFields, score, start, size, null);
    }

    @Override
    public EsResultVo searchAfter(String indexName, String typeName, String[] selectFileds, List<EsFilterField> filters, SortField[] sortFields, boolean score, int start, int size, Object[] objSortValues) {
        QueryBuilder queryBuilder = this.buidQueryBuilder(filters);
        return EsAccess.query(this.client, indexName, typeName, selectFileds, queryBuilder, sortFields, score, 0, size, objSortValues);
    }

    @Override
    public int getCount(String indexName, String typeName, List<EsFilterField> filters) {
        long count = EsAccess.getCount(this.client, indexName, typeName, this.buidQueryBuilder(filters));
        return (int)count;
    }

    @Override
    public boolean exist(String indexName, String typeName, List<EsFilterField> filters) {
        long count = EsAccess.getCount(this.client, indexName, typeName, this.buidQueryBuilder(filters));
        return count > 0L;
    }

    @Override
    public void delete(String indexName, String typeName, String _id) {
        EsAccess.deleteByQuery(this.client, indexName, typeName, (QueryBuilder)QueryBuilders.termQuery((String)"_id", (String)_id));
    }

    @Override
    public void deleteByQuery(String indexName, String typeName, List<EsFilterField> filters) {
        EsAccess.deleteByQuery(this.client, indexName, typeName, this.buidQueryBuilder(filters));
    }

    @Override
    public void updateByQuery(String indexName, String typeName, List<EsFilterField> filters, EsPropertyValue[] upFields) {
        HashMap<String, Object> upMap = new HashMap<String, Object>(8);
        for (EsPropertyValue fv : upFields) {
            upMap.put(fv.getPropertyName(), fv.getValue());
        }
        EsAccess.updateByQuery(this.client, indexName, typeName, this.buidQueryBuilder(filters), upMap);
    }

    @Override
    public boolean deleteIndex(String indexName) {
        return EsAccess.deleteIndex(this.client, indexName);
    }

    @Override
    public boolean addAliases(String indexName, String aliasName, String routing) {
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions aliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(indexName).alias(aliasName).routing(routing);
        request.addAliasAction(aliasAction);
        try {
            AcknowledgedResponse indicesAliasesResponse = this.client.indices().updateAliases(request, RequestOptions.DEFAULT);
            boolean acknowledged = indicesAliasesResponse.isAcknowledged();
            return acknowledged;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
    }

    @Override
    public boolean removeAndAddAliases(String indexName, String aliasName) {
        Map<String, Set<AliasMetaData>> map = this.getAliasIndex(aliasName);
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        if (map != null) {
            for (Map.Entry<String, Set<AliasMetaData>> entry : map.entrySet()) {
                String oldIndex = entry.getKey();
                IndicesAliasesRequest.AliasActions removeAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(oldIndex).alias(aliasName);
                request.addAliasAction(removeAliasAction);
            }
        }
        IndicesAliasesRequest.AliasActions addAliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(indexName).alias(aliasName).writeIndex(Boolean.valueOf(true));
        request.addAliasAction(addAliasAction);
        try {
            AcknowledgedResponse indicesAliasesResponse = this.client.indices().updateAliases(request, RequestOptions.DEFAULT);
            boolean acknowledged = indicesAliasesResponse.isAcknowledged();
            return acknowledged;
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
    }

    @Override
    public Boolean isAliasExists(String aliasName) {
        Boolean result;
        GetAliasesRequest request = new GetAliasesRequest(new String[]{aliasName});
        try {
            result = this.client.indices().existsAlias(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
        return result;
    }

    @Override
    public Map<String, Set<AliasMetaData>> getAliasIndex(String aliasName) {
        GetAliasesRequest request = new GetAliasesRequest(new String[]{aliasName});
        Map map = null;
        try {
            GetAliasesResponse getAliasesResponse = this.client.indices().getAlias(request, RequestOptions.DEFAULT);
            map = getAliasesResponse.getAliases();
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, BosEsErrorCode.esException, new Object[0]);
        }
        return map;
    }
}

