/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.form.operate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.MutexValidateResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.operate.View;
import kd.bos.list.IListView;

public class Edit
extends View
implements IConfirmCallBack {
    private static final String ACT_ID_LOCKED_CONFIRM = "lockedConfirm";
    private static final String ACT_ID_REENTRANT_CONFIRM = "reentrantConfirm";
    private static final String CALL_BACK_VALUE_OPERATION_KEY = "operateKey";
    private static final String CALL_BACK_VALUE_ENTITY_ID = "entityId";
    private static final String CALL_BACK_VALUE_PK_VALUE = "pkvalue";

    public Edit() {
        this.billStatus = BillOperationStatus.EDIT;
    }

    public OperationStatus getOperationStatus() {
        return OperationStatus.EDIT;
    }

    protected void doFailCheckRight(OperationResult result) {
        if (StringUtils.isNotBlank((CharSequence)this.lockInfoStr) && !"MessageCallBackType".equals(this.getParameter().get("sourceName"))) {
            List errList = result.getValidateResult().getValidateErrors();
            StringBuilder sb = new StringBuilder();
            for (ValidateResult errResult : errList) {
                for (IOperateInfo errInfo : errResult.getAllErrorInfo()) {
                    sb.append(errInfo.getMessage());
                }
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ACT_ID_LOCKED_CONFIRM, (IConfirmCallBack)this);
            if (errList.size() == 1 && "dataMutex".equals(((ValidateResult)errList.get(0)).getValidatorKey()) && errList.get(0) instanceof MutexValidateResult && ((MutexValidateResult)errList.get(0)).isEnableReentrant()) {
                confirmCallBacks.setCallBackId(ACT_ID_REENTRANT_CONFIRM);
                HashMap<String, String> callbackValue = new HashMap<String, String>();
                callbackValue.put(CALL_BACK_VALUE_OPERATION_KEY, this.getOperateKey());
                callbackValue.put(CALL_BACK_VALUE_ENTITY_ID, this.getEntityId());
                callbackValue.put(CALL_BACK_VALUE_PK_VALUE, String.valueOf(this.getPKValue()));
                this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u9875\u9762\u88ab\u8be5\u8d26\u53f7\u5728\u5176\u5b83\u4f1a\u8bdd\u4e2d\u9501\u5b9a \r\n\u662f\u5426\u5c06\u5176\u767b\u51fa\uff1f", (String)"Edit_0", (String)"bos-ext-hr", (Object[])new Object[0]), null, MessageBoxOptions.OKCancel, null, confirmCallBacks, null, SerializationUtils.toJsonString(callbackValue));
                return;
            }
            this.getView().showConfirm(sb.toString(), MessageBoxOptions.OKCancel, confirmCallBacks);
        } else {
            List errList = result.getValidateResult().getValidateErrors();
            StringBuilder sb = new StringBuilder();
            for (ValidateResult errResult : errList) {
                for (IOperateInfo errInfo : errResult.getAllErrorInfo()) {
                    sb.append(errInfo.getMessage());
                }
            }
            this.getView().showErrorNotification(sb.toString());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageboxclosedevent) {
        String callBackId = messageboxclosedevent.getCallBackId();
        if (messageboxclosedevent.getResult() == MessageBoxResult.Yes && ACT_ID_LOCKED_CONFIRM.equalsIgnoreCase(callBackId) && this.getView() instanceof IListView) {
            this.getView().invokeOperation("view");
        } else if (messageboxclosedevent.getResult() == MessageBoxResult.Yes && ACT_ID_REENTRANT_CONFIRM.equals(callBackId) && this.getView() instanceof IListView) {
            String callbackValue = messageboxclosedevent.getCustomVaule();
            if (StringUtils.isEmpty((CharSequence)callbackValue)) {
                this.getView().invokeOperation("view");
                return;
            }
            Map map = (Map)SerializationUtils.fromJsonString((String)callbackValue, Map.class);
            String operationKey = map.get(CALL_BACK_VALUE_OPERATION_KEY).toString();
            String entityId = map.get(CALL_BACK_VALUE_ENTITY_ID).toString();
            Object pkValue = map.get(CALL_BACK_VALUE_PK_VALUE);
            MutexHelper.clearErrLockByWebSocket((String)entityId, pkValue, (String)operationKey);
            this.getView().invokeOperation(operationKey);
        }
    }
}

