/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.metadata.field;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ext.hr.metadata.edit.QueryEdit;
import kd.bos.ext.hr.metadata.field.IQueryField;
import kd.bos.ext.hr.metadata.prop.QueryProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.QueryEntity;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;

public class QueryField
extends BasedataField
implements IQueryField {
    private static final long serialVersionUID = 2648903963262562030L;
    private static final Log LOGGER = LogFactory.getLog(QueryField.class);
    String listModel = "list";
    String treeFormId;
    String billFormId;
    String editSearchProp;
    String displayProp;
    String viewDetailList;
    boolean preciseSearch = false;
    List<Plugin> basedataControllers = Lists.newArrayListWithExpectedSize((int)4);

    @SimplePropertyAttribute(name="EditSearchProp")
    public String getEditSearchProp() {
        return this.editSearchProp;
    }

    public void setEditSearchProp(String editSearchProp) {
        this.editSearchProp = editSearchProp;
    }

    @SimplePropertyAttribute(name="DisplayProp")
    public String getDisplayProp() {
        return this.displayProp;
    }

    public void setDisplayProp(String displayProp) {
        this.displayProp = displayProp;
    }

    public Map<String, Object> createEditor() {
        Map ctlRet = super.createEditor();
        return this.createQueryEditor(this.getBaseEntityId(), ctlRet, this.getDisplayProp(), this.getEditSearchProp());
    }

    @SimplePropertyAttribute(name="listModel")
    public String getListModel() {
        return this.listModel;
    }

    public void setListModel(String listModel) {
        this.listModel = listModel;
    }

    @SimplePropertyAttribute(name="preciseSearch")
    public boolean isPreciseSearch() {
        return this.preciseSearch;
    }

    public void setPreciseSearch(boolean preciseSearch) {
        this.preciseSearch = preciseSearch;
    }

    @SimplePropertyAttribute(name="treeFormId")
    public String getTreeFormId() {
        return this.treeFormId;
    }

    public void setTreeFormId(String treeFormId) {
        this.treeFormId = treeFormId;
    }

    @SimplePropertyAttribute(name="billFormId")
    public String getBillFormId() {
        return this.billFormId;
    }

    public void setBillFormId(String billFormId) {
        this.billFormId = billFormId;
    }

    @SimplePropertyAttribute(name="viewDetailList")
    public String getViewDetailList() {
        return this.viewDetailList;
    }

    public void setViewDetailList(String viewDetailList) {
        this.viewDetailList = viewDetailList;
    }

    @CollectionPropertyAttribute(name="BasedataControllers", collectionItemPropertyType=Plugin.class)
    public List<Plugin> getBasedataControllers() {
        return this.basedataControllers;
    }

    public void setBasedataControllers(List<Plugin> basedataControllers) {
        this.basedataControllers = basedataControllers;
    }

    protected QueryEdit createServerEditor() {
        QueryEdit queryEdit = new QueryEdit();
        queryEdit.setListModel(this.listModel);
        queryEdit.setTreeFormId(this.treeFormId);
        queryEdit.setBillFormId(this.billFormId);
        queryEdit.setDisplayProp(this.displayProp);
        queryEdit.setEditSearchProp(this.editSearchProp);
        queryEdit.setPreciseSearch("list".equals(this.listModel) && this.preciseSearch);
        queryEdit.setViewDetailList(this.viewDetailList);
        queryEdit.setBasedataControllers(this.basedataControllers);
        return queryEdit;
    }

    protected void setBasedataProp(BasedataProp prop) {
        String name = (String)prop.getDisplayName().getDefaultItem();
        if (this.getBaseEntityId() != null) {
            Field field;
            String number = MetadataDao.getEntityNumberById((String)this.getBaseEntityId());
            if (number == null) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7684\u201c\u67e5\u8be2\u5b9e\u4f53\u201d\u4e0d\u5b58\u5728\u3002", (String)"QueryField_0", (String)"bos-ext-hr", (Object[])new Object[0]), name));
                this.setBaseEntityId(null);
            }
            prop.setBaseEntityId(number);
            this.checkBillFormId(name, number);
            if (this.getDisplayProp() == null) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryField_2", (String)"bos-ext-hr", (Object[])new Object[0]), name));
            } else {
                prop.setDisplayProp(this.getDisplayProp());
            }
            if (this.getEditSearchProp() == null) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7f16\u8f91\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryField_3", (String)"bos-ext-hr", (Object[])new Object[0]), name));
            } else {
                prop.setEditSearchProp(this.getEditSearchProp());
            }
            prop.setNumberProp(this.getNumberProp());
            if (!StringUtils.isBlank((CharSequence)this.getOrgFieldId()) && (field = this.entityMetadata.getFieldById(this.getOrgFieldId())) != null) {
                prop.setOrgProp(field.getKey().toLowerCase());
            }
        } else {
            this.baseEntityIdNonTip(name);
        }
        if (this.hasLayout()) {
            prop.setLayoutId(this.getLayoutId());
        }
        if (StringUtils.isNotEmpty((CharSequence)this.getBillFormId())) {
            ((QueryProp)prop).setBillFormId(this.getBillFormId());
        }
        prop.setDefValue(this.getDefValue());
        prop.setDefValue2(this.buildFieldDefValue());
        prop.setDbIgnore(!this.isEditRefProp());
        prop.setShowUsed(this.isShowUsed());
        prop.setCompareTypeConfig(this.getCompareTypeConfig());
    }

    protected void checkBillFormId(String name, String entityNumber) {
        if (StringUtils.isNotEmpty((CharSequence)this.getBillFormId())) {
            FormConfig fromConfig;
            try {
                fromConfig = FormMetadataCache.getFormConfig((String)this.billFormId);
            }
            catch (Exception e) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u67e5\u8be2\u5217\u8868\u4e0d\u5b58\u5728\u3002", (String)"QueryField_4", (String)"bos-ext-hr", (Object[])new Object[0]), name));
                return;
            }
            if (null == fromConfig) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u67e5\u8be2\u5217\u8868\u4e0d\u5b58\u5728\u3002", (String)"QueryField_4", (String)"bos-ext-hr", (Object[])new Object[0]), name));
                return;
            }
            LOGGER.info("checkBillFormId:{},{},{}", new Object[]{fromConfig.getModelType(), fromConfig.getEntityTypeId(), entityNumber});
            if ("list".equals(fromConfig.getModelType()) && !entityNumber.equals(fromConfig.getEntityTypeId())) {
                this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u67e5\u8be2\u5217\u8868\u5173\u8054\u5b9e\u4f53\u4e0e\u67e5\u8be2\u5b9e\u4f53\u4e0d\u4e00\u81f4\u3002", (String)"QueryField_5", (String)"bos-ext-hr", (Object[])new Object[0]), name));
            }
        }
    }

    protected void baseEntityIdNonTip(String fieldName) {
        this.addBuildError(2, "BaseEntityId", String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u5173\u8054\u7684\u201c\u67e5\u8be2\u5b9e\u4f53\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"QueryField_1", (String)"bos-ext-hr", (Object[])new Object[0]), fieldName));
    }

    private boolean hasLayout() {
        return StringUtils.isNotEmpty((CharSequence)this.getLayoutId());
    }

    protected QueryProp createDynamicProperty() {
        return new QueryProp();
    }

    public int getFieldDBType() {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readMeta((String)this.getBaseEntityId(), (MetaCategory)MetaCategory.Entity);
        int pkType = 0;
        for (Entity entity : entityMetadata.getEntitys()) {
            if (entity instanceof BillEntity) {
                pkType = ((BillEntity)entity).getPkType() == 0 ? 12 : -5;
                break;
            }
            if (!(entity instanceof QueryEntity)) continue;
            pkType = ((QueryEntity)entity).getPkType() == 0 ? 12 : -5;
            break;
        }
        return pkType;
    }
}

