/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.service.operation;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillStatusProp;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public abstract class AuditStatusConvertOperateService
extends EntityOperateService {
    private boolean isStatusConvert = true;
    private String statusFieldKey = "auditstatus";
    private String billStatusFieldKey = "billstatus";
    private String AUDITOR = "auditor";
    private String AUDITDATE = "auditdate";
    protected BillStatusProp statusProperty;
    protected BillStatusProp billStatusProperty;
    protected String oldStatusValue = "";
    protected String auditStatus = "";
    protected String oldBillStatusValue = "";
    protected String billAuditStatus = "";
    private boolean[] oldStatusDirtyFlags = new boolean[]{false, false, false, false};

    public void initialize(MainEntityType entityType, String operationKey, DynamicObject[] dataEntites) {
        super.initialize(entityType, operationKey, dataEntites);
        if (entityType instanceof BillEntityType) {
            this.statusProperty = (BillStatusProp)this.billEntityType.getProperty(this.statusFieldKey);
            this.billStatusProperty = (BillStatusProp)this.billEntityType.getProperty(this.billStatusFieldKey);
        }
    }

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.add(this.statusFieldKey);
        fieldKeys.add(this.billStatusFieldKey);
        fieldKeys.add(this.AUDITOR);
        fieldKeys.add(this.AUDITDATE);
    }

    protected void beforeCallOperationTransaction(DynamicObject[] objs) {
        super.beforeCallOperationTransaction(objs);
        if (StringUtils.isNotBlank((CharSequence)this.statusFieldKey) && objs.length == 1) {
            this.oldStatusValue = (String)objs[0].get(this.statusFieldKey);
            this.oldBillStatusValue = (String)objs[0].get(this.billStatusFieldKey);
            this.markOldStatusDirtyFlags(objs[0]);
        }
        if (this.isStatusConvert) {
            this.updateAuditStatus(objs);
        }
        this.updateBillSysField(objs);
        try {
            this.afterUpdateAuditStatus(objs);
        }
        catch (Exception ex) {
            this.rollbackStatus(objs);
            throw ex;
        }
    }

    private void markOldStatusDirtyFlags(DynamicObject obj) {
        BillStatusProp.StatusItemPro billStatusItem;
        String operatedDate;
        String operatorKey;
        if (StringUtils.isBlank((CharSequence)this.statusFieldKey) || this.statusProperty == null || obj.getDataEntityType().getProperties().get((Object)this.statusFieldKey) == null || StringUtils.isBlank((CharSequence)this.billStatusFieldKey) || obj.getDataEntityType().getProperties().get((Object)this.billStatusFieldKey) == null) {
            return;
        }
        BillStatusProp.StatusItemPro statusItem = this.statusProperty.getStatusItem(this.auditStatus);
        if (statusItem == null) {
            return;
        }
        DynamicProperty statusProp = this.statusProperty.findTrueProperty(obj);
        if (statusProp != null) {
            int bitIndex = statusProp.getOrdinal();
            this.oldStatusDirtyFlags[0] = obj.getLastDirty().get(bitIndex);
        }
        if (StringUtils.isNotBlank((CharSequence)(operatorKey = statusItem.getOperationerKey()))) {
            BasedataProp operatorProp = (BasedataProp)this.subEntityType.getProperty(operatorKey);
            int bitIndex = operatorProp.findTrueProperty(obj).getOrdinal();
            this.oldStatusDirtyFlags[1] = obj.getLastDirty().get(bitIndex);
        }
        if (StringUtils.isNotBlank((CharSequence)(operatedDate = statusItem.getOperationDateKey()))) {
            DynamicProperty operateDateProp = this.subEntityType.getProperty(operatedDate);
            int bitIndex = operateDateProp.findTrueProperty(obj).getOrdinal();
            this.oldStatusDirtyFlags[2] = obj.getLastDirty().get(bitIndex);
        }
        if ((billStatusItem = this.billStatusProperty.getStatusItem(this.billAuditStatus)) == null) {
            return;
        }
        DynamicProperty billStatusProp = this.billStatusProperty.findTrueProperty(obj);
        if (statusProp != null) {
            int bitIndex = statusProp.getOrdinal();
            this.oldStatusDirtyFlags[3] = obj.getLastDirty().get(bitIndex);
        }
    }

    protected void afterUpdateAuditStatus(DynamicObject[] objs) {
    }

    protected void rollback(DynamicObject[] objs, Exception ex) {
        this.rollbackStatus(objs);
        super.rollback(objs, ex);
    }

    protected void executeOperate(DynamicObject[] objs) {
        BillEntityType et = (BillEntityType)this.getBillEntityType();
        if (this.checkOperation(et)) {
            SaveServiceHelper.save((DynamicObject[])objs);
        }
    }

    private boolean checkOperation(BillEntityType et) {
        String tableName = et.getAlias();
        if (StringUtils.isBlank((CharSequence)tableName)) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"tableName", ResManager.loadKDString((String)"\u8868\u5355\u672a\u5b9a\u4e49\u5355\u636e\u5934\u5bf9\u5e94\u7684\u8868\uff0c\u4e0d\u80fd\u72b6\u6001\u8f6c\u6362\u3002\u8bf7\u5c1d\u8bd5\u5728BOS\u8bbe\u8ba1\u5668\u4e2d\u5b9a\u4e49\u8868\u540d\u79f0\u3002", (String)"AuditStatusConvertOperateService_0", (String)"bos-ext-hr", (Object[])new Object[0])});
        }
        if (this.isStatusConvert && StringUtils.isBlank((CharSequence)this.statusFieldKey)) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{"statusFieldName", ResManager.loadKDString((String)"\u8868\u5355\u4e0d\u5b58\u72b6\u6001\u5b57\u6bb5\uff0c\u4e0d\u80fd\u8fdb\u884c\u72b6\u6001\u8f6c\u6362\u3002", (String)"AuditStatusConvertOperateService_1", (String)"bos-ext-hr", (Object[])new Object[0])});
        }
        return true;
    }

    protected void updateAuditStatus(DynamicObject[] dataEntities) {
        this.updateAuditStatus(dataEntities, "");
        this.updateBillAuditStatus(dataEntities, "");
    }

    private void updateAuditStatus(DynamicObject[] dataEntities, String statusValue) {
        String newStatusValue;
        String string = newStatusValue = StringUtils.isBlank((CharSequence)statusValue) ? this.auditStatus : statusValue;
        if (StringUtils.isBlank((CharSequence)this.statusFieldKey) || this.statusProperty == null || StringUtils.isBlank((CharSequence)newStatusValue) || dataEntities == null || dataEntities.length == 0 || dataEntities[0].getDataEntityType().getProperties().get((Object)this.statusFieldKey) == null) {
            return;
        }
        this.setStatus(dataEntities, newStatusValue);
        this.setOperator(dataEntities, newStatusValue);
    }

    private void updateBillAuditStatus(DynamicObject[] dataEntities, String billStatusValue) {
        String newBillStatusValue;
        String string = newBillStatusValue = StringUtils.isBlank((CharSequence)billStatusValue) ? this.billAuditStatus : billStatusValue;
        if (StringUtils.isBlank((CharSequence)newBillStatusValue) || dataEntities == null || dataEntities.length == 0 || StringUtils.isBlank((CharSequence)this.billStatusFieldKey) || this.billStatusProperty == null || dataEntities[0].getDataEntityType().getProperties().get((Object)this.billStatusFieldKey) == null) {
            return;
        }
        for (DynamicObject obj : dataEntities) {
            this.billStatusProperty.setValue((Object)obj, (Object)newBillStatusValue);
        }
    }

    protected void setStatus(DynamicObject[] dataEntities, String newStatusValue) {
        for (DynamicObject obj : dataEntities) {
            this.statusProperty.setValue((Object)obj, (Object)newStatusValue);
        }
    }

    private void setOperator(DynamicObject[] dataEntities, String newStatusValue) {
        block10: {
            DynamicProperty operatedateProp;
            String operatedate;
            BasedataProp operatorProp;
            BillStatusProp.StatusItemPro statusItem = this.statusProperty.getStatusItem(newStatusValue);
            if (statusItem == null) {
                return;
            }
            String operatorKey = statusItem.getOperationerKey();
            boolean isClearField = statusItem.getClearOperationKey();
            if (StringUtils.isNotBlank((CharSequence)operatorKey) && (operatorProp = (BasedataProp)this.subEntityType.getProperty(operatorKey)) != null) {
                if (isClearField) {
                    for (DynamicObject obj : dataEntities) {
                        operatorProp.resetDTValue(obj);
                        operatorProp.getRefIdProp().setValueFast((Object)obj, (Object)0);
                    }
                } else {
                    long userId = Long.parseLong(RequestContext.get().getUserId());
                    DynamicObject operator = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (DynamicObjectType)operatorProp.getDynamicComplexPropertyType());
                    DynamicObject[] dynamicObjectArray = dataEntities;
                    int n = dynamicObjectArray.length;
                    for (int i = 0; i < n; ++i) {
                        DynamicObject obj = dynamicObjectArray[i];
                        operatorProp.setValueFast((Object)obj, (Object)operator);
                    }
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)(operatedate = statusItem.getOperationDateKey())) || (operatedateProp = this.subEntityType.getProperty(operatedate)) == null) break block10;
            if (isClearField) {
                for (DynamicObject obj : dataEntities) {
                    operatedateProp.resetDTValue(obj);
                }
            } else {
                Date date = TimeServiceHelper.now();
                for (DynamicObject obj : dataEntities) {
                    operatedateProp.setValue((Object)obj, (Object)date);
                }
            }
        }
    }

    protected void updateBillSysField(DynamicObject[] dataEntities) {
    }

    protected void updateModifier(DynamicObject[] dataEntities) {
        block7: {
            ModifyDateProp modifyDateProp;
            block6: {
                boolean update = Boolean.parseBoolean(this.getOption().getVariableValue("updateModifyDate", "true"));
                if (!update) {
                    return;
                }
                ModifierProp modifierProp = null;
                modifyDateProp = null;
                for (IDataEntityProperty prop : this.subEntityType.getProperties()) {
                    if (prop instanceof ModifierProp) {
                        modifierProp = (ModifierProp)prop;
                    }
                    if (prop instanceof ModifyDateProp) {
                        modifyDateProp = (ModifyDateProp)prop;
                    }
                    if (modifierProp == null || modifyDateProp == null) continue;
                    break;
                }
                if (modifierProp == null) break block6;
                long userId = Long.parseLong(RequestContext.get().getUserId());
                DynamicObject modifier = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (DynamicObjectType)modifierProp.getDynamicComplexPropertyType());
                Date now = TimeServiceHelper.now();
                for (DynamicObject obj : dataEntities) {
                    modifierProp.setValueFast((Object)obj, (Object)modifier);
                    if (modifyDateProp == null) continue;
                    modifyDateProp.setValueFast((Object)obj, (Object)now);
                }
                break block7;
            }
            if (modifyDateProp == null) break block7;
            Date now = TimeServiceHelper.now();
            for (DynamicObject obj : dataEntities) {
                modifyDateProp.setValueFast((Object)obj, (Object)now);
            }
        }
    }

    protected void rollbackStatus(DynamicObject[] objs) {
        if (this.isStatusConvert && StringUtils.isNotBlank((CharSequence)this.statusFieldKey) && objs.length == 1 && this.billEntityType instanceof MainEntityType) {
            this.updateAuditStatus(objs, this.oldStatusValue);
            this.updateBillAuditStatus(objs, this.oldBillStatusValue);
            this.clearBillStatusDirtyFlag(objs);
        }
    }

    private void clearBillStatusDirtyFlag(DynamicObject[] dataEntities) {
        if (StringUtils.isBlank((CharSequence)this.statusFieldKey) || this.statusProperty == null || dataEntities == null || dataEntities.length == 0 || dataEntities[0].getDataEntityType().getProperties().get((Object)this.statusFieldKey) == null) {
            return;
        }
        BillStatusProp.StatusItemPro statusItem = this.statusProperty.getStatusItem(this.auditStatus);
        for (DynamicObject obj : dataEntities) {
            String operatedDate;
            if (!this.oldStatusDirtyFlags[0]) {
                this.clearDirtyFlag(obj, (IDataEntityProperty)this.statusProperty.findTrueProperty(obj));
            }
            if (statusItem == null) continue;
            String operatorKey = statusItem.getOperationerKey();
            if (StringUtils.isNotBlank((CharSequence)operatorKey) && !this.oldStatusDirtyFlags[1]) {
                BasedataProp operatorProp = (BasedataProp)this.subEntityType.getProperty(operatorKey);
                this.clearDirtyFlag(obj, (IDataEntityProperty)operatorProp.findTrueProperty(obj));
                this.clearDirtyFlag(obj, operatorProp.getRefIdProp());
            }
            if (!StringUtils.isNotBlank((CharSequence)(operatedDate = statusItem.getOperationDateKey())) || this.oldStatusDirtyFlags[2]) continue;
            DynamicProperty operateDateProp = this.subEntityType.getProperty(operatedDate);
            this.clearDirtyFlag(obj, (IDataEntityProperty)operateDateProp.findTrueProperty(obj));
        }
    }

    private void clearDirtyFlag(DynamicObject obj, IDataEntityProperty property) {
        if (obj == null || property == null) {
            return;
        }
        int bitIndex = property.getOrdinal();
        obj.getLastDirty().clear(bitIndex);
        obj.getDataEntityState().setBizChanged(bitIndex, false);
    }
}

