/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.service.query;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.ext.hr.util.query.QueryEntityTypeUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class QueryEntityHelper {
    private static final QueryEntityHelper INSTANCE = new QueryEntityHelper();

    private QueryEntityHelper() {
    }

    public static QueryEntityHelper getInstance() {
        return INSTANCE;
    }

    public DynamicObjectCollection getQueryDyoColl(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys) {
        return this.getQueryDyoColl(queryEntityType, queryFileds, qFilters, orderBys, false, 0, 0);
    }

    public DynamicObjectCollection getQueryDyoColl(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, int start, int limit) {
        return this.getQueryDyoColl(queryEntityType, queryFileds, qFilters, orderBys, true, start, limit);
    }

    public DynamicObjectCollection getQueryDyoColl(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit) {
        queryFileds = this.addQueryPkFileds(queryEntityType, queryFileds);
        QueryEntityTypeUtil queryEntityUtil = new QueryEntityTypeUtil(queryEntityType, queryFileds, true);
        DynamicObjectType returnType = queryEntityUtil.genDynamicObjectType();
        return this.getQueryDyoColl(queryEntityType, returnType, queryFileds, qFilters, orderBys, isLimitCount, start, limit);
    }

    public DynamicObjectCollection getQueryDyoColl(QueryEntityType queryEntityType, DynamicObjectType returnType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit) {
        return (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSQueryService", (String)"getQueryDyoColl", (Object[])new Object[]{queryEntityType, returnType, queryFileds, qFilters, orderBys, isLimitCount, start, limit});
    }

    public DataSet getQueryDataSet(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys) {
        return this.getQueryDataSet(queryEntityType, queryFileds, qFilters, orderBys, false, 0, 0);
    }

    public DataSet getQueryDataSet(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, int start, int limit) {
        return this.getQueryDataSet(queryEntityType, queryFileds, qFilters, orderBys, true, start, limit);
    }

    public DataSet getQueryDataSet(QueryEntityType queryEntityType, String queryFileds, QFilter[] qFilters, String orderBys, boolean isLimitCount, int start, int limit) {
        return (DataSet)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrcs", (String)"IHRCSQueryService", (String)"getQueryDataSet", (Object[])new Object[]{queryEntityType, queryFileds, qFilters, orderBys, isLimitCount, start, limit});
    }

    private String addQueryPkFileds(QueryEntityType queryEntityType, String queryFileds) {
        String mainEntityPk;
        String[] listFields = queryFileds.split(",");
        ArrayList<String> listFileds = new ArrayList<String>(Arrays.asList(listFields));
        if (!listFileds.contains(mainEntityPk = queryEntityType.getPrimaryKey().getName())) {
            listFileds.add(mainEntityPk);
        }
        for (JoinEntity joinEntity : queryEntityType.getJoinEntitys()) {
            String joinEntityNum = joinEntity.getEntityName();
            ISimpleProperty primaryKey = EntityMetadataCache.getDataEntityType((String)joinEntityNum).getPrimaryKey();
            String joinPkField = joinEntityNum + "." + primaryKey.getName();
            if (listFileds.contains(joinPkField)) continue;
            listFileds.add(joinPkField);
        }
        return StringUtils.join(listFileds, (String)",");
    }
}

