/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.ext.hr.thread.IHRUnifiedTaskType;
import kd.bos.unifiedthreadpool.api.PoolRejectedExecutionHandler;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.bos.unifiedthreadpool.policy.AbortPolicy;
import kd.bos.unifiedthreadpool.tasktype.Priority;
import kd.bos.unifiedthreadpool.tasktype.TaskType;

public class HRThreadExecutorService {
    private static final ThreadExecutorService SERVICE = ThreadPoolFactory.create((String)"hr", (String)"hr-threadpool", (ThreadPoolStrategy)HRThreadExecutorService.getDefaultThreadPoolStrategy());

    private static ThreadPoolStrategy getDefaultThreadPoolStrategy() {
        ThreadPoolStrategy strategy = ThreadPoolStrategyFactory.create();
        strategy.setMinThreadNum(20).setMaxThreadNum(150).setOverflowThreadNum(20).setThreadIdeMinutes(1L);
        strategy.setRejectedExecutionHandler((PoolRejectedExecutionHandler)new AbortPolicy());
        strategy.register(new TaskType("hr.commontask", Priority.FIVE));
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ThreadExecutorService get(IHRUnifiedTaskType taskTypeEnum) {
        TaskType taskType = HRThreadExecutorService.getTaskType(taskTypeEnum);
        if (taskType == null) {
            IHRUnifiedTaskType iHRUnifiedTaskType = taskTypeEnum;
            synchronized (iHRUnifiedTaskType) {
                taskType = HRThreadExecutorService.getTaskType(taskTypeEnum);
                if (taskType == null) {
                    taskType = new TaskType(taskTypeEnum.getName(), taskTypeEnum.getPriority(), taskTypeEnum.getThreadLimitedModel(), (Object)taskTypeEnum.getThreadLimitedValue(), taskTypeEnum.getTaskQueueMaxSize());
                    SERVICE.addTaskType(taskType);
                }
            }
        }
        return SERVICE;
    }

    private static TaskType getTaskType(IHRUnifiedTaskType taskTypeEnum) {
        TaskType taskType = null;
        try {
            taskType = SERVICE.getTaskType(taskTypeEnum.getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return taskType;
    }

    public static void execute(Runnable runnable, IHRUnifiedTaskType taskTypeEnum, RequestContext requestContext, OperationContext operationContext) {
        HRThreadExecutorService.get(taskTypeEnum).execute(runnable, taskTypeEnum.getName(), requestContext, operationContext);
    }

    public static <T> Future<T> submit(Callable<T> callable, IHRUnifiedTaskType taskTypeEnum, RequestContext requestContext, OperationContext operationContext) {
        return HRThreadExecutorService.get(taskTypeEnum).submit(callable, taskTypeEnum.getName(), requestContext, operationContext);
    }
}

