/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import kd.bos.actiondispatcher.ActionUtil;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.ext.hr.web.filter.IndexHtmlFilter;
import kd.bos.ext.hr.web.filter.NewMobileHtmlFilter;
import kd.bos.ext.hr.web.util.HrFilterUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.LoginUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;

public class HtmlFacadeFilter
implements Filter {
    private static final Log LOGGER = LogFactory.getLog(HtmlFacadeFilter.class);
    private static ThreadLocal<RequestInfo> LOCAL_REQUEST_META = new ThreadLocal();
    private Filter indexHtmlFilter;
    private Filter mobileHtmlFilter;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String loginConfigNumber = HrFilterUtil.xssEncode(request.getParameter("loginConfigNumber"));
        LOGGER.info("Got loginConfigNumber: {}.", (Object)loginConfigNumber);
        if (StringUtils.isEmpty((String)loginConfigNumber)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        String clientType = HrFilterUtil.getClientType(request, loginConfigNumber);
        LOGGER.info("Got client type: {}.", (Object)clientType);
        Filter htmlFilter = clientType.equals("web") ? this.indexHtmlFilter : this.mobileHtmlFilter;
        RequestInfo requestInfo = new RequestInfo();
        LOCAL_REQUEST_META.set(requestInfo);
        if (HrFilterUtil.isIndexHTML(request)) {
            requestInfo.formKey = "formId";
            requestInfo.commonLoginFormId = "hbss_commonloginpc";
        } else {
            requestInfo.formKey = "form";
            requestInfo.commonLoginFormId = "hbss_commonlogin";
        }
        LOGGER.info("Got filter: {}.", (Object)htmlFilter);
        try {
            htmlFilter.doFilter(servletRequest, servletResponse, filterChain);
        }
        catch (Exception ex) {
            LOGGER.error("HtmlFacadeFilterError:", (Throwable)ex);
            KDException kd = new KDException(LoginErrorCode.loginBizException, new Object[]{Resources.getString((String)"\u7cfb\u7edf\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01\n", (String)"LoginFilter_3", (String)"bos-login", (Object[])new Object[0]) + ex.getMessage()});
            String resp = LoginUtils.getLoginResponse((String)String.valueOf(kd.getErrorCode().getCode()), (String)kd.getMessage());
            try {
                ActionUtil.writeResponseJson((ServletResponse)servletResponse, (CharSequence)resp);
            }
            catch (Exception var52) {
                throw ex;
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.indexHtmlFilter = new IndexHtmlFilter();
        this.indexHtmlFilter.init(filterConfig);
        this.mobileHtmlFilter = new NewMobileHtmlFilter();
        this.mobileHtmlFilter.init(filterConfig);
    }

    public void destroy() {
        this.indexHtmlFilter.destroy();
        this.mobileHtmlFilter.destroy();
    }

    public static RequestInfo getRequestMeta() {
        return LOCAL_REQUEST_META.get();
    }

    static class RequestInfo {
        String formKey;
        String commonLoginFormId;
        boolean isInterflow;

        RequestInfo() {
        }
    }
}

