/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.ext.data.idi.model.HighLightCursor;
import kd.bos.ext.data.idi.model.HighLightHandler;
import kd.bos.form.AbstractFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.orm.util.StringUtils;
import kd.bos.util.CollectionUtils;
import kd.bos.util.Pair;

public class EntryColumnHighLight {
    private String entryName;
    private String[] entryFields;
    private Map<String, int[]> fieldCellIndexMap;

    public String getEntryName() {
        return this.entryName;
    }

    public void setEntryName(String entryName) {
        this.entryName = entryName;
    }

    public String[] getEntryFields() {
        return this.entryFields;
    }

    public void setEntryFields(String[] entryFields) {
        this.entryFields = entryFields;
    }

    public Map<String, int[]> getFieldCellIndexMap() {
        return this.fieldCellIndexMap;
    }

    public void setFieldCellIndexMap(Map<String, int[]> fieldCellIndexMap) {
        this.fieldCellIndexMap = fieldCellIndexMap;
    }

    public HighLightCursor findFirst() {
        if (this.entryFields != null && this.entryFields.length > 0 && this.fieldCellIndexMap != null && !this.fieldCellIndexMap.isEmpty()) {
            Map<Integer, String[]> rowDataMap = this.cellToRow();
            Optional first = rowDataMap.keySet().stream().findFirst();
            Integer entryIndex = (Integer)first.get();
            String field = rowDataMap.get(entryIndex)[0];
            return new HighLightCursor(this.entryName, field, entryIndex);
        }
        return null;
    }

    private Map<Integer, String[]> cellToRow() {
        if (this.entryFields != null && this.entryFields.length > 0 && this.fieldCellIndexMap != null && !this.fieldCellIndexMap.isEmpty()) {
            HashMap<Integer, Set> rowFieldMap = new HashMap<Integer, Set>(10);
            Set<Map.Entry<String, int[]>> fieldCellIndexEntrySet = this.fieldCellIndexMap.entrySet();
            for (Map.Entry<String, int[]> fieldCellIndexEntry : fieldCellIndexEntrySet) {
                String key = fieldCellIndexEntry.getKey();
                int[] rowIndexes = fieldCellIndexEntry.getValue();
                if (rowIndexes == null || rowIndexes.length <= 0) continue;
                for (int rowIndex : rowIndexes) {
                    Set fieldSet = rowFieldMap.computeIfAbsent(rowIndex, k -> new HashSet(10));
                    fieldSet.add(key);
                }
            }
            if (!rowFieldMap.isEmpty()) {
                HashMap<String, Integer> fieldIndexMap = new HashMap<String, Integer>(this.entryFields.length);
                for (int i = 0; i < this.entryFields.length; ++i) {
                    fieldIndexMap.put(this.entryFields[i], i);
                }
                LinkedHashMap<Integer, String[]> sortRowFieldMap = new LinkedHashMap<Integer, String[]>(10);
                Set indexSet = rowFieldMap.keySet();
                ArrayList indexList = new ArrayList(indexSet);
                indexList.sort(Integer::compare);
                Object object = indexList.iterator();
                while (object.hasNext()) {
                    Integer integer = (Integer)object.next();
                    Set fieldSet = (Set)rowFieldMap.get(integer);
                    if (CollectionUtils.isEmpty((Collection)fieldSet)) continue;
                    ArrayList<Pair> fieldSortList = new ArrayList<Pair>(fieldSet.size());
                    for (String field : fieldSet) {
                        fieldSortList.add(new Pair((Object)field, fieldIndexMap.get(field)));
                    }
                    fieldSortList.sort(Comparator.comparing(Pair::getValue));
                    String[] fields = fieldSortList.stream().map(Pair::getKey).collect(Collectors.toList()).toArray(new String[0]);
                    sortRowFieldMap.put(integer, fields);
                }
                return sortRowFieldMap;
            }
        }
        return null;
    }

    public HighLightCursor findEnd() {
        if (this.entryFields != null && this.entryFields.length > 0 && this.fieldCellIndexMap != null && !this.fieldCellIndexMap.isEmpty()) {
            return this.findEntryFieldEnd();
        }
        return null;
    }

    public HighLightCursor findEntryFieldEnd() {
        Map<Integer, String[]> rowDataMap = this.cellToRow();
        Optional end = rowDataMap.keySet().stream().max(Integer::compareTo);
        Integer entryIndex = (Integer)end.get();
        String[] rowField = rowDataMap.get(entryIndex);
        String field = rowField[rowField.length - 1];
        return new HighLightCursor(this.entryName, field, entryIndex);
    }

    public HighLightCursor previousCursor(HighLightCursor curHighLightCursor) {
        if (curHighLightCursor == null) {
            return null;
        }
        if (curHighLightCursor.isEntry()) {
            Map<Integer, String[]> rowDataMap = this.cellToRow();
            int entryIndex = curHighLightCursor.getEntryIndex();
            String field = curHighLightCursor.getEntryField();
            String[] rowField = rowDataMap.get(entryIndex);
            if (rowField[0].equals(field)) {
                int preEntryIndex = this.findPreEntryIndex(entryIndex, rowDataMap.keySet());
                if (preEntryIndex > -1) {
                    String[] preRowField = rowDataMap.get(preEntryIndex);
                    String preField = preRowField[preRowField.length - 1];
                    return new HighLightCursor(this.entryName, preField, preEntryIndex);
                }
            } else {
                for (int i = 0; i < rowField.length; ++i) {
                    if (!rowField[i].equals(field)) continue;
                    String preField = rowField[i - 1];
                    return new HighLightCursor(this.entryName, preField, entryIndex);
                }
            }
        }
        return null;
    }

    private int findPreEntryIndex(int entryIndex, Set<Integer> entryIndexSet) {
        int preIndex = -1;
        for (Integer index : entryIndexSet) {
            if (index.compareTo(entryIndex) == 0) break;
            preIndex = index;
        }
        return preIndex;
    }

    public HighLightCursor nextCursor(HighLightCursor curHighLightCursor) {
        if (curHighLightCursor == null) {
            return null;
        }
        if (curHighLightCursor.isEntry()) {
            Map<Integer, String[]> rowDataMap = this.cellToRow();
            int entryIndex = curHighLightCursor.getEntryIndex();
            String field = curHighLightCursor.getEntryField();
            String[] rowField = rowDataMap.get(entryIndex);
            if (rowField[rowField.length - 1].equals(field)) {
                int nextEntryIndex = this.findNextEntryIndex(entryIndex, rowDataMap.keySet());
                if (nextEntryIndex > -1) {
                    String[] nextRowField = rowDataMap.get(nextEntryIndex);
                    String nextField = nextRowField[0];
                    return new HighLightCursor(this.entryName, nextField, nextEntryIndex);
                }
            } else {
                for (int i = 0; i < rowField.length; ++i) {
                    if (!rowField[i].equals(field)) continue;
                    String nextField = rowField[i + 1];
                    return new HighLightCursor(this.entryName, nextField, entryIndex);
                }
            }
        }
        return null;
    }

    private int findNextEntryIndex(int entryIndex, Set<Integer> entryIndexSet) {
        int nextIndex = -1;
        Integer curEntryIndex = entryIndex;
        for (Integer index : entryIndexSet) {
            if (index.compareTo(curEntryIndex) <= 0) continue;
            nextIndex = index;
            break;
        }
        return nextIndex;
    }

    public void createHighLightCommand(AbstractFormView billView, HighLightCursor cursor) {
        if (billView == null) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)billView.getControl(this.entryName);
        int pageSize = entryGrid.getPageRow();
        int startRowIndex = 0;
        int endRowIndex = pageSize;
        boolean curEntry = false;
        if (cursor != null && cursor.isEntry() && cursor.getEntryName().equals(this.entryName)) {
            boolean inCurrentPage;
            AbstractGrid.GridState entryState = entryGrid.getEntryState();
            int currentPageIndex = entryState.getCurrentPageIndex();
            int dataPageIndex = cursor.getEntryIndex() / pageSize + 1;
            boolean bl = inCurrentPage = dataPageIndex == currentPageIndex;
            if (!inCurrentPage) {
                entryGrid.setPageIndex(dataPageIndex);
            }
            startRowIndex = (dataPageIndex - 1) * pageSize;
            endRowIndex = startRowIndex + pageSize;
        }
        if (this.entryFields != null && this.entryFields.length > 0 && this.fieldCellIndexMap != null && !this.fieldCellIndexMap.isEmpty()) {
            for (String entryField : this.entryFields) {
                int[] entryIndexes;
                for (int matchRowIndex : entryIndexes = this.fieldCellIndexMap.get(entryField)) {
                    if (matchRowIndex < startRowIndex || matchRowIndex >= endRowIndex) continue;
                    List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommand(entryField, matchRowIndex, cursor != null && cursor.ignoreEntryField(this.entryName, entryField, matchRowIndex));
                    billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
                }
            }
        }
        if (cursor != null && !StringUtils.isEmpty((Object)cursor.getEntryName()) && cursor.getEntryName().equals(this.getEntryName())) {
            HighLightHandler.createEntryFocus(cursor, billView);
        }
    }

    public void createHighLightCommandToNewCursor(AbstractFormView billView, HighLightCursor newCursor) {
        if (billView == null) {
            return;
        }
        if (newCursor != null && newCursor.isEntry() && newCursor.getEntryName().equals(this.entryName)) {
            boolean inCurrentPage;
            EntryGrid entryGrid = (EntryGrid)billView.getControl(this.entryName);
            int pageSize = entryGrid.getPageRow();
            AbstractGrid.GridState entryState = entryGrid.getEntryState();
            int currentPageIndex = entryState.getCurrentPageIndex();
            int dataPageIndex = newCursor.getEntryIndex() / pageSize + 1;
            boolean bl = inCurrentPage = dataPageIndex == currentPageIndex;
            if (!inCurrentPage) {
                entryGrid.setPageIndex(dataPageIndex);
                int startRowIndex = (dataPageIndex - 1) * pageSize;
                int endRowIndex = startRowIndex + pageSize;
                if (this.entryFields != null && this.entryFields.length > 0 && this.fieldCellIndexMap != null && !this.fieldCellIndexMap.isEmpty()) {
                    for (String entryField : this.entryFields) {
                        int[] entryIndexes;
                        for (int matchRowIndex : entryIndexes = this.fieldCellIndexMap.get(entryField)) {
                            if (matchRowIndex < startRowIndex || matchRowIndex >= endRowIndex) continue;
                            List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommand(entryField, matchRowIndex, newCursor.ignoreEntryField(this.entryName, entryField, matchRowIndex));
                            billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
                        }
                    }
                }
            } else {
                List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommand(newCursor.getEntryField(), newCursor.getEntryIndex(), true);
                billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
            }
        }
        if (newCursor != null && !StringUtils.isEmpty((Object)newCursor.getEntryName()) && newCursor.getEntryName().equals(this.getEntryName())) {
            HighLightHandler.createEntryFocus(newCursor, billView);
        }
    }

    public void createCommandToCancel(AbstractFormView billView) {
        if (billView == null) {
            return;
        }
        if (this.entryFields != null && this.entryFields.length > 0 && this.fieldCellIndexMap != null && !this.fieldCellIndexMap.isEmpty()) {
            for (String entryField : this.entryFields) {
                int[] entryIndexes;
                for (int matchRowIndex : entryIndexes = this.fieldCellIndexMap.get(entryField)) {
                    List<Map<String, Object>> rowStyle = HighLightHandler.createEntryCommandCancel(entryField, matchRowIndex);
                    billView.getClientProxy().invokeControlMethod(this.entryName, "setCellStyle", new Object[]{rowStyle});
                }
            }
        }
    }
}

