/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.data.idi.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.ext.data.idi.model.HighLightCursor;
import kd.bos.form.AbstractFormView;

public class HighLightHandler {
    public static final String COLOR_WHITE = "#FFF";
    public static final String COLOR_HIGH = "#FFFBCB";
    public static final String COLOR_CURSOR = "#FFE97A";

    public static Map<String, Object> createHeadCommand(String field, boolean isForce) {
        return HighLightHandler.createHeadCommandCore(field, isForce ? COLOR_CURSOR : COLOR_HIGH);
    }

    public static Map<String, Object> createHeadCommandCancel(String field) {
        return HighLightHandler.createHeadCommandCore(field, COLOR_WHITE);
    }

    public static Map<String, Object> createHeadCommandCore(String field, String color) {
        HashMap<String, Object> ctls = new HashMap<String, Object>(10);
        ctls.put("id", field);
        ctls.put("bc", color);
        return ctls;
    }

    public static List<Map<String, Object>> createEntryCommandCancel(String field, int rowIndex) {
        return HighLightHandler.createEntryCommandCore(field, rowIndex, COLOR_WHITE);
    }

    public static List<Map<String, Object>> createEntryCommand(String field, int rowIndex, boolean isForce) {
        return HighLightHandler.createEntryCommandCore(field, rowIndex, isForce ? COLOR_CURSOR : COLOR_HIGH);
    }

    public static List<Map<String, Object>> createEntryCommandCore(String field, int rowIndex, String color) {
        ArrayList<Map<String, Object>> rowStyle = new ArrayList<Map<String, Object>>();
        HashMap<String, String> mapStyle = new HashMap<String, String>();
        mapStyle.put("bc", color);
        HashMap<String, Object> val = new HashMap<String, Object>();
        val.put("r", rowIndex);
        val.put("c", field);
        val.put("s", mapStyle);
        rowStyle.add(val);
        return rowStyle;
    }

    public static void createScrollIntoView(HighLightCursor cursor, AbstractFormView billView) {
        if (cursor == null || billView == null) {
            return;
        }
        HashMap<String, String> ctls = new HashMap<String, String>(10);
        ctls.put("k", cursor.isHead() ? cursor.getHeadField() : cursor.getEntryName());
        billView.getClientProxy().addAction("scrollIntoView", ctls);
    }

    public static void createEntryFocus(HighLightCursor cursor, AbstractFormView billView) {
        if (cursor == null || billView == null) {
            return;
        }
        if (cursor.isEntry() && cursor.isFocus()) {
            billView.getClientProxy().focusCell(cursor.getEntryName(), cursor.getEntryIndex(), cursor.getEntryField());
        }
    }
}

