/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.handle;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.chargeagainst.bizgroup.BizGroupRecordHelper;
import kd.bos.ext.scmc.chargeagainst.log.CaLogVo;
import kd.bos.ext.scmc.chargeagainst.service.CaLogService;
import kd.bos.ext.scmc.chargeagainst.util.CaModelField;
import kd.bos.ext.scmc.chargeagainst.util.CommonUtil;
import kd.bos.ext.scmc.chargeagainst.util.WriteOffServiceHelper;
import kd.bos.ext.scmc.chargeagainst.vo.CaPageVo;
import kd.bos.ext.scmc.chargeagainst.vo.RedBlueWfVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class RemoteServiceHandle {
    private static final Log logger = LogFactory.getLog(RemoteServiceHandle.class);
    private static final String BIZ_DIRECTION_BACK = "1";
    private List<Map<String, Object>> arRedWfRecordResults = new ArrayList<Map<String, Object>>(16);
    private List<Map<String, Object>> apRedWfRecordResults = new ArrayList<Map<String, Object>>(16);
    private List<Map<String, Object>> arWfResults = new ArrayList<Map<String, Object>>(16);
    private List<Map<String, Object>> apWfResults = new ArrayList<Map<String, Object>>(16);
    private CaLogService caLogService;
    private CaPageVo caPageVo;

    public static RemoteServiceHandle build(CaLogService caLogService, CaPageVo caPageVo) {
        RemoteServiceHandle handle = new RemoteServiceHandle();
        handle.setCaLogService(caLogService);
        handle.setCaPageVo(caPageVo);
        return handle;
    }

    public void caInterfaceService(Map<String, List<RedBlueWfVo>> redBlueBills) {
        this.caBillRedBlueWf(redBlueBills);
        this.srmSync(this.caPageVo.getCaBill());
        BizGroupRecordHelper.setBizGroupCompleted(this.caPageVo.getCaBill().getLong("id"));
    }

    public void chargeWfRecord(List<DynamicObject> caBilledList) {
        if (CollectionUtils.isEmpty(caBilledList)) {
            return;
        }
        IDataEntityType dataEntityType = caBilledList.get(0).getDataEntityType();
        String name = dataEntityType.getName();
        HashSet<String> supportCaBillTypes = new HashSet<String>(8);
        supportCaBillTypes.add("im_purinbill");
        supportCaBillTypes.add("im_purreceivebill");
        supportCaBillTypes.add("im_mdc_omcmplinbill");
        HashSet<String> wfSupportCaBillTypes = new HashSet<String>(8);
        wfSupportCaBillTypes.add("im_mdc_omfeedbill");
        wfSupportCaBillTypes.add("im_mdc_omoutbill");
        wfSupportCaBillTypes.add("im_mdc_omreturnbill");
        wfSupportCaBillTypes.add("im_saloutbill");
        wfSupportCaBillTypes.add("im_purinbill");
        wfSupportCaBillTypes.add("im_purreceivebill");
        wfSupportCaBillTypes.add("im_mdc_omcmplinbill");
        boolean iswriteoffplan = WriteOffServiceHelper.isWriteOffPlan(caBilledList.get(0).getLong("org.id"));
        if (iswriteoffplan && wfSupportCaBillTypes.contains(name)) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            List ids = caBilledList.stream().map(n -> n.getPkValue()).collect(Collectors.toList());
            paramMap.put("billType", name);
            paramMap.put("billId", ids);
            DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"WriteOffService", (String)"chargeAgainstRecordByBillIds", (Object[])new Object[]{paramMap});
        }
        if ("im_saloutbill".equals(name)) {
            this.generateRedVerifyRecord(caBilledList, "ar", "ArWrittenOffVerifyService", this.arRedWfRecordResults, "arRedWfRecordResults");
        } else if (supportCaBillTypes.contains(name)) {
            this.generateRedVerifyRecord(caBilledList, "ap", "ApWrittenOffVerifyService", this.apRedWfRecordResults, "apRedWfRecordResults");
        }
    }

    private void generateRedVerifyRecord(List<DynamicObject> caBilledList, String ap, String apWrittenOffVerifyService, List<Map<String, Object>> apRedWfRecordResultList, String apRedWfRecordResults) {
        String billType = caBilledList.get(0).getDataEntityType().getName();
        for (DynamicObject caBilled : caBilledList) {
            this.doRedRecordService(ap, apWrittenOffVerifyService, apRedWfRecordResultList, apRedWfRecordResults, billType, caBilled);
        }
    }

    private void doRedRecordService(String ap, String apWrittenOffVerifyService, List<Map<String, Object>> apRedWfRecordResultList, String apRedWfRecordResults, String billType, DynamicObject caBilled) {
        Map<String, Object> detail = this.buildCaWfRecordParam(billType, caBilled);
        logger.info(ap + "\u8c03\u7528generateRedVerifyRecord\u7684\u8bf7\u6c42\u53c2\u6570:" + detail);
        Map wfResult = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)ap, (String)apWrittenOffVerifyService, (String)"generateRedVerifyRecord", (Object[])new Object[]{detail, billType});
        String result = JSONObject.toJSONString((Object)wfResult);
        logger.info(ap + "\u8c03\u7528generateRedVerifyRecord\u7684\u8fd4\u56de\u7ed3\u679c" + result);
        apRedWfRecordResultList.add(wfResult);
        this.getCaLogVo().addWfBackParams(apRedWfRecordResults, wfResult);
    }

    private Map<String, Object> buildCaWfRecordParam(String billType, DynamicObject caBilled) {
        HashMap<String, Object> detail = new HashMap<String, Object>(16);
        CaModelField caModelField = this.caPageVo.getModelField().getCaModelField(billType);
        detail.put("writtenoffremark", this.caPageVo.getReason());
        detail.put("writtenoffsourcebillid", caBilled.getPkValue());
        detail.put("writtenoffbizdate", this.caPageVo.getCaDate());
        detail.put("writtenoffbookdate", this.caPageVo.getBookDate());
        ArrayList<Long> settleorgs = new ArrayList<Long>(12);
        DynamicObjectCollection billentry = caBilled.getDynamicObjectCollection(caModelField.getBillEntry());
        for (DynamicObject entry : billentry) {
            DynamicObject settleOrg = entry.getDynamicObject("entrysettleorg");
            settleorgs.add((Long)settleOrg.getPkValue());
        }
        detail.put("writtenofforgids", settleorgs);
        return detail;
    }

    public void removeAllReserveByBill() {
        DynamicObject caBill = this.getCaPageVo().getCaBill();
        String entityKey = caBill.getDataEntityType().getName();
        Object id = caBill.getPkValue();
        logger.info("\u91ca\u653e\u9884\u7559\u8bb0\u5f55,\u5355\u636e:{},billid:{}", (Object)entityKey, id);
        OperationResult operationResult = (OperationResult)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"removeAllReserveByBill", (Object[])new Object[]{entityKey, Collections.singleton(id)});
        if (!operationResult.isSuccess()) {
            logger.info("\u9884\u7559\u91ca\u653e\u5931\u8d25\uff1a{}", (Object)operationResult.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u51b2\u9500\u91ca\u653e\u9884\u7559\u8bb0\u5f55\u5931\u8d25\u3002", (String)"RemoteServiceHandle_1", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }

    private void srmSync(DynamicObject caBill) {
        Map<String, Object> srmSyncData = this.buildSrmSyncData(caBill, BIZ_DIRECTION_BACK);
        if (srmSyncData != null) {
            srmSyncData.put("type", BIZ_DIRECTION_BACK);
            logger.info("\u8c03\u7528\u534f\u540csrm\u63a5\u53e3,\u53c2\u6570\u4e3a:" + JSONObject.toJSONString(srmSyncData));
            Object[] srmSyncDatas = new Object[]{srmSyncData};
            Object o = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"updatePurWriteOffStatus", (Object[])srmSyncDatas);
            logger.info("\u8fd4\u56de\u7ed3\u679c:" + o.toString());
        }
    }

    private void caBillRedBlueWf(Map<String, List<RedBlueWfVo>> redBlueBills) {
        this.sleepTime(redBlueBills);
        for (Map.Entry<String, List<RedBlueWfVo>> redBlueBill : redBlueBills.entrySet()) {
            String billKey = redBlueBill.getKey();
            List<RedBlueWfVo> blueWfVoList = redBlueBill.getValue();
            if ("im_purinbill".equals(billKey) || "im_purreceivebill".equals(billKey)) {
                this.writtenOffVerify(billKey, blueWfVoList, "ap", "ApWrittenOffVerifyService", this.apWfResults, "apWfResults");
                continue;
            }
            if (!"im_saloutbill".equals(billKey)) continue;
            this.writtenOffVerify(billKey, blueWfVoList, "ar", "ArWrittenOffVerifyService", this.arWfResults, "arWfResults");
        }
    }

    private void sleepTime(Map<String, List<RedBlueWfVo>> redBlueBills) {
        Set<String> billTypeSet = redBlueBills.keySet();
        if (billTypeSet.contains("im_purinbill") || billTypeSet.contains("im_purreceivebill") || billTypeSet.contains("im_saloutbill")) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void writtenOffVerify(String billType, List<RedBlueWfVo> blueWfVoList, String ap, String apWrittenOffVerifyService, List<Map<String, Object>> apWfResultList, String apWfResults) {
        for (RedBlueWfVo vo : blueWfVoList) {
            this.doWfService(billType, ap, apWrittenOffVerifyService, apWfResultList, apWfResults, vo);
        }
    }

    private void doWfService(String billType, String ap, String apWrittenOffVerifyService, List<Map<String, Object>> apWfResultList, String apWfResults, RedBlueWfVo vo) {
        Map<String, Object> verifyParam = this.buildWfParam(ap, vo);
        Map wfResult = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)ap, (String)apWrittenOffVerifyService, (String)"writtenOffVerify", (Object[])new Object[]{verifyParam, billType});
        String result = JSONObject.toJSONString((Object)wfResult);
        logger.info(ap + "\u8c03\u7528writtenOffVerify\u7684\u8fd4\u56de\u7ed3\u679c:" + result);
        apWfResultList.add(wfResult);
        this.getCaLogVo().addWfBackParams(apWfResults, wfResult);
    }

    private void checkVerifyRecord(DynamicObject dataEntity) {
        String billNumber = dataEntity.getDataEntityType().getName();
        QFilter emptyQfilter = new QFilter("writeofftypeid", ">", (Object)0);
        if ("im_saloutbill".equals(billNumber)) {
            QFilter qFilter = new QFilter("billid", "=", dataEntity.getPkValue());
            qFilter.and("billtype", "=", (Object)billNumber);
            QFilter qFilterTwo = new QFilter("entry.e_billid", "=", dataEntity.getPkValue());
            qFilterTwo.and("entry.e_billtype", "=", (Object)billNumber);
            qFilter.or(qFilterTwo);
            qFilter.and(emptyQfilter);
            List list = QueryServiceHelper.queryPrimaryKeys((String)"cal_salwfrecord", (QFilter[])qFilter.toArray(), null, (int)-1);
        } else if ("im_purinbill".equals(billNumber)) {
            QFilter qFilter = new QFilter("billid", "=", dataEntity.getPkValue());
            qFilter.and("billtype", "=", (Object)billNumber);
            QFilter qFilterTwo = new QFilter("entry.e_billid", "=", dataEntity.getPkValue());
            qFilterTwo.and("entry.e_billtype", "=", (Object)billNumber);
            qFilter.or(qFilterTwo);
            qFilter.and(emptyQfilter);
            boolean isArVerifyrecord = QueryServiceHelper.exists((String)"cal_purwfrecord", (QFilter[])qFilter.toArray());
            if (isArVerifyrecord) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u636e%s\u6709\u6838\u9500\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_7", (String)"bos-ext-scmc", (Object[])new Object[0]), CommonUtil.getBillNo(dataEntity)));
            }
        }
    }

    private Map<String, Object> buildWfParam(String ap, RedBlueWfVo vo) {
        HashMap<String, Object> verifyParam = new HashMap<String, Object>(4);
        verifyParam.put("writtenoffsourcebillid", vo.getCaBilled().getPkValue());
        verifyParam.put("writtenoffbillid", vo.getCabill().getPkValue());
        verifyParam.put("writtenoffremark", this.caPageVo.getReason());
        DynamicObject invscheme = vo.getCaBilled().getDynamicObject("invscheme");
        boolean flag = BIZ_DIRECTION_BACK.equals(invscheme.getString("bizdirection"));
        verifyParam.put("isreturnbill", flag);
        logger.info(ap + "\u8c03\u7528writtenOffVerify\u7684\u8bf7\u6c42\u53c2\u6570:" + verifyParam);
        return verifyParam;
    }

    private Map<String, Object> buildSrmSyncData(DynamicObject dataEntity, String type) {
        HashMap<String, Object> retrunData = new HashMap<String, Object>(16);
        String billNumber = dataEntity.getDataEntityType().getName();
        Long pkValue = (Long)dataEntity.getPkValue();
        retrunData.put("type", type);
        HashMap dataMap = new HashMap(16);
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)billNumber, (Long[])new Long[]{pkValue});
        if (CollectionUtils.isEmpty((Map)dirtTargetBills)) {
            return null;
        }
        List bfRows = (List)dirtTargetBills.get(pkValue);
        HashSet<Long> hashSet = new HashSet<Long>(16);
        hashSet.add(pkValue);
        if (bfRows != null) {
            Iterator iterator = bfRows.iterator();
            while (iterator.hasNext()) {
                ConvertDataService reader = new ConvertDataService();
                BFRow row = (BFRow)iterator.next();
                BFRowId tid = row.getId();
                Long mainTableId = tid.getMainTableId();
                TableDefine tableDefine = reader.loadTableDefine(mainTableId);
                String entityNumber = tableDefine.getEntityNumber();
                if ("pur_instock".equals(entityNumber)) {
                    dataMap.put("pur_instock", hashSet);
                    continue;
                }
                if ("pur_return".equals(entityNumber)) {
                    dataMap.put("pur_return", hashSet);
                    continue;
                }
                if ("pur_receipt".equals(entityNumber)) {
                    dataMap.put("pur_receipt", hashSet);
                    continue;
                }
                if ("pur_receipt_return".equals(entityNumber)) {
                    dataMap.put("pur_receipt_return", hashSet);
                    continue;
                }
                if (!"pur_moduledelivery".equals(entityNumber)) continue;
                dataMap.put("pur_moduledelivery", hashSet);
            }
        }
        if (dataMap.isEmpty()) {
            return null;
        }
        retrunData.put("dataMap", dataMap);
        return retrunData;
    }

    public void rollBackInterface() {
        CommonUtil.rollbackWfRecord(this.getApWfResults(), "ap", "writtenOffVerifyRollBack");
        CommonUtil.rollbackWfRecord(this.getApRedWfRecordResults(), "ap", "redVerifyRecordRollBack");
        CommonUtil.rollbackWfRecord(this.getArWfResults(), "ar", "writtenOffVerifyRollBack");
        CommonUtil.rollbackWfRecord(this.getArRedWfRecordResults(), "ar", "redVerifyRecordRollBack");
        String billType = this.caPageVo.getCaBill().getDataEntityType().getName();
        CommonUtil.removeAllReserveByBillRollBack(billType, (Long)this.caPageVo.getCaBill().getPkValue());
        Map<String, Object> srmSyncData = CommonUtil.buildSrmSyncData(billType, this.caPageVo.getCaBill().getPkValue(), BIZ_DIRECTION_BACK);
        if (srmSyncData != null) {
            srmSyncData.put("type", "0");
            logger.info("\u8c03\u7528\u534f\u540csrm\u63a5\u53e3,\u53c2\u6570\u4e3a:" + JSONObject.toJSONString(srmSyncData));
            Object o = DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IBillGenericService", (String)"updatePurWriteOffStatus", (Object[])new Object[]{srmSyncData});
            logger.info("\u8c03\u7528\u534f\u540csrm\u63a5\u53e3\u8fd4\u56de\u7684\u6570\u636e\u4e3a:" + JSONObject.toJSONString((Object)o));
            logger.info("\u56de\u6eda\u540c\u6b65\u534f\u540c\u51b2\u9500\u5355\u636e\u6210\u529f");
        }
        BizGroupRecordHelper.setBizGroupCompletedRollBack(this.caPageVo.getCaBill().getLong("id"));
    }

    public CaPageVo getCaPageVo() {
        return this.caPageVo;
    }

    private void setCaPageVo(CaPageVo caPageVo) {
        this.caPageVo = caPageVo;
    }

    private CaLogVo getCaLogVo() {
        return this.caLogService.getCaLogVo();
    }

    public List<Map<String, Object>> getArRedWfRecordResults() {
        return this.arRedWfRecordResults;
    }

    public void setArRedWfRecordResults(List<Map<String, Object>> arRedWfRecordResults) {
        this.arRedWfRecordResults = arRedWfRecordResults;
    }

    public List<Map<String, Object>> getApRedWfRecordResults() {
        return this.apRedWfRecordResults;
    }

    public void setApRedWfRecordResults(List<Map<String, Object>> apRedWfRecordResults) {
        this.apRedWfRecordResults = apRedWfRecordResults;
    }

    public List<Map<String, Object>> getArWfResults() {
        return this.arWfResults;
    }

    public void setArWfResults(List<Map<String, Object>> arWfResults) {
        this.arWfResults = arWfResults;
    }

    public List<Map<String, Object>> getApWfResults() {
        return this.apWfResults;
    }

    public void setApWfResults(List<Map<String, Object>> apWfResults) {
        this.apWfResults = apWfResults;
    }

    public CaLogService getCaLogService() {
        return this.caLogService;
    }

    private void setCaLogService(CaLogService caLogService) {
        this.caLogService = caLogService;
    }
}

