/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.log;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.scmc.chargeagainst.consts.BillOpEnum;
import kd.bos.ext.scmc.chargeagainst.log.LogEntry;
import kd.bos.orm.util.CollectionUtils;

public class CaLogVo {
    private static final int MAX_LENTH = 2000;
    private Object caSourceId;
    private String caSourceBillno;
    private String castatus;
    private Object caSourceType;
    private String traceId;
    private String caBillFailcause = "";
    private Date createDate;
    private Object creator;
    private Object pk;
    private Map<String, List<Map<String, Object>>> rollbackParams;
    private List<LogEntry> logEntries = new ArrayList<LogEntry>(12);

    public void addWfBackParams(String param, Map<String, Object> result) {
        if (this.rollbackParams == null) {
            this.rollbackParams = new HashMap<String, List<Map<String, Object>>>(16);
            this.dealWfParamData(param, result);
        } else {
            this.dealWfParamData(param, result);
        }
    }

    public void setGenerateBillEntry(String billType, Set<Object> successPkIds, String errorMessage) {
        List<LogEntry> list = this.getLogEntries();
        for (LogEntry entry : list) {
            boolean hasErrorPk = CollectionUtils.isEmpty(successPkIds) || !successPkIds.contains(entry.getCagenerBill().getPkValue()) && billType.equals(entry.getSourceType());
            if (!hasErrorPk || errorMessage == null) continue;
            entry.setFailMessage(errorMessage);
        }
    }

    public void setGenerateBillEntry(List<DynamicObject> generateBills, BillOpEnum op) {
        if (CollectionUtils.isEmpty(generateBills)) {
            return;
        }
        Set pks = generateBills.stream().map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        String billType = generateBills.get(0).getDataEntityType().getName();
        List<LogEntry> list = this.getLogEntries();
        for (LogEntry entry : list) {
            if (!pks.contains(entry.getCagenerBill().getPkValue()) || !billType.equals(entry.getSourceType())) continue;
            switch (op) {
                case SAVE: {
                    entry.setGeneratStatus("1");
                    break;
                }
                case SUBMIT: {
                    entry.setGeneratStatus("2");
                    break;
                }
                case AUDIT: {
                    entry.setGeneratStatus("3");
                    break;
                }
                case DELETE: {
                    entry.setGeneratStatus("4");
                    break;
                }
            }
        }
    }

    public void setGenerateBillEntry(String billType, List<Object> generateBillPks, BillOpEnum op) {
        if (CollectionUtils.isEmpty(generateBillPks)) {
            return;
        }
        HashSet<Object> pks = new HashSet<Object>(generateBillPks);
        List<LogEntry> list = this.getLogEntries();
        for (LogEntry entry : list) {
            if (!pks.contains(entry.getCagenerBill().getPkValue()) || !billType.equals(entry.getSourceType())) continue;
            switch (op) {
                case SAVE: {
                    entry.setGeneratStatus("1");
                    break;
                }
                case SUBMIT: {
                    entry.setGeneratStatus("2");
                    break;
                }
                case AUDIT: {
                    entry.setGeneratStatus("3");
                    break;
                }
                case DELETE: {
                    entry.setGeneratStatus("4");
                    break;
                }
                case UNAUDIT: {
                    entry.setGeneratStatus("1");
                    break;
                }
                case UNSUBMIT: {
                    entry.setGeneratStatus("1");
                    break;
                }
            }
        }
    }

    private void dealWfParamData(String param, Map<String, Object> result) {
        List<Map<String, Object>> list = this.rollbackParams.get(param);
        if (list == null) {
            ArrayList<Map<String, Object>> listNew = new ArrayList<Map<String, Object>>();
            listNew.add(result);
            this.rollbackParams.put(param, listNew);
        } else {
            list.add(result);
        }
    }

    public String getWfParamData() {
        String result = JSONObject.toJSONString(this.rollbackParams);
        return result;
    }

    public void setCaBillFailcause(String caBillFailcause) {
        String message = caBillFailcause + this.caBillFailcause;
        if (message.length() > 2000) {
            message = message.substring(0, 1999);
        }
        this.caBillFailcause = message;
    }

    public Object getCaSourceId() {
        return this.caSourceId;
    }

    public void setCaSourceId(Object caSourceId) {
        this.caSourceId = caSourceId;
    }

    public String getCaSourceBillno() {
        return this.caSourceBillno;
    }

    public void setCaSourceBillno(String caSourceBillno) {
        this.caSourceBillno = caSourceBillno;
    }

    public Object getCaSourceType() {
        return this.caSourceType;
    }

    public void setCaSourceType(Object caSourceType) {
        this.caSourceType = caSourceType;
    }

    public String getCaBillFailcause() {
        return this.caBillFailcause;
    }

    public String getCastatus() {
        return this.castatus;
    }

    public void setCastatus(String castatus) {
        this.castatus = castatus;
    }

    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Object getCreator() {
        return this.creator;
    }

    public void setCreator(Object creator) {
        this.creator = creator;
    }

    public List<LogEntry> getLogEntries() {
        return this.logEntries;
    }

    public void setLogEntries(List<LogEntry> logEntries) {
        this.logEntries = logEntries;
    }

    public Object getPk() {
        return this.pk;
    }

    public void setPk(Object pk) {
        this.pk = pk;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }
}

