/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.operation;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.chargeagainst.service.ChargeAgainstService;
import kd.bos.ext.scmc.chargeagainst.service.impl.ChargeAgainstServiceImpl;
import kd.bos.ext.scmc.chargeagainst.valid.ChargeAgainstValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.botp.track.BFTrackerEngine;
import kd.bos.service.botp.track.BFTrackerOpType;
import kd.bos.service.operation.StatusConvertOperateService;

public class ChargeAgainstOp
extends StatusConvertOperateService {
    private static final Log logger = LogFactory.getLog(ChargeAgainstOp.class);
    private BFTrackerEngine trankerEngine;
    private ChargeAgainstService caService;

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        String billStatus = this.statusFieldKey;
        fieldKeys.add(billStatus);
        fieldKeys.add("ischargeoffed");
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
        validators.add(new ChargeAgainstValidator());
    }

    public void initialize(MainEntityType entityType, String operationKey, DynamicObject[] dataEntities) {
        logger.info("ChargeAgainstOp:initialize");
        super.initialize(entityType, operationKey, dataEntities);
        OperateOption option = this.getOption();
        this.trankerEngine = new BFTrackerEngine((IDataEntityType)((BillEntityType)this.billEntityType), BFTrackerOpType.Cancel, this.operateMetaMap, this.getOperationContext(), option);
        this.caService = ChargeAgainstServiceImpl.build(option);
    }

    protected void preparePropertys(Object[] ids, List<String> fieldKeys) {
        logger.info("ChargeAgainstOp:preparePropertys");
        super.preparePropertys(ids, fieldKeys);
        this.trankerEngine.preparePropertys(ids, fieldKeys);
    }

    protected void beforeCallOperationTransaction(DynamicObject[] objs) {
        super.beforeCallOperationTransaction(objs);
        boolean success = this.getOperationResult().isSuccess();
        if (!success) {
            String message = this.getOperationResult().getMessage();
            throw new KDBizException(message);
        }
        this.caService.start();
    }

    protected void afterUpdateBillStatus(DynamicObject[] objs) {
        logger.info("ChargeAgainstOp:afterUpdateBillStatus");
        super.afterUpdateBillStatus(objs);
        this.setBillStatus(objs, "A");
        this.trankerEngine.execute(objs);
        this.trankerEngine.saveBeforeTrans();
    }

    private void setBillStatus(DynamicObject[] objs, String a) {
        for (DynamicObject obj : objs) {
            String billstatusKey = ((BillEntityType)obj.getDataEntityType()).getBillStatus();
            obj.set(billstatusKey, (Object)a);
        }
    }

    protected void executeOperate(DynamicObject[] objs) {
        logger.info("ChargeAgainstOp:executeOperate");
        super.executeOperate(objs);
        this.trankerEngine.saveTrans();
    }

    protected DynamicObject[] callOperation(DynamicObject[] objs) {
        logger.info("ChargeAgainstOp:callOperation");
        this.setBillStatus(objs, "C");
        DynamicObject[] objects = super.callOperation(objs);
        this.trankerEngine.saveAfterTrans();
        return objects;
    }

    protected void callOperationTransaction(DynamicObject[] objs) throws Exception {
        logger.info("ChargeAgainstOp:callOperationTransaction");
        super.callOperationTransaction(objs);
        this.trankerEngine.saveFinally();
    }

    protected void release() {
        logger.info("ChargeAgainstOp:release");
        super.release();
        this.trankerEngine.release();
        this.caService.rollback();
    }

    protected void rollback(DynamicObject[] objs, Exception ex) {
        logger.info("ChargeAgainstOp:rollback");
        super.rollback(objs, ex);
        this.trankerEngine.rollbackSave();
        this.caService.setRollbackStatus(Boolean.TRUE, ex.getMessage());
    }
}

