/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.chargeagainst.valid.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.SCMCLang;
import kd.bos.ext.scmc.chargeagainst.util.CaModelField;
import kd.bos.ext.scmc.chargeagainst.util.CaModelFieldCaChe;
import kd.bos.ext.scmc.chargeagainst.util.CommonUtil;
import kd.bos.ext.scmc.chargeagainst.util.WfRecordHelper;
import kd.bos.ext.scmc.chargeagainst.valid.CaValida;
import kd.bos.ext.scmc.chargeagainst.valid.impl.BillMessageValid;
import kd.bos.ext.scmc.chargeagainst.vo.BFRowBillResult;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class DownBillValid
implements CaValida {
    private Map<String, List<Object>> noValidData = new HashMap<String, List<Object>>(16);
    private BillMessageValid billMessageValid;
    private OperateOption option;
    private CaModelFieldCaChe modelField;
    private static final String IS_VIRTUAL_BILL = "isvirtualbill";
    private static final String AR_VERIFY_RECORD = "ar_verifyrecord";
    private static final String AR_REVCFMBILL = "ar_revcfmbill";
    private static final String AR_FINARBILL = "ar_finarbill";
    private static final String AP_VERIFYRECORD = "ap_verifyrecord";
    private Map<String, List<DynamicObject>> downVirtBillMap = new HashMap<String, List<DynamicObject>>(16);
    private ConvertDataService reader = new ConvertDataService();
    private static final String IM_CHARGEAGAINST_CHK = "im_chargeagainst_chk";

    public static DownBillValid build(OperateOption option, CaModelFieldCaChe modelField, BillMessageValid billMessageValid) {
        DownBillValid valid = new DownBillValid();
        valid.setOption(option);
        valid.setModelField(modelField);
        valid.setBillMessageValid(billMessageValid);
        valid.init();
        return valid;
    }

    private void init() {
        QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        Map noValids = BusinessDataServiceHelper.loadFromCache((String)IM_CHARGEAGAINST_CHK, (String)"srcbill,tagbill", (QFilter[])qFilter.toArray());
        for (DynamicObject valid : noValids.values()) {
            String srcBill = valid.getDynamicObject("srcbill").getString("number");
            String tagBill = valid.getDynamicObject("tagbill").getString("number");
            List<Object> tagList = this.noValidData.get(srcBill);
            if (tagList == null) {
                tagList = new ArrayList<Object>(16);
            }
            tagList.add(tagBill);
            this.noValidData.put(srcBill, tagList);
        }
    }

    @Override
    public void validate(List<DynamicObject> dataEntityList) {
        this.batchDownBillCheck(dataEntityList);
        this.downVirtCheck();
        this.wfBusinessCheck();
    }

    private void wfBusinessCheck() {
        ArrayList<String> pks = new ArrayList<String>(8);
        for (Map.Entry<String, List<DynamicObject>> downVirts : this.downVirtBillMap.entrySet()) {
            List<DynamicObject> values = downVirts.getValue();
            for (DynamicObject ob : values) {
                pks.add(String.valueOf(ob.getPkValue()));
            }
        }
        boolean result = QueryServiceHelper.exists((String)"wf_execution_tree", (QFilter[])new QFilter("businesskey", "in", pks).toArray());
        if (result) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5728\u6d41\u7a0b\u5b9e\u4f8b\u4e2d\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_20", (String)"bos-ext-scmc", (Object[])new Object[0]));
        }
    }

    private void batchDownBillCheck(List<DynamicObject> dataEntityList) {
        for (DynamicObject dataEntity : dataEntityList) {
            this.checkDownBill(dataEntity);
        }
    }

    private void downVirtCheck() {
        for (Map.Entry<String, List<DynamicObject>> downVirts : this.downVirtBillMap.entrySet()) {
            this.billMessageValid.downBillValidate(downVirts.getValue());
        }
    }

    private void checkDownBill(DynamicObject dataEntity) {
        String billNumber = dataEntity.getDataEntityType().getName();
        Long pkValue = (Long)dataEntity.getPkValue();
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)billNumber, (Long[])new Long[]{pkValue});
        if (CollectionUtils.isEmpty((Map)dirtTargetBills)) {
            return;
        }
        List bfRows = (List)dirtTargetBills.get(pkValue);
        if (bfRows != null) {
            List<DynamicObject> downBillList = this.getDownBill(billNumber, bfRows);
            this.downBillDeal(dataEntity, downBillList);
            this.option.setVariableValue("CA_ISVIRTLIST", JSONObject.toJSONString(this.getCaBillPk()));
            if (!CollectionUtils.isEmpty(downBillList)) {
                throw new KDBizException(SCMCLang.existDownBillNotChargeOff(CommonUtil.getBillNo(dataEntity)));
            }
        }
    }

    private void downBillDeal(DynamicObject dataEntity, List<DynamicObject> downBillList) {
        Set<String> wfRecordBills = WfRecordHelper.checkWfRecordBills(dataEntity, this.modelField);
        Iterator<DynamicObject> iterator1 = downBillList.iterator();
        while (iterator1.hasNext()) {
            DynamicObject bill = iterator1.next();
            String entityNumber = bill.getDataEntityType().getName();
            boolean isExist = CommonUtil.isExistField(bill, IS_VIRTUAL_BILL);
            if (isExist && bill.getBoolean(IS_VIRTUAL_BILL)) {
                this.checkVirtStatus(bill);
                this.addDownBill(bill);
                this.checkDownBill(bill);
                iterator1.remove();
                continue;
            }
            this.checkCaBill(iterator1, wfRecordBills, bill, entityNumber);
        }
    }

    private void addDownBill(DynamicObject bill) {
        String entityName = bill.getDataEntityType().getName();
        List<DynamicObject> downBillList = this.downVirtBillMap.get(entityName);
        if (downBillList == null) {
            downBillList = new ArrayList<DynamicObject>(16);
        }
        downBillList.add(bill);
        this.downVirtBillMap.put(entityName, downBillList);
    }

    private BFRowBillResult getBFRowBillResult(BFRowId tid) {
        Long mainTableId = tid.getMainTableId();
        TableDefine tableDefine = this.reader.loadTableDefine(mainTableId);
        String entityNumber = tableDefine.getEntityNumber();
        Long billId = tid.getBillId();
        return new BFRowBillResult(entityNumber, billId);
    }

    private List<DynamicObject> getDownBill(String billNumber, List<BFRow> bfRows) {
        ArrayList<DynamicObject> downBillList = new ArrayList<DynamicObject>();
        Map<String, List<Long>> downBills = this.getDownBillIdMap(bfRows);
        for (Map.Entry<String, List<Long>> downBill : downBills.entrySet()) {
            List<Object> tags = this.noValidData.get(billNumber);
            String billType = downBill.getKey();
            if (tags != null && tags.contains(billType)) continue;
            Object[] billIds = downBill.getValue().toArray(new Object[downBill.getValue().size()]);
            QFilter qFilter = new QFilter("id", "in", (Object)billIds);
            StringBuilder fields = new StringBuilder();
            fields.append("billentry.entrysettleorg,billtype,billStatus,billno,biztype,asyncstatus,");
            fields.append(this.getModelField().getCaModelField(billType).getIsChargeOffed());
            fields.append(",").append(this.getModelField().getCaModelField(billType).getIsChargeOff());
            fields.append(",").append(this.getModelField().getCaModelField(billType).getIsVirtualBill());
            DynamicObject[] load = BusinessDataServiceHelper.load((String)billType, (String)fields.toString(), (QFilter[])qFilter.toArray());
            downBillList.addAll(new ArrayList<DynamicObject>(Arrays.asList(load)));
        }
        return downBillList;
    }

    private Map<String, List<Long>> getDownBillIdMap(List<BFRow> bfRows) {
        HashMap<String, List<Long>> downBills = new HashMap<String, List<Long>>(16);
        for (BFRow next : bfRows) {
            BFRowId tid = next.getId();
            BFRowBillResult bfRowBillResult = this.getBFRowBillResult(tid);
            String entityNumber = bfRowBillResult.getEntityNumber();
            Long billId = bfRowBillResult.getBillId();
            ArrayList<Long> bills = (ArrayList<Long>)downBills.get(entityNumber);
            if (bills == null) {
                bills = new ArrayList<Long>();
            }
            bills.add(billId);
            downBills.put(entityNumber, bills);
        }
        return downBills;
    }

    private void checkCaBill(Iterator<DynamicObject> iterator, Set<String> wfRecordBills, DynamicObject bill, String entityNumber) {
        CaModelField caModelField = this.modelField.getCaModelField(entityNumber);
        String isChargeOff = caModelField.getIsChargeOff();
        String isChargeOffed = caModelField.getIsChargeOffed();
        boolean isCaEd = this.getBoolean(bill, isChargeOffed);
        boolean isCa = this.getBoolean(bill, isChargeOff);
        if (isCaEd || isCa) {
            iterator.remove();
            return;
        }
        if (wfRecordBills.contains(entityNumber + "@" + bill.getPkValue())) {
            iterator.remove();
        }
    }

    private boolean getBoolean(DynamicObject bill, String field) {
        if (null == bill) {
            return false;
        }
        BillEntityType mainEntityType = (BillEntityType)bill.getDataEntityType();
        if (mainEntityType.getAllFields().containsKey(field)) {
            return bill.getBoolean(field);
        }
        return false;
    }

    private void checkVirtStatus(DynamicObject bill) {
        String billStatusKey = ((BillEntityType)bill.getDataEntityType()).getBillStatus();
        String billNo = CommonUtil.getBillNo(bill);
        String status = bill.getString(billStatusKey);
        if (!"C".equals(status)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u6e38\u865a\u5355%s\u4e0d\u662f\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u51b2\u9500\u3002", (String)"ChargeAgainstValid_15", (String)"bos-ext-scmc", (Object[])new Object[0]), billNo));
        }
    }

    private Set<String> getWfRecordBills(DynamicObject dataEntity) {
        HashSet<String> wfRecordBills = new HashSet<String>(8);
        String srcEntryName = dataEntity.getDataEntityType().getName();
        if ("im_saloutbill".equals(srcEntryName)) {
            Set<String> arRecords = this.getWfRecordSet(dataEntity, srcEntryName, AR_VERIFY_RECORD);
            wfRecordBills.addAll(arRecords);
            for (String record : arRecords) {
                String[] split = record.split("@");
                String billType = split[0];
                if (!AR_REVCFMBILL.equals(billType)) continue;
                this.arRevcfmWfRecordDeal(wfRecordBills, split[1], billType);
            }
        } else if ("im_purinbill".equals(srcEntryName) || "im_purreceivebill".equals(srcEntryName)) {
            Set<String> arRecords = this.getWfRecordSet(dataEntity, srcEntryName, AP_VERIFYRECORD);
            wfRecordBills.addAll(arRecords);
        }
        return wfRecordBills;
    }

    private void arRevcfmWfRecordDeal(Set<String> wfRecordBills, String pk, String billType) {
        Long billId = Long.parseLong(pk);
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtSourceBills((String)billType, (Long[])new Long[]{billId});
        List bfRows = (List)dirtTargetBills.get(billId);
        for (BFRow next : bfRows) {
            BFRowId tid = next.getSId();
            BFRowBillResult bfRowBillResult = this.getBFRowBillResult(tid);
            String entityNumber = bfRowBillResult.getEntityNumber();
            if (!AR_FINARBILL.equals(entityNumber)) continue;
            wfRecordBills.add(entityNumber + "@" + tid.getBillId());
        }
    }

    private Set<String> getWfRecordSet(DynamicObject dataEntity, String billType, String WfRecordTable) {
        CaModelField caModelField = this.modelField.getCaModelField(billType);
        ArrayList<Long> settleorgs = new ArrayList<Long>(12);
        DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection(caModelField.getBillEntry());
        for (DynamicObject entry : billentry) {
            DynamicObject settleOrg = entry.getDynamicObject("entrysettleorg");
            settleorgs.add((Long)settleOrg.getPkValue());
        }
        HashSet<String> wfRecordBills = new HashSet<String>(8);
        QFilter qFilter = new QFilter("org", "in", settleorgs);
        qFilter.and("billid", "=", dataEntity.getPkValue());
        qFilter.and("billtype", "=", (Object)billType);
        DynamicObjectCollection wfRecordList = QueryServiceHelper.query((String)WfRecordTable, (String)"billid,billtype,entry.e_billid,entry.e_billtype,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])qFilter.toArray());
        this.getWfRecord(wfRecordBills, wfRecordList);
        QFilter qFilterNew = new QFilter("org", "in", settleorgs);
        qFilterNew.and("entry.e_billid", "=", dataEntity.getPkValue());
        qFilterNew.and("entry.e_billtype", "=", (Object)billType);
        DynamicObjectCollection wfRecordTwoList = QueryServiceHelper.query((String)WfRecordTable, (String)"billid,billtype,entry.e_billid,entry.e_billtype,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])qFilter.toArray());
        this.getWfRecord(wfRecordBills, wfRecordTwoList);
        return wfRecordBills;
    }

    private void getWfRecord(Set<String> wfRecordBills, DynamicObjectCollection wfRecordList) {
        for (DynamicObject wfRecord : wfRecordList) {
            boolean entryIsWriteOff = wfRecord.getBoolean("entry.e_iswrittenoff");
            if (entryIsWriteOff) continue;
            String reBillIdType = wfRecord.getString("billtype");
            String reBillId = wfRecord.getString("billid");
            wfRecordBills.add(reBillIdType + "@" + reBillId);
            String entryBillId = wfRecord.getString("entry.e_billid");
            String entryBillIdType = wfRecord.getString("entry.e_billtype");
            boolean entryHadWriteOff = wfRecord.getBoolean("entry.e_hadwrittenoff");
            wfRecordBills.add(entryBillIdType + "@" + entryBillId);
            if (entryHadWriteOff) continue;
            wfRecordBills.add("false");
        }
    }

    private Map<String, List<Object>> getCaBillPk() {
        HashMap<String, List<Object>> downVirtPkMap = new HashMap<String, List<Object>>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : this.downVirtBillMap.entrySet()) {
            List<DynamicObject> value = entry.getValue();
            if (value == null) continue;
            List pks = value.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList());
            downVirtPkMap.put(entry.getKey(), pks);
        }
        return downVirtPkMap;
    }

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public CaModelFieldCaChe getModelField() {
        return this.modelField;
    }

    private void setModelField(CaModelFieldCaChe modelField) {
        this.modelField = modelField;
    }

    private void setBillMessageValid(BillMessageValid billMessageValid) {
        this.billMessageValid = billMessageValid;
    }

    public CaValida getBillMessageValid() {
        return this.billMessageValid;
    }
}

