/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.creditcontrol.operation.bizrule;

import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.scmc.validation.CheckCreditValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public class CheckCreditOpAction
extends AbstractOpBizRuleAction {
    private static Log logger = LogFactory.getLog(CheckCreditOpAction.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        Set<String> creditEntityConfigField = CheckCreditOpAction.getSelectors(this.billEntityType.getName());
        e.getFieldKeys().addAll(creditEntityConfigField);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        for (AbstractValidator validator : e.getValidators()) {
            if (!(validator instanceof kd.bos.ext.scmc.creditcontrol.operation.validation.CheckCreditValidator) && !(validator instanceof CheckCreditValidator)) continue;
            return;
        }
        String checkExtClassName = this.getExtCheckHandlerName();
        if (StringUtils.isNotEmpty((CharSequence)checkExtClassName)) {
            e.addValidator((AbstractValidator)new CheckCreditValidator());
        } else {
            e.addValidator((AbstractValidator)new kd.bos.ext.scmc.creditcontrol.operation.validation.CheckCreditValidator());
        }
    }

    private static Set<String> getSelectors(String entityKey) {
        Set selectorFieldSet = (Set)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ccm", (String)"CreditService", (String)"getCreditEntityConfigField", (Object[])new Object[]{entityKey});
        return selectorFieldSet;
    }

    private String getExtCheckHandlerName() {
        String className = (String)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"ccm", (String)"CreditService", (String)"getExtCheckHandlerName", (Object[])new Object[0]);
        return className;
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ccm_credit_archive");
        String uniqueKey = RequestContext.get().getTenantId() + RequestContext.get().getTraceId();
        cache.remove(uniqueKey);
    }
}

