/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.iscc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;

public class IsccRecordQuery
extends FormOperate {
    private static final String PM_PURORDERBILL = "pm_purorderbill";
    private static final String SM_SALORDER = "sm_salorder";
    private static final String ISCC_COLLABORARECORD = "iscc_collaborarecord";
    private static final String ISCC_RECORD_RPT = "iscc_record_rpt";

    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
    }

    public OperationResult invokeOperation() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        List<Object> billIds = null;
        String billName = null;
        if (view instanceof IListView) {
            ListSelectedRowCollection listSelectedData = this.getListSelectedData();
            if (CollectionUtils.isEmpty((Collection)listSelectedData)) {
                String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u67e5\u8be2\u3002", (String)"QueryCreditBalanceOp_0", (String)"bos-ext-scmc", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            billIds = listSelectedData.stream().map(item -> (Long)item.getPrimaryKeyValue()).distinct().collect(Collectors.toList());
            billName = ((IListView)this.getView()).getBillFormId();
        } else {
            billIds = new ArrayList<Long>();
            billIds.add((Long)model.getDataEntity().getPkValue());
            billName = this.getView().getModel().getDataEntityType().getName();
        }
        ArrayList<Long> mainBillIds = new ArrayList<Long>(billIds.size());
        String mainBillEntity = null;
        QFilter qFilter = new QFilter("billentity", "=", (Object)billName);
        qFilter.and(new QFilter("billid", "in", billIds));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getIsccRecord", (String)ISCC_COLLABORARECORD, (String)"mainbillentity,mainbillid", (QFilter[])qFilter.toArray(), (String)"id");
        for (Row row : dataSet) {
            mainBillIds.add(row.getLong("mainbillid"));
            if (!StringUtils.isEmpty(mainBillEntity)) continue;
            mainBillEntity = row.getString("mainBillEntity");
        }
        if (StringUtils.isNotEmpty(mainBillEntity) && CollectionUtils.isNotEmpty(mainBillIds)) {
            this.showRptForm(mainBillEntity, mainBillIds);
        } else {
            this.showRptForm(billName, billIds);
        }
        return super.invokeOperation();
    }

    private void showRptForm(String billName, List<Long> billIds) {
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        if (PM_PURORDERBILL.equals(billName)) {
            param.put("purQuery", true);
        }
        if (SM_SALORDER.equals(billName)) {
            param.put("salQuery", true);
        }
        param.put("billIds", billIds);
        ReportShowParameter rsp = new ReportShowParameter();
        rsp.setFormId(ISCC_RECORD_RPT);
        rsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        rsp.setCustomParam(ReportShowParameter.class.getName(), (Object)SerializationUtils.toJsonString(param));
        this.getView().showForm((FormShowParameter)rsp);
    }
}

