/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.scmc.paramentity.bizrule.reserve.consts.ReservationEnum;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class ReserveQuery
extends FormOperate {
    private Map<String, Object> mapParam;

    public void initialize(Map<String, Object> arg0) {
        super.initialize(arg0);
        Map paramObj = (Map)arg0.get("parameter");
        if (paramObj == null) {
            return;
        }
        String paramValue = (String)paramObj.get("parameter");
        this.mapParam = StringUtils.isBlank((CharSequence)paramValue) ? new HashMap<String, Object>() : (Map)SerializationUtils.fromJsonString((String)paramValue, Map.class);
    }

    public OperationResult invokeOperation() {
        String billName = null;
        QFilter fs = null;
        long billId = 0L;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        if (view instanceof IListView) {
            ListSelectedRowCollection listSelectedData = this.getListSelectedData();
            Object[] pks = listSelectedData.getPrimaryKeyValues();
            if (pks.length < 1) {
                String message = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u8bb0\u5f55\u8fdb\u884c\u67e5\u8be2\u3002", (String)"QueryCreditBalanceOp_0", (String)"bos-ext-scmc", (Object[])new Object[0]);
                throw new KDBizException(message);
            }
            Object pk = pks[0];
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pk, (String)this.getEntityId());
            billName = bill.getDataEntityType().getName();
            Long[] billIdArray = new Long[pks.length];
            for (int i = 0; i < billIdArray.length; ++i) {
                billIdArray[i] = Long.parseLong(String.valueOf(pks[i]));
            }
            Set<Object> billIds = this.getBOTPLinkBillIds(billName, billIdArray);
            QFilter billIdFilter = new QFilter("bill_id", "in", billIds);
            QFilter balIdFilter = new QFilter("bal_id", "in", billIds);
            fs = balIdFilter.or(billIdFilter);
        } else {
            billId = Long.parseLong(model.getDataEntity().getPkValue().toString());
            billName = this.getView().getFormShowParameter().getFormId();
            Long[] entryIds = null;
            String entryKey = null;
            try {
                entryKey = String.valueOf(this.mapParam.get(ReservationEnum.KEY_ENTRYFILED.getFiled()));
                DynamicObjectCollection entryObjCol = model.getEntryEntity(entryKey);
                EntryGrid entryGrid = (EntryGrid)view.getControl(entryKey);
                int[] selectRows = entryGrid.getSelectRows();
                entryIds = new Long[selectRows.length];
                for (int i = 0; i < selectRows.length; ++i) {
                    entryIds[i] = Long.parseLong(((DynamicObject)entryObjCol.get(selectRows[i])).getPkValue().toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            fs = this.getFilter(billName, entryKey, billId, entryIds);
        }
        this.openReserveView(fs);
        return super.invokeOperation();
    }

    private void openReserveView(QFilter fs) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        showParameter.setBillFormId("msmod_reserve_record");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.getListFilterParameter().setFilter(fs);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private QFilter getFilter(String formId, String entryKey, long billId, Long[] entryIds) {
        Set<Object> billIds = this.getBOTPLinkBillIds(formId, new Long[]{billId});
        QFilter billIdFilter = new QFilter("bill_id", "in", billIds);
        QFilter balIdFilter = new QFilter("bal_id", "=", (Object)billId);
        List<Object> allEntryId = new ArrayList(16);
        if (entryIds != null && entryIds.length > 0) {
            allEntryId = this.getBOTPLinkEntryIds(formId, entryKey, entryIds);
        }
        if (allEntryId.size() == 0) {
            return billIdFilter.or(balIdFilter);
        }
        QFilter filter = billIdFilter.and("billentry_id", "in", allEntryId);
        balIdFilter = balIdFilter.and("bal_entryid", "in", (Object)entryIds);
        return filter.or(balIdFilter);
    }

    private Set<Object> getBOTPLinkBillIds(String billName, Long[] billIdArray) {
        HashSet<Object> ids = new HashSet<Object>(16);
        Map srcBills = BFTrackerServiceHelper.findSourceBills((String)billName, (Long[])billIdArray);
        for (HashSet srcId : srcBills.values()) {
            ids.addAll(srcId);
        }
        ids.addAll(Arrays.asList(billIdArray));
        return ids;
    }

    private List<Long> getBOTPLinkEntryIds(String entityNumber, String entryKey, Long[] entryIds) {
        ArrayList<Long> allEntryIds = new ArrayList<Long>(16);
        List rows = BFTrackerServiceHelper.loadLinkUpNodes((String)entityNumber, (String)entryKey, (Long[])entryIds);
        for (BFRowLinkUpNode row : rows) {
            List nodes = row.findAllSourceNodes();
            for (BFRowLinkUpNode node : nodes) {
                allEntryIds.add(node.getRowId().getEntryId());
            }
        }
        allEntryIds.addAll(Arrays.asList(entryIds));
        return allEntryIds;
    }
}

