/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.scmc.SCMCLang;
import kd.bos.ext.scmc.paramentity.bizrule.SnParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class SaveSnOpValidarot
extends AbstractValidator {
    private SnParameter parameter;

    public SaveSnOpValidarot() {
    }

    public SaveSnOpValidarot(SnParameter parameter) {
        this.parameter = parameter;
    }

    public void validate() {
        DynamicObject dataEntity = null;
        Map<String, String> mapping = this.buildPropMapping(this.parameter.getSnFields());
        HashSet<String> snMainNums = new HashSet<String>(12);
        HashSet<Object> billPks = new HashSet<Object>(12);
        for (ExtendedDataEntity entity : this.dataEntities) {
            dataEntity = entity.getDataEntity();
            billPks.add(dataEntity.getPkValue());
            for (DynamicObject main : dataEntity.getDynamicObjectCollection(this.parameter.getMainEntryKey())) {
                DynamicObject mat = main.getDynamicObject(this.parameter.getMaterial());
                if (mat == null || !mat.getBoolean("enableserial")) continue;
                int index = 0;
                for (DynamicObject snRow : main.getDynamicObjectCollection(this.parameter.getSnEntryKey())) {
                    String snNum = snRow.getString(this.parameter.getSn());
                    ++index;
                    if (snNum == null || StringUtils.isEmpty((CharSequence)snNum.trim())) {
                        this.addMessage(entity, SCMCLang.entryToSerialNumberIsNull(main.getInt("seq"), mat.getString("masterid.number"), index));
                        continue;
                    }
                    snMainNums.add(snNum.trim());
                    snRow.set(this.parameter.getSn(), (Object)snNum.trim());
                }
            }
        }
        if (snMainNums.size() < 1) {
            return;
        }
        QFilter filter = new QFilter("number", "in", (Object)snMainNums.toArray());
        DynamicObjectCollection mainFiles = QueryServiceHelper.query((String)"bd_snmainfile", (String)"id,number,material,snstatus", (QFilter[])new QFilter[]{filter});
        filter = new QFilter("billid", "in", (Object)billPks.toArray());
        DynamicObjectCollection moveTracks = QueryServiceHelper.query((String)"bd_snmovetrack", (String)"id,snmainfile", (QFilter[])new QFilter[]{filter});
        HashSet snPks = new HashSet();
        moveTracks.forEach(p -> snPks.add(p.get("snmainfile")));
        HashMap<String, String> propStatusMap = new HashMap<String, String>();
        HashMap<String, Object> propPkMap = new HashMap<String, Object>();
        if (mainFiles == null || mainFiles.size() < 1) {
            return;
        }
        String key = "";
        for (DynamicObject main : mainFiles) {
            key = main.getString("number") + main.getLong("material");
            propStatusMap.put(key, main.getString("snstatus"));
            propPkMap.put(key, main.get("id"));
        }
        String snState = "";
        StringBuilder sb = new StringBuilder();
        for (ExtendedDataEntity entity : this.dataEntities) {
            dataEntity = entity.getDataEntity();
            List<Object> hasPks = this.filterSnPks(dataEntity);
            for (DynamicObject main : dataEntity.getDynamicObjectCollection(this.parameter.getMainEntryKey())) {
                if (!main.getDynamicObject(this.parameter.getMaterial()).getBoolean("enableserial")) continue;
                int index = 0;
                for (DynamicObject snRow : main.getDynamicObjectCollection(this.parameter.getSnEntryKey())) {
                    sb.setLength(0);
                    key = snRow.getString(this.parameter.getSn()) + main.getLong(this.parameter.getMaterial() + ".masterid_id");
                    snState = (String)propStatusMap.get(key);
                    if (snState == null || snPks.contains(propPkMap.get(key))) continue;
                    sb.append(SCMCLang.entryToSerialNumber(main.get("seq"), ++index));
                    sb.append(snRow.getString(this.parameter.getSn()));
                    String msg = "";
                    if (dataEntity.getDataEntityType().getName().equals("im_transinbill")) {
                        if (hasPks.contains(propPkMap.get(key))) continue;
                        msg = ResManager.loadKDString((String)"\u72b6\u6001\u4e0d\u7b26\u5408\u8981\u6c42\uff0c", (String)"SaveSnOpValidarot_7", (String)"bos-ext-scmc", (Object[])new Object[0]);
                    } else {
                        switch (snState) {
                            case "A": 
                            case "C": {
                                msg = ResManager.loadKDString((String)"\u5df2\u7ecf\u88ab\u5176\u4ed6\u5355\u636e\u4f7f\u7528\uff0c", (String)"SaveSnOpValidarot_8", (String)"bos-ext-scmc", (Object[])new Object[0]);
                                break;
                            }
                            case "B": {
                                break;
                            }
                            case "D": {
                                break;
                            }
                        }
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)msg)) continue;
                    sb.append(msg);
                    sb.append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4f7f\u7528", (String)"SaveSnOpValidarot_9", (String)"bos-ext-scmc", (Object[])new Object[0]));
                    this.addMessage(entity, sb.toString());
                }
            }
        }
    }

    private boolean isException(DynamicObject entity) {
        return entity.getDataEntityType().getName().equals("im_transinbill") || entity.getDataEntityType().getName().equals("im_transoutbill");
    }

    private List<Object> filterSnPks(DynamicObject entity) {
        long srcbillid;
        DynamicObject srcEntity;
        DynamicObjectCollection entry = entity.getDynamicObjectCollection(this.parameter.getMainEntryKey());
        if (entry == null || entry.size() < 1) {
            return new ArrayList<Object>();
        }
        DynamicObject main = (DynamicObject)entry.get(0);
        ArrayList<Object> pks = new ArrayList<Object>();
        if ("im_transinbill".equals(entity.getDataEntityType().getName()) && (srcEntity = BusinessDataServiceHelper.loadSingle((Object)(srcbillid = main.getLong("srcbillid")), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"im_transoutbill"))) != null) {
            long snPk;
            for (DynamicObject srow : srcEntity.getDynamicObjectCollection(this.parameter.getMainEntryKey())) {
                for (DynamicObject snrow : srow.getDynamicObjectCollection(this.parameter.getSnEntryKey())) {
                    snPk = snrow.getLong("serialid_id");
                    if (0L == snPk) continue;
                    pks.add(snPk);
                }
            }
            if (pks.size() > 0) {
                Map des = BFTrackerServiceHelper.findTargetBills((String)"im_transoutbill", (Long[])new Long[]{srcbillid});
                ArrayList desPks = new ArrayList();
                des.values().forEach(a -> desPks.addAll(a));
                desPks.remove(entity.getPkValue());
                if (desPks.size() > 0) {
                    DynamicObject[] doc = BusinessDataServiceHelper.load((Object[])desPks.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"im_transinbill"));
                    ArrayList<Long> desSnPks = new ArrayList<Long>();
                    for (DynamicObject desEntity : doc) {
                        for (DynamicObject srow : desEntity.getDynamicObjectCollection(this.parameter.getMainEntryKey())) {
                            for (DynamicObject snrow : srow.getDynamicObjectCollection(this.parameter.getSnEntryKey())) {
                                snPk = snrow.getLong("serialid_id");
                                if (0L == snPk) continue;
                                desSnPks.add(snPk);
                            }
                        }
                    }
                    pks.removeAll(desSnPks);
                }
            }
        }
        return pks;
    }

    private Map<String, String> buildPropMapping(List<Map<String, Object>> Fields) {
        HashMap<String, String> propMapping = new HashMap<String, String>(16);
        for (Map<String, Object> map : Fields) {
            String billFieldKey = (String)map.get("currentmetadatakey");
            String lotFieldKey = (String)map.get("metadatakey");
            propMapping.put(lotFieldKey, billFieldKey);
        }
        return propMapping;
    }
}

