/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scmc.validation;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class TransferBillValidator
extends AbstractValidator {
    private static final String ENTITY_TRANSDIRBILL = "im_transdirbill";
    private static final String VMI_INVTYPE = "113";
    private static final String BD_SUPPLIER = "bd_supplier";
    private static final String BOS_ORG = "bos_org";

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String entityName = dataEntity.getDataEntityType().getName();
            boolean isVirtualBill = dataEntity.getBoolean("isvirtualbill");
            if (isVirtualBill) continue;
            DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection("billentry");
            boolean isVmiEntry = false;
            for (DynamicObject entry : billEntry) {
                DynamicObject outInvType = entry.getDynamicObject("outinvtype");
                String outOwnerType = entry.getString("outownertype");
                String ownerType = entry.getString("ownertype");
                if (outInvType == null) continue;
                String outInvTypeNum = outInvType.getString("number");
                boolean bl = isVmiEntry = VMI_INVTYPE.equals(outInvTypeNum) && BD_SUPPLIER.equals(outOwnerType);
                if (ENTITY_TRANSDIRBILL.equals(entityName)) {
                    boolean bl2 = isVmiEntry = isVmiEntry && BOS_ORG.equals(ownerType);
                }
                if (!isVmiEntry) continue;
                break;
            }
            if (!isVmiEntry) continue;
            billIds.add(dataEntity.getLong("id"));
        }
        this.getOption().setVariableValue("billIds", SerializationUtils.toJsonString(billIds));
    }
}

