/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.bd.bizuniquecode;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.bd.bizuniquecode.BizUniqueCodeHelper;
import kd.bos.ext.bd.bizuniquecode.BizUniqueCodeMappingHelper;
import kd.bos.ext.bd.entity.property.BizUniqueCodeProp;
import kd.bos.facade.FacadeResult;
import kd.bos.facade.entity.IEntityLifecycleFacade;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.Delete;
import kd.bos.service.operation.Draft;
import kd.bos.service.operation.Submit;
import org.apache.commons.lang3.StringUtils;

public class BizUniqueCodeFacade
implements IEntityLifecycleFacade {
    private static final Log LOG = LogFactory.getLog(BizUniqueCodeFacade.class);

    public FacadeResult beforeExecuteOperate(Map<String, Object> params) {
        long begin = System.currentTimeMillis();
        if (params.isEmpty()) {
            return super.beforeExecuteOperate(params);
        }
        Object owner = params.get("owner");
        Object objs = params.get("objs");
        if (owner == null || !(objs instanceof DynamicObject[])) {
            return super.beforeExecuteOperate(params);
        }
        DynamicObject[] dyns = (DynamicObject[])objs;
        if (dyns.length == 0) {
            return super.beforeExecuteOperate(params);
        }
        String billType = dyns[0].getDataEntityType().getName();
        String dbRouteKey = dyns[0].getDataEntityType().getDBRouteKey();
        String propertyName = BizUniqueCodeFacade.getPropertyName(billType);
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            return super.beforeExecuteOperate(params);
        }
        if (owner instanceof Draft || owner instanceof Submit) {
            if (dyns[0].containsProperty(propertyName)) {
                BizUniqueCodeHelper.saveUniqueCode(dyns, billType, dbRouteKey, propertyName);
            }
        } else if (owner instanceof Delete) {
            int billTypeHash = BizUniqueCodeMappingHelper.getInstance().getMappingTable(new DBRoute(dbRouteKey), billType);
            BizUniqueCodeHelper.deleteUniqueCode(dyns, billType, dbRouteKey, propertyName, billTypeHash);
        }
        LOG.info("BizUniqueCodeFacade.beforeExecuteOperate-\u9632\u91cd\u8017\u65f6\uff1a" + (System.currentTimeMillis() - begin));
        return super.beforeExecuteOperate(params);
    }

    private static String getPropertyName(String billType) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        String propertyName = null;
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof BizUniqueCodeProp)) continue;
            propertyName = property.getName();
            break;
        }
        return propertyName;
    }
}

