/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.occ.portal.plugin;

import com.alibaba.fastjson.JSONObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.OpenPageUtils;
import org.apache.commons.lang3.StringUtils;

public class ExceptionDataCardPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static Log logger = LogFactory.getLog(ExceptionDataCardPlugin.class);
    private static final String SALEORDER_EXNUM = "saleorder_exnum";
    private static final String MAILNO_EXNUM = "mailno_exnum";
    private static final String DELIVERYOUTTIME_EXNUM = "deloveryouttime_exnum";
    private static final String STOCK_EXNUM = "stock_exnum";

    public void registerListener(EventObject event) {
        Label salseOrderLabel = (Label)this.getView().getControl(SALEORDER_EXNUM);
        salseOrderLabel.addClickListener((ClickListener)this);
        Label mailnoLabel = (Label)this.getView().getControl(MAILNO_EXNUM);
        mailnoLabel.addClickListener((ClickListener)this);
        Label deOutTimeLabel = (Label)this.getView().getControl(DELIVERYOUTTIME_EXNUM);
        deOutTimeLabel.addClickListener((ClickListener)this);
        Label stockLabel = (Label)this.getView().getControl(STOCK_EXNUM);
        stockLabel.addClickListener((ClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Label salseOrderLabel = (Label)this.getView().getControl(SALEORDER_EXNUM);
        salseOrderLabel.setText(this.saleOrderExnumCount());
        Label mailnoLabel = (Label)this.getView().getControl(MAILNO_EXNUM);
        mailnoLabel.setText(this.mailnoExnumCount());
        Label deOutTimeLabel = (Label)this.getView().getControl(DELIVERYOUTTIME_EXNUM);
        deOutTimeLabel.setText(this.deliveryOutTimeExnumCount());
        Label stockLabel = (Label)this.getView().getControl(STOCK_EXNUM);
        stockLabel.setText(this.stockExnumCount());
    }

    public void click(EventObject event) {
        super.click(event);
        Control control = (Control)event.getSource();
        String key = control.getKey();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("openType", "MainNewTabPage");
        map.put("view", (String)this.getView());
        map.put("parametertype", "ListShowParameter");
        if (StringUtils.equals((CharSequence)key, (CharSequence)SALEORDER_EXNUM)) {
            LocaleString localeString = new LocaleString();
            localeString.setLocaleValue_zh_CN(ResManager.loadKDString((String)"\u5f02\u5e38\u8ba2\u5355", (String)"ExceptionDataCardPlugin_0", (String)"bos-ext-occ", (Object[])new Object[0]));
            map.put("menuname", (String)localeString);
            map.put("appname", ResManager.loadKDString((String)"\u5f02\u5e38\u8ba2\u5355", (String)"ExceptionDataCardPlugin_0", (String)"bos-ext-occ", (Object[])new Object[0]));
            map.put("appmainnumber", "oeoms_apphome");
            map.put("formnumber", "oeoms_initorderinh");
            JSONObject parameter = new JSONObject();
            String schemeId = this.getSchemeId("oeoms_initorderinh", ResManager.loadKDString((String)"\u5f02\u5e38\u8ba2\u5355", (String)"ExceptionDataCardPlugin_0", (String)"bos-ext-occ", (Object[])new Object[0]));
            if (StringUtils.isBlank((CharSequence)schemeId)) {
                return;
            }
            parameter.put("filterSchemeId", (Object)schemeId);
            map.put("parameter", (String)parameter);
            OpenPageUtils.openAppForCardCount((String)"oeoms", (String)"", map, (IFormView)this.getView());
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)MAILNO_EXNUM)) {
            JSONObject parameter = new JSONObject();
            parameter.put("filterSchemeId", (Object)"");
            map.put("parameter", (String)parameter);
            OpenPageUtils.openAppForCardCount((String)"oeoms", (String)"1112852614280000512", map, (IFormView)this.getView());
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)DELIVERYOUTTIME_EXNUM)) {
            JSONObject parameter = new JSONObject();
            parameter.put("filterSchemeId", (Object)"");
            map.put("parameter", (String)parameter);
            OpenPageUtils.openAppForCardCount((String)"oeoms", (String)"", map, (IFormView)this.getView());
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)STOCK_EXNUM)) {
            JSONObject parameter = new JSONObject();
            parameter.put("filterSchemeId", (Object)"");
            map.put("parameter", (String)parameter);
            OpenPageUtils.openAppForCardCount((String)"oeoms", (String)"", map, (IFormView)this.getView());
        }
    }

    private String getSchemeId(final String formId, final String schemeName) {
        String sql = "SELECT TOP 1 FSCHEMEID FROM T_BAS_FILTERSCHEME WHERE FFORMID = ? AND FSCHEMENAME = ?";
        Object[] params = new SqlParameter[]{new SqlParameter(":FFORMID", 12, (Object)formId), new SqlParameter(":FSCHEMENAME", 12, (Object)schemeName)};
        FilterScheme filterScheme = (FilterScheme)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<FilterScheme>(){

            public FilterScheme handle(ResultSet rs) throws KDException {
                FilterScheme scheme = new FilterScheme();
                try {
                    while (rs.next()) {
                        scheme.setId(rs.getString(1));
                    }
                }
                catch (SQLException ex) {
                    logger.error(String.format("ExceptionDataCardPlugin excute sql error,formId:%s,schemeName:%s", formId, schemeName), (Throwable)ex);
                }
                return scheme;
            }
        });
        return filterScheme == null ? "" : filterScheme.getId();
    }

    private String saleOrderExnumCount() {
        return "200";
    }

    private String mailnoExnumCount() {
        return "10";
    }

    private String deliveryOutTimeExnumCount() {
        return "80";
    }

    private String stockExnumCount() {
        return "25";
    }
}

