/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.bizrule;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public final class ScConsistencyDataDisposeOpAction
extends AbstractOpBizRuleAction {
    public static final String JOINTDATACHANNELID = "jointdatachannelid";
    private static final Log log = LogFactory.getLog(ScConsistencyDataDisposeOpAction.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add(JOINTDATACHANNELID);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String entityNumber = this.billEntityType.getName();
        String operationKey = e.getOperationKey();
        DynamicObject[] dynamicObjects = e.getDataEntities();
        LinkedHashMap<String, String> customParam = new LinkedHashMap<String, String>(this.getOption().getVariables());
        Boolean verifyResult = Boolean.FALSE;
        String executeInterface = "beforeexecuteoperationtransaction";
        try {
            verifyResult = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurMultiDataHandleService", (String)"verifyOperationService", (Object[])new Object[]{entityNumber, operationKey, executeInterface});
        }
        catch (RuntimeException runtimeException) {
            log.warn(String.valueOf(runtimeException.getMessage()));
        }
        if (verifyResult.booleanValue()) {
            Map<Long, String> billJointDataMap = this.getBillJointDataMap(dynamicObjects);
            this.executeService(entityNumber, operationKey, executeInterface, billJointDataMap, customParam);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String entityNumber = this.billEntityType.getName();
        String operationKey = e.getOperationKey();
        DynamicObject[] dynamicObjects = e.getDataEntities();
        LinkedHashMap<String, String> customParam = new LinkedHashMap<String, String>(this.getOption().getVariables());
        String executeInterface = "afterexecuteoperationtransaction";
        Boolean verifyResult = Boolean.FALSE;
        try {
            verifyResult = (Boolean)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurMultiDataHandleService", (String)"verifyOperationService", (Object[])new Object[]{entityNumber, operationKey, executeInterface});
        }
        catch (RuntimeException runtimeException) {
            log.warn(String.valueOf(runtimeException.getMessage()));
        }
        if (verifyResult.booleanValue()) {
            Map<Long, String> billJointDataMap = this.getBillJointDataMap(dynamicObjects);
            this.executeService(entityNumber, operationKey, executeInterface, billJointDataMap, customParam);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeService(String entityNumber, String operationKey, String executeInterface, Map<Long, String> billJointDataMap, Map<String, String> customParam) throws KDException {
        try {
            String exceptionString;
            String result = (String)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurMultiDataHandleService", (String)"executeService", (Object[])new Object[]{entityNumber, operationKey, executeInterface, billJointDataMap, customParam});
            Map resultMap = (Map)SerializationUtils.fromJsonString((String)result, Map.class);
            if (!resultMap.isEmpty() && (exceptionString = (String)resultMap.get("exception")) != null && !exceptionString.trim().isEmpty()) {
                throw new KDBizException(exceptionString);
            }
        }
        finally {
            log.info(((Object)((Object)this)).getClass().getName() + "{}#afterExecuteOperationTransaction,execute end");
        }
    }

    private Map<Long, String> getBillJointDataMap(DynamicObject[] dynamicObjects) {
        HashMap<Long, String> billJointDataMap = new HashMap<Long, String>(dynamicObjects.length);
        for (DynamicObject bill : dynamicObjects) {
            DynamicObjectCollection rows = bill.getDynamicObjectCollection("materialentry");
            String jointChannelId = "";
            try {
                if (rows != null && !rows.isEmpty() && ((jointChannelId = ((DynamicObject)rows.get(0)).getString(JOINTDATACHANNELID)) == null || jointChannelId.trim().isEmpty())) {
                    jointChannelId = "";
                }
            }
            catch (RuntimeException runtimeException) {
                log.warn(String.valueOf(runtimeException.getMessage()));
            }
            billJointDataMap.put(bill.getLong("id"), jointChannelId);
        }
        return billJointDataMap;
    }
}

