/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.scm.validation;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.scm.Util.OperateTypeVerifyHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public final class VerifyMaxSumStockBasicQtyValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(VerifyMaxSumStockBasicQtyValidator.class);
    private static final String VERIFYBASICQTYDIM = "verifybasicqtydim";
    private static final String ASSISTFIELD = "assistfield";

    public void validate() {
        if (!this.checkOperateType()) {
            return;
        }
        String parameter = String.valueOf(this.getValidation().get("parameter"));
        String verifybasicqtydim = "order";
        String assistField = "warehouse";
        if (parameter != null && !parameter.trim().isEmpty()) {
            Map paramMap = (Map)SerializationUtils.fromJsonString((String)parameter, Map.class);
            verifybasicqtydim = (String)paramMap.get(VERIFYBASICQTYDIM);
            assistField = (String)paramMap.get(ASSISTFIELD);
        }
        String entityKey = this.getValidateContext().getEntityNumber();
        String stockDImField = null;
        String warehouseField = "warehouse";
        String stockMethodName = null;
        if ("order".equals(verifybasicqtydim)) {
            stockDImField = "mainbillentryid";
            stockMethodName = "queryOrderStockBasicQty";
        } else if ("salout".equals(verifybasicqtydim)) {
            stockDImField = "srcsysbillentryid";
            stockMethodName = "querySalOutStockBasicQty";
        } else if ("warehouse".equals(verifybasicqtydim)) {
            stockDImField = "mainbillentryid";
            warehouseField = assistField == null || assistField.isEmpty() ? "warehouse" : assistField;
            stockMethodName = "queryOrderStockBasicQty";
        }
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        HashSet<Object> verifyBillEntryPks = new HashSet<Object>(1024);
        HashMap<String, BigDecimal> orderDimMap = new HashMap<String, BigDecimal>(1024);
        HashMap coreBillEntryOfAssistDataMap = new HashMap(1024);
        DynamicObject bill = null;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            bill = (DynamicObject)dynamicObject.getParent();
            if (!this.checkBill(bill) || !this.checkEntry(dynamicObject)) continue;
            BigDecimal bigDecimal = dynamicObject.getBigDecimal("baseqty");
            String stockDimEntryId = dynamicObject.getString(stockDImField);
            BigDecimal stepOrderQty = (BigDecimal)orderDimMap.get(stockDimEntryId);
            if (stepOrderQty == null) {
                stepOrderQty = BigDecimal.ZERO;
            }
            stepOrderQty = stepOrderQty.add(bigDecimal);
            orderDimMap.put(stockDimEntryId, stepOrderQty);
            HashSet<Long> wareHouseColl = (HashSet<Long>)coreBillEntryOfAssistDataMap.get(stockDimEntryId);
            if (wareHouseColl == null) {
                wareHouseColl = new HashSet<Long>(1024);
            }
            Long warehouseId = dynamicObject.getLong(warehouseField + ".id");
            wareHouseColl.add(warehouseId);
            coreBillEntryOfAssistDataMap.put(stockDimEntryId, wareHouseColl);
            verifyBillEntryPks.add(dynamicObject.get(stockDImField));
        }
        if (!verifyBillEntryPks.isEmpty()) {
            Object orderDimDataMap;
            HashMap srmStockDimMap = new HashMap(verifyBillEntryPks.size());
            try {
                HashSet queryBillEntryIdsParam = new HashSet(verifyBillEntryPks.size());
                verifyBillEntryPks.forEach(row -> queryBillEntryIdsParam.add(row.toString()));
                HashMap<String, String> customParamMap = new HashMap<String, String>(2);
                if ("warehouse".equals(verifybasicqtydim)) {
                    customParamMap.put("warehouseAssistData", SerializationUtils.toJsonString(coreBillEntryOfAssistDataMap));
                }
                customParamMap.put("sourceJointChannelId", "24BNIGS5JY/Z");
                orderDimDataMap = (Map)DispatchServiceHelper.invokeBizService((String)"scm", (String)"pur", (String)"IPurAvailableStockBasicQtyService", (String)stockMethodName, (Object[])new Object[]{queryBillEntryIdsParam, customParamMap});
                if (!orderDimDataMap.isEmpty()) {
                    for (Map.Entry entry : orderDimDataMap.entrySet()) {
                        srmStockDimMap.put(entry.getKey(), new BigDecimal((String)entry.getValue()));
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                if (log.isWarnEnabled()) {
                    log.warn("runtimeExceptionMessage:{}", (Object)String.valueOf(runtimeException.getCause().getMessage()));
                }
                throw runtimeException;
            }
            if (!srmStockDimMap.isEmpty()) {
                QFilter qFilter = new QFilter("isvirtualbill", "=", (Object)"0").and(new QFilter("ischargeoff", "=", (Object)"0")).and(new QFilter("ischargeoffed", "=", (Object)"0"));
                if ("order".equals(verifybasicqtydim)) {
                    qFilter = new QFilter("billentry.mainbillentryid", "in", verifyBillEntryPks);
                } else if ("salout".equals(verifybasicqtydim)) {
                    qFilter = new QFilter("billentry.srcsysbillentryid", "in", verifyBillEntryPks);
                } else if ("warehouse".equals(verifybasicqtydim)) {
                    HashSet wareHouseIds = new HashSet(1024);
                    for (Map.Entry entry : coreBillEntryOfAssistDataMap.entrySet()) {
                        Collection collection = (Collection)entry.getValue();
                        if (collection == null || collection.isEmpty()) continue;
                        wareHouseIds.addAll(collection);
                    }
                    qFilter = new QFilter("billentry.mainbillentryid", "in", verifyBillEntryPks).and(new QFilter("billentry.warehouse", "in", wareHouseIds));
                }
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)"VerifyMaxSumStockBasicQtyOpAction", (String)entityKey, (String)"billentry.mainbillentryid mainbillentryid,billentry.srcsysbillentryid srcsysbillentryid,billentry.baseqty baseqty", (QFilter[])new QFilter[]{qFilter}, (String)"id");
                orderDimDataMap = null;
                try {
                    DataSet dataSet2 = dataSet.groupBy(new String[]{"mainbillentryid", "srcsysbillentryid", "baseqty"}).sum("baseqty").finish();
                    while (dataSet2.hasNext()) {
                        Row row2 = dataSet2.next();
                        BigDecimal baseQty = row2.getBigDecimal("baseqty");
                        String stockDimEntryId = row2.getString(stockDImField);
                        BigDecimal stepOrderQty = (BigDecimal)orderDimMap.get(stockDimEntryId);
                        if (stepOrderQty == null) {
                            stepOrderQty = BigDecimal.ZERO;
                        }
                        stepOrderQty = stepOrderQty.add(baseQty);
                        orderDimMap.put(stockDimEntryId, stepOrderQty);
                    }
                    dataSet2.close();
                }
                catch (Throwable throwable) {
                    orderDimDataMap = throwable;
                    throw throwable;
                }
                finally {
                    if (dataSet != null) {
                        if (orderDimDataMap != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)orderDimDataMap).addSuppressed(throwable);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                StringBuilder checkMessage = null;
                int rowIndex = 1;
                for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                    checkMessage = new StringBuilder();
                    DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
                    String mainBillNumber = dynamicObject.getString("mainbillnumber");
                    String stockDimEntryId = dynamicObject.getString(stockDImField);
                    BigDecimal stockDimQty = (BigDecimal)orderDimMap.get(stockDimEntryId);
                    BigDecimal srmStockDimQty = (BigDecimal)srmStockDimMap.get(stockDimEntryId);
                    if (stockDimQty != null && stockDimQty.compareTo(srmStockDimQty) > 0) {
                        checkMessage.append(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u786e\u8ba4\u63a5\u6536\u540e\uff0c\u8ba2\u5355{1}\u7684\u5173\u8054\u6570\u91cf\u5c06\u8d85\u8fc7\u4f9b\u5e94\u5546\u53d1\u8d27\u6570\u91cf\u3002", (String)"VerifyMaxSumStockBasicQtyValidator_0", (String)"bos-ext-scm", (Object[])new Object[]{rowIndex, mainBillNumber, stockDimQty.toPlainString(), srmStockDimQty.toPlainString()}));
                    }
                    ++rowIndex;
                    if (checkMessage.length() <= 0) continue;
                    this.addMessage(extendedDataEntity, checkMessage.toString());
                }
            }
        }
    }

    public Set<String> preparePropertys() {
        Set propertys = super.preparePropertys();
        propertys.add("supplier");
        propertys.add("qty");
        propertys.add("seq");
        propertys.add("baseqty");
        propertys.add("mainbillentryid");
        propertys.add("srcsysbillentryid");
        propertys.add("mainbillnumber");
        propertys.add("invscheme");
        propertys.add("warehouse");
        propertys.add("isvirtualbill");
        propertys.add("ischargeoffed");
        propertys.add("ischargeoff");
        propertys.add("srcbillentity");
        return propertys;
    }

    public String getEntityKey() {
        return "billentry";
    }

    private boolean checkOperateType() {
        return OperateTypeVerifyHelper.verifyOperateTypeCanExecute(this.entityKey, this.getOperateType());
    }

    private boolean checkBill(DynamicObject bill) {
        boolean issuppcolla;
        DynamicObject supplier;
        String bizdirection;
        DynamicObject invscheme;
        Boolean checkFlag = Boolean.TRUE;
        boolean isvirtualbill = bill.getBoolean("isvirtualbill");
        if (isvirtualbill) {
            checkFlag = Boolean.FALSE;
        }
        if ((invscheme = bill.getDynamicObject("invscheme")) != null && "1".equals(bizdirection = invscheme.getString("bizdirection"))) {
            checkFlag = Boolean.FALSE;
        }
        if ((supplier = bill.getDynamicObject("supplier")) != null && !(issuppcolla = supplier.getBoolean("issuppcolla"))) {
            checkFlag = Boolean.FALSE;
        }
        return checkFlag;
    }

    private boolean checkEntry(DynamicObject row) {
        Boolean checkFlag = Boolean.TRUE;
        String srcbillentity = row.getString("srcbillentity");
        if (!"pm_purorderbill".equals(srcbillentity)) {
            checkFlag = Boolean.FALSE;
        }
        return checkFlag;
    }
}

