/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.filter.comparetypeconfig;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.SqlParameter;
import kd.bos.entity.filter.ConditionVariableContext;
import kd.bos.entity.filter.FilterField;
import kd.bos.ext.hr.constants.CommonConstants;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;

public class QueryPersonModelIdService {
    private static final Log LOGGER = LogFactory.getLog(QueryPersonModelIdService.class);

    public static void getVariableFilter(ConditionVariableContext ctx, boolean currUser) {
        LOGGER.info("QueryPersonModelIdService_getVariableFilter_start");
        long userId = ctx.getUserService().getCurrentUserId();
        FilterField filterField = ctx.getFilterRow().getFilterField().convertToId();
        String fieldName = filterField.getFullFieldName();
        String refEntityId = filterField.getRefEntityId();
        String filterType = "in";
        if (!currUser) {
            filterType = "not in";
        }
        if (CommonConstants.PERSON_QUERY_PROP.contains(refEntityId)) {
            String filter;
            List<Long> personId = QueryPersonModelIdService.getPersonModelId(userId, refEntityId);
            ctx.setQFilter(new QFilter(fieldName, filterType, personId));
            if (ctx.isParam()) {
                SqlParameter sqlParam = new SqlParameter(fieldName, ctx.getColType(), personId);
                ctx.getParam().add(sqlParam);
                filter = String.format("%s %s ?", fieldName, filterType);
            } else {
                if (ctx.getOperater() == null) {
                    LOGGER.warn("getVariableFilter_filter_NULL");
                    return;
                }
                filter = String.format("%s %s %s", fieldName, ctx.getOperater(), personId);
            }
            LOGGER.info("QueryPersonModelIdService_getVariableFilter_{}", (Object)filter);
            ctx.setFilter(filter);
        }
    }

    public static void getScriptFilter(ConditionVariableContext ctx, boolean currUser) {
        LOGGER.info("QueryPersonModelIdService_getScriptFilter_start");
        FilterField filterField = ctx.getFilterRow().getFilterField().convertToId();
        String refEntityId = filterField.getRefEntityId();
        long userId = ctx.getUserService().getCurrentUserId();
        if (CommonConstants.PERSON_QUERY_PROP.contains(refEntityId)) {
            List<Long> personIds;
            String filterType = "in";
            if (!currUser) {
                filterType = "not in";
            }
            if (!CollectionUtils.isEmpty(personIds = QueryPersonModelIdService.getPersonModelId(userId, refEntityId))) {
                String ids = personIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                String script = String.format("%s %s %s", ctx.getFilterRow().getFilterField().convertToId().getFieldName(), filterType, "(" + ids + ")");
                LOGGER.info("QueryPersonModelIdService_getScriptFilter_{}", (Object)script);
                ctx.setScript(script);
            }
        }
    }

    private static List<Long> getPersonModelId(long userId, String entityName) {
        List list;
        Map dataMap;
        ArrayList<Long> userIds = new ArrayList<Long>();
        userIds.add(userId);
        Map retMap = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hrpi", (String)"IHRPIDepempService", (String)"listPersonAllEmpOrgRel", (Object[])new Object[]{"user", userIds});
        LOGGER.info("QueryPersonModelIdService_getPersonModelId_{}", (Object)retMap);
        if (retMap != null && retMap.containsKey("success") && ((Boolean)retMap.get("success")).booleanValue() && (dataMap = (Map)retMap.get("data")) != null && !CollectionUtils.isEmpty((Collection)(list = (List)dataMap.get(userId)))) {
            if ("hrpi_personf7query".equals(entityName)) {
                return list.stream().map(tempMap -> (Long)tempMap.get("person_id")).collect(Collectors.toList());
            }
            if ("hrpi_employeef7query".equals(entityName)) {
                return list.stream().map(tempMap -> (Long)tempMap.get("employee_id")).collect(Collectors.toList());
            }
            if ("hrpi_depempf7query".equals(entityName)) {
                return list.stream().map(tempMap -> (Long)tempMap.get("depemp_id")).collect(Collectors.toList());
            }
        }
        return userIds;
    }
}

